/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.command.Util;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class Inspect {
    public static final String NONSTANDARD_SERVICE_NAMESPACE = "service";
    public static final String CAPABILITY = "capability";
    public static final String REQUIREMENT = "requirement";
    private static final String EMPTY_MESSAGE = "[EMPTY]";
    private static final String UNUSED_MESSAGE = "[UNUSED]";
    private static final String UNRESOLVED_MESSAGE = "[UNRESOLVED]";
    private final BundleContext m_bc;

    public Inspect(BundleContext bc) {
        this.m_bc = bc;
    }

    @Descriptor(value="inspects bundle capabilities and requirements")
    public void inspect(@Descriptor(value="('capability' | 'requirement')") String direction, @Descriptor(value="(<namespace> | 'service')") String namespace, @Descriptor(value="target bundles") Bundle[] bundles) {
        Inspect.inspect(this.m_bc, direction, namespace, bundles);
    }

    private static void inspect(BundleContext bc, String direction, String namespace, Bundle[] bundles) {
        if (Inspect.isValidDirection(direction)) {
            Bundle[] bundleArray = bundles = bundles == null || bundles.length == 0 ? bc.getBundles() : bundles;
            if (CAPABILITY.startsWith(direction)) {
                Inspect.printCapabilities(bc, Util.parseSubstring(namespace), bundles);
            } else {
                Inspect.printRequirements(bc, Util.parseSubstring(namespace), bundles);
            }
        } else if (!Inspect.isValidDirection(direction)) {
            System.out.println("Invalid argument: " + direction);
        }
    }

    public static void printCapabilities(BundleContext bc, List<String> namespace, Bundle[] bundles) {
        boolean separatorNeeded = false;
        for (Bundle b : bundles) {
            BundleWiring wiring;
            if (separatorNeeded) {
                System.out.println("");
            }
            if ((wiring = (BundleWiring)b.adapt(BundleWiring.class)) != null) {
                String title = b + " provides:";
                System.out.println(title);
                System.out.println(Util.getUnderlineString(title.length()));
                boolean matches = Inspect.printMatchingCapabilities(wiring, namespace);
                if (Inspect.matchNamespace(namespace, NONSTANDARD_SERVICE_NAMESPACE)) {
                    matches |= Inspect.printServiceCapabilities(b);
                }
                if (!matches) {
                    System.out.println(Util.unparseSubstring(namespace) + " " + EMPTY_MESSAGE);
                }
            } else {
                System.out.println("Bundle " + b.getBundleId() + " is not resolved.");
            }
            separatorNeeded = true;
        }
    }

    private static boolean printMatchingCapabilities(BundleWiring wiring, List<String> namespace) {
        List wires = wiring.getProvidedWires(null);
        Map<BundleCapability, List<BundleWire>> aggregateCaps = Inspect.aggregateCapabilities(namespace, wires);
        List allCaps = wiring.getCapabilities(null);
        boolean matches = false;
        for (BundleCapability cap : allCaps) {
            if (!Inspect.matchNamespace(namespace, cap.getNamespace())) continue;
            matches = true;
            List<BundleWire> dependents = aggregateCaps.get(cap);
            Object keyAttr = cap.getAttributes().get(cap.getNamespace());
            if (dependents != null) {
                String msg = keyAttr != null ? cap.getNamespace() + "; " + keyAttr + " " + Inspect.getVersionFromCapability(cap) : cap.toString();
                msg = msg + " required by:";
                System.out.println(msg);
                for (BundleWire wire : dependents) {
                    System.out.println("   " + wire.getRequirerWiring().getBundle());
                }
                continue;
            }
            if (keyAttr != null) {
                System.out.println(cap.getNamespace() + "; " + cap.getAttributes().get(cap.getNamespace()) + " " + Inspect.getVersionFromCapability(cap) + " " + UNUSED_MESSAGE);
                continue;
            }
            System.out.println(cap + " " + UNUSED_MESSAGE);
        }
        return matches;
    }

    private static Map<BundleCapability, List<BundleWire>> aggregateCapabilities(List<String> namespace, List<BundleWire> wires) {
        HashMap<BundleCapability, List<BundleWire>> map = new HashMap<BundleCapability, List<BundleWire>>();
        for (BundleWire wire : wires) {
            if (!Inspect.matchNamespace(namespace, wire.getCapability().getNamespace())) continue;
            ArrayList<BundleWire> dependents = (ArrayList<BundleWire>)map.get(wire.getCapability());
            if (dependents == null) {
                dependents = new ArrayList<BundleWire>();
                map.put(wire.getCapability(), dependents);
            }
            dependents.add(wire);
        }
        return map;
    }

    static boolean printServiceCapabilities(Bundle b) {
        boolean matches = false;
        try {
            ServiceReference[] refs = b.getRegisteredServices();
            if (refs != null && refs.length > 0) {
                matches = true;
                for (ServiceReference ref : refs) {
                    String[] keys;
                    System.out.println("service; " + Util.getValueString(ref.getProperty("objectClass")) + " with properties:");
                    for (String key : keys = ref.getPropertyKeys()) {
                        if (key.equalsIgnoreCase("objectClass")) continue;
                        Object v = ref.getProperty(key);
                        System.out.println("   " + key + " = " + Util.getValueString(v));
                    }
                    Bundle[] users = ref.getUsingBundles();
                    if (users == null || users.length <= 0) continue;
                    System.out.println("   Used by:");
                    for (Bundle user : users) {
                        System.out.println("      " + user);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
        return matches;
    }

    public static void printRequirements(BundleContext bc, List<String> namespace, Bundle[] bundles) {
        boolean separatorNeeded = false;
        for (Bundle b : bundles) {
            BundleWiring wiring;
            if (separatorNeeded) {
                System.out.println("");
            }
            if ((wiring = (BundleWiring)b.adapt(BundleWiring.class)) != null) {
                String title = b + " requires:";
                System.out.println(title);
                System.out.println(Util.getUnderlineString(title.length()));
                boolean matches = Inspect.printMatchingRequirements(wiring, namespace);
                if (Inspect.matchNamespace(namespace, NONSTANDARD_SERVICE_NAMESPACE)) {
                    matches |= Inspect.printServiceRequirements(b);
                }
                if (!matches) {
                    System.out.println(Util.unparseSubstring(namespace) + " " + EMPTY_MESSAGE);
                }
            } else {
                System.out.println("Bundle " + b.getBundleId() + " is not resolved.");
            }
            separatorNeeded = true;
        }
    }

    private static boolean printMatchingRequirements(BundleWiring wiring, List<String> namespace) {
        List wires = wiring.getRequiredWires(null);
        Map<BundleRequirement, List<BundleWire>> aggregateReqs = Inspect.aggregateRequirements(namespace, wires);
        List allReqs = wiring.getRequirements(null);
        boolean matches = false;
        for (BundleRequirement req : allReqs) {
            if (!Inspect.matchNamespace(namespace, req.getNamespace())) continue;
            matches = true;
            List<BundleWire> providers = aggregateReqs.get(req);
            if (providers != null) {
                System.out.println(req.getNamespace() + "; " + (String)req.getDirectives().get("filter") + " resolved by:");
                for (BundleWire wire : providers) {
                    Object keyAttr = wire.getCapability().getAttributes().get(wire.getCapability().getNamespace());
                    String msg = keyAttr != null ? wire.getCapability().getNamespace() + "; " + keyAttr + " " + Inspect.getVersionFromCapability(wire.getCapability()) : wire.getCapability().toString();
                    msg = "   " + msg + " from " + wire.getProviderWiring().getBundle();
                    System.out.println(msg);
                }
                continue;
            }
            System.out.println(req.getNamespace() + "; " + (String)req.getDirectives().get("filter") + " " + UNRESOLVED_MESSAGE);
        }
        return matches;
    }

    private static Map<BundleRequirement, List<BundleWire>> aggregateRequirements(List<String> namespace, List<BundleWire> wires) {
        HashMap<BundleRequirement, List<BundleWire>> map = new HashMap<BundleRequirement, List<BundleWire>>();
        for (BundleWire wire : wires) {
            if (!Inspect.matchNamespace(namespace, wire.getRequirement().getNamespace())) continue;
            ArrayList<BundleWire> providers = (ArrayList<BundleWire>)map.get(wire.getRequirement());
            if (providers == null) {
                providers = new ArrayList<BundleWire>();
                map.put(wire.getRequirement(), providers);
            }
            providers.add(wire);
        }
        return map;
    }

    static boolean printServiceRequirements(Bundle b) {
        boolean matches = false;
        try {
            ServiceReference[] refs = b.getServicesInUse();
            if (refs != null && refs.length > 0) {
                matches = true;
                for (ServiceReference ref : refs) {
                    System.out.println("service; " + Util.getValueString(ref.getProperty("objectClass")) + " provided by:");
                    System.out.println("   " + ref.getBundle());
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
        return matches;
    }

    private static String getVersionFromCapability(BundleCapability c) {
        Object o = c.getAttributes().get("version");
        if (o == null) {
            o = c.getAttributes().get("bundle-version");
        }
        return o == null ? "" : o.toString();
    }

    private static boolean matchNamespace(List<String> namespace, String actual) {
        return Util.compareSubstring(namespace, actual);
    }

    private static boolean isValidDirection(String direction) {
        return CAPABILITY.startsWith(direction) || REQUIREMENT.startsWith(direction);
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }
}

