/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree.WeightedTreeView;
import org.eclipse.tracecompass.internal.tmf.ui.widgets.piechart.PieSlice;
import org.eclipse.tracecompass.internal.tmf.ui.widgets.piechart.TmfPieChart;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;

public class WeightedTreePieChartViewer
extends TmfTimeViewer {
    private static final float MIN_PRECENTAGE_TO_SHOW_SLICE = 0.01f;
    private @Nullable TmfPieChart fGlobalPC = null;
    private final Listener fMouseMoveListener;
    private final MouseListener fMouseClickListener;
    private ListenerList fSelectedListeners = new ListenerList(1);
    private IWeightedTreeProvider.MetricType fWeightType = new IWeightedTreeProvider.MetricType(String.valueOf(Messages.WeightedTreeViewer_Weight), IWeightedTreeProvider.DataType.NUMBER, null);
    private TimeGraphColorScheme fColorScheme = new TimeGraphColorScheme();
    private final WeightedTreeView fView;
    private @Nullable PieChartPalette fPiePalette = null;

    public WeightedTreePieChartViewer(@Nullable Composite parent, WeightedTreeView view) {
        super(parent);
        if (parent != null) {
            parent.addDisposeListener(e -> this.fColorScheme.dispose());
        }
        this.fView = view;
        this.fMouseMoveListener = new Listener(){

            public void handleEvent(@Nullable Event event) {
                if (event == null) {
                    return;
                }
                TmfPieChart pc = (TmfPieChart)event.widget;
                switch (event.type) {
                    case 5: {
                        PieSlice slice = pc.getSliceFromPosition(event.x, event.y);
                        if (slice == null) {
                            pc.setToolTipText(null);
                            break;
                        }
                        long value = (long)slice.getValue();
                        float percOfSlice = (float)((double)value / pc.getTotal() * 100.0);
                        String percent = String.format("%.1f", Float.valueOf(percOfSlice));
                        String text = String.valueOf(slice.getLabel()) + "\n";
                        text = String.valueOf(text) + WeightedTreePieChartViewer.this.fWeightType.format((Object)value) + " (" + percent + "%)";
                        pc.setToolTipText(text);
                        return;
                    }
                }
            }
        };
        this.fMouseClickListener = new MouseListener(){

            public void mouseUp(@Nullable MouseEvent e) {
            }

            public void mouseDown(@Nullable MouseEvent e) {
                if (e == null) {
                    return;
                }
                TmfPieChart pc = (TmfPieChart)e.widget;
                PieSlice slice = pc.getSliceFromPosition(e.x, e.y);
                if (slice == null) {
                    return;
                }
                String id = slice.getID();
                WeightedTreePieChartViewer.this.select(id);
                Event selectionEvent = new Event();
                selectionEvent.text = slice.getLabel();
                WeightedTreePieChartViewer.this.notifySelectionListener(selectionEvent);
            }

            public void mouseDoubleClick(@Nullable MouseEvent e) {
            }
        };
    }

    public void select(@Nullable String id) {
        if (id == null) {
            return;
        }
        TmfPieChart pieChart = this.fGlobalPC;
        if (pieChart != null) {
            pieChart.select(id);
            pieChart.redraw();
        }
    }

    public void loadTrace(final @Nullable ITmfTrace trace) {
        super.loadTrace(trace);
        if (trace == null) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                WeightedTreePieChartViewer.this.initializeDataSource(trace);
            }
        };
        thread.start();
    }

    private synchronized void initializeDataSource(ITmfTrace trace) {
        Set<IWeightedTreeProvider<?, ?, WeightedTree<?>>> modules = this.fView.getWeightedTrees(trace);
        modules.forEach(m -> {
            if (m instanceof IAnalysisModule) {
                ((IAnalysisModule)m).schedule();
            }
        });
    }

    synchronized void updateGlobalPieChart(Set<WeightedTree<?>> trees, IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        long totalWeight = WeightedTreePieChartViewer.getTotalWeight(trees);
        TmfPieChart pie = this.getGlobalPC();
        if (pie == null || totalWeight == 0L) {
            pie = this.createPieChart(treeProvider);
            this.setGlobalPC(pie);
            this.fWeightType = treeProvider.getWeightType();
            this.setPalette(treeProvider.getPalette());
        }
        if (totalWeight > 0L) {
            this.updatePieChartWithData(pie, trees, treeProvider, totalWeight);
        }
        pie.redraw();
    }

    private synchronized void setPalette(IDataPalette palette) {
        PieChartPalette currentPalette = this.fPiePalette;
        if (currentPalette == null || !palette.equals(currentPalette.fPalette)) {
            this.fPiePalette = new PieChartPalette(palette);
        }
    }

    private TmfPieChart createPieChart(IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        TmfPieChart pie = new TmfPieChart(this.getParent(), 0);
        Color backgroundColor = this.fColorScheme.getColor(38);
        Color foregroundColor = this.fColorScheme.getColor(39);
        pie.getTitle().setText(treeProvider.getTitle());
        pie.getTitle().setForeground(foregroundColor);
        pie.setBackground(backgroundColor);
        pie.setForeground(foregroundColor);
        pie.getAxisSet().getXAxis(0).getTitle().setText("");
        pie.getAxisSet().getXAxis(0).getTitle().setForeground(foregroundColor);
        pie.getLegend().setVisible(true);
        pie.getLegend().setPosition(131072);
        pie.getLegend().setBackground(backgroundColor);
        pie.getLegend().setForeground(foregroundColor);
        pie.addListener(5, this.fMouseMoveListener);
        pie.addMouseListener(this.fMouseClickListener);
        return pie;
    }

    private static long getTotalWeight(Collection<WeightedTree<?>> trees) {
        if (trees.isEmpty()) {
            return 0L;
        }
        long totalWeight = 0L;
        for (WeightedTree<?> tree : trees) {
            totalWeight += tree.getWeight();
        }
        return totalWeight;
    }

    private void updatePieChartWithData(TmfPieChart chart, Collection<WeightedTree<?>> trees, IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider, long totalWeight) {
        chart.clear();
        long otherWeight = 0L;
        WeightedTree<?> otherTree = null;
        ArrayList list = new ArrayList();
        for (WeightedTree<?> tree : trees) {
            if ((float)tree.getWeight() / (float)totalWeight > 0.01f) {
                list.add(tree);
                continue;
            }
            otherWeight += tree.getWeight();
            otherTree = tree;
        }
        Collections.sort(list, Collections.reverseOrder());
        PieChartPalette palette = this.fPiePalette;
        for (WeightedTree weightedTree : list) {
            String sliceName = treeProvider.toDisplayString(weightedTree);
            if (palette != null) {
                chart.addColor(sliceName, palette.getColor(weightedTree).getRGB());
            }
            chart.addPieSlice(sliceName, (double)weightedTree.getWeight(), sliceName);
        }
        if (otherWeight != 0L) {
            String string;
            String string2 = string = otherTree != null && otherTree.getWeight() == otherWeight ? treeProvider.toDisplayString(otherTree) : Messages.WeightedTreeViewer_Other;
            if (otherTree != null && otherTree.getWeight() == otherWeight && palette != null) {
                chart.addColor(string, palette.getColor(otherTree).getRGB());
            }
            chart.addPieSlice(string, (double)otherWeight, string);
        }
    }

    public void addSelectionListener(Listener l) {
        this.fSelectedListeners.add((Object)l);
    }

    public void removeSelectionListener(Listener l) {
        this.fSelectedListeners.remove((Object)l);
    }

    private void notifySelectionListener(Event e) {
        Object[] objectArray = this.fSelectedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((Listener)o).handleEvent(e);
            ++n2;
        }
    }

    synchronized @Nullable TmfPieChart getGlobalPC() {
        return this.fGlobalPC;
    }

    private synchronized void setGlobalPC(TmfPieChart pie) {
        TmfPieChart pc = this.fGlobalPC;
        if (pc != null) {
            pc.dispose();
        }
        this.fGlobalPC = pie;
    }

    public void elementSelected(Set<WeightedTree<?>> trees, IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        this.updateGlobalPieChart(trees, treeProvider);
    }

    public @Nullable Control getControl() {
        return this.getParent();
    }

    public void refresh() {
    }

    private class PieChartPalette {
        private final IDataPalette fPalette;
        private final StyleManager fStyleManager;
        private final Map<OutputElementStyle, Color> fColors = new HashMap<OutputElementStyle, Color>();

        private PieChartPalette(IDataPalette palette) {
            this.fPalette = palette;
            this.fStyleManager = new StyleManager(palette.getStyles());
        }

        public Color getColor(WeightedTree<?> tree) {
            @NonNull OutputElementStyle style = this.fPalette.getStyleFor(tree);
            return this.fColors.computeIfAbsent(style, st -> {
                @NonNull RGBAColor colorStyle = this.fStyleManager.getColorStyle(st, "background-color");
                if (colorStyle == null) {
                    colorStyle = this.fStyleManager.getColorStyle(st, "color");
                }
                if (colorStyle == null) {
                    return WeightedTreePieChartViewer.this.fColorScheme.getColor(2);
                }
                return WeightedTreePieChartViewer.this.fColorScheme.getColor(new RGBA((int)colorStyle.getRed(), (int)colorStyle.getGreen(), (int)colorStyle.getBlue(), (int)colorStyle.getAlpha()));
            });
        }
    }
}

