/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractVirtualTreeProvider
implements ITreeContentProvider {
    public static final IPath ROOT = new Path("");
    private final Map<IPath, Collection<Object>> fElements = new HashMap<IPath, Collection<Object>>();
    private final Map<IPath, Object> fReplacements = new HashMap<IPath, Object>();
    private boolean fShowRoot = false;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        this.fElements.clear();
        this.populateElements(inputElement);
        if (this.fElements.isEmpty()) {
            this.registerPath(ROOT);
        }
        if (this.fShowRoot) {
            if (this.fReplacements.containsKey(ROOT)) {
                return new Object[]{this.fReplacements.get(ROOT)};
            }
            return new Object[]{ROOT};
        }
        return this.replaceElements(this.fElements.get(ROOT));
    }

    public Object[] getChildren(Object parentElement) {
        Object treeElement = this.findPathForReplacement(parentElement);
        return this.replaceElements(this.fElements.get(treeElement));
    }

    public Object getParent(Object element) {
        Object treeElement = this.findPathForReplacement(element);
        for (Map.Entry<IPath, Collection<Object>> entry : this.fElements.entrySet()) {
            if (!entry.getValue().contains(treeElement)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        Object treeElement = this.findPathForReplacement(element);
        return this.fElements.containsKey(treeElement) && !this.fElements.get(treeElement).isEmpty();
    }

    public void registerElement(IPath path, Object element) {
        path = path.makeRelative();
        this.registerPath(path);
        this.fElements.get(path).add(element);
    }

    public void registerPath(IPath path) {
        if (!this.fElements.containsKey(path = path.makeRelative())) {
            this.fElements.put(path, new HashSet());
            if (!path.isEmpty()) {
                IPath parent = path.removeLastSegments(1);
                this.registerPath(parent);
                this.fElements.get(parent).add(path);
            }
        }
    }

    public void registerNodeReplacement(IPath path, Object element) {
        if (element instanceof IPath) {
            throw new RuntimeException("Cannot replace a path with another path");
        }
        this.fReplacements.put(path, element);
    }

    public void setShowRoot(boolean showRoot) {
        this.fShowRoot = showRoot;
    }

    private Object[] replaceElements(Collection<Object> elements) {
        if (elements == null) {
            return new Object[0];
        }
        HashSet<Object> result = new HashSet<Object>(elements);
        for (Object element : elements) {
            if (!this.fReplacements.containsKey(element)) continue;
            result.remove(element);
            result.add(this.fReplacements.get(element));
        }
        return result.toArray(new Object[result.size()]);
    }

    private Object findPathForReplacement(Object replacement) {
        if (replacement instanceof IPath) {
            return replacement;
        }
        if (this.fReplacements.values().contains(replacement)) {
            for (Map.Entry<IPath, Object> entry : this.fReplacements.entrySet()) {
                if (!replacement.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return replacement;
    }

    protected abstract void populateElements(Object var1);
}

