/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElementRule;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.internal.utils.StringUtils;

public final class ThemeTrieElement {
    private final ThemeTrieElementRule _mainRule;
    private final List<ThemeTrieElementRule> _rulesWithParentScopes;
    private final Map<String, ThemeTrieElement> _children;

    public ThemeTrieElement(ThemeTrieElementRule mainRule) {
        this(mainRule, new ArrayList<ThemeTrieElementRule>(), new HashMap<String, ThemeTrieElement>());
    }

    public ThemeTrieElement(ThemeTrieElementRule mainRule, List<ThemeTrieElementRule> rulesWithParentScopes) {
        this(mainRule, rulesWithParentScopes, new HashMap<String, ThemeTrieElement>());
    }

    public ThemeTrieElement(ThemeTrieElementRule mainRule, List<ThemeTrieElementRule> rulesWithParentScopes, Map<String, ThemeTrieElement> children) {
        this._mainRule = mainRule;
        this._rulesWithParentScopes = rulesWithParentScopes;
        this._children = children;
    }

    private static List<ThemeTrieElementRule> _sortBySpecificity(List<ThemeTrieElementRule> arr) {
        if (arr.size() == 1) {
            return arr;
        }
        arr.sort(ThemeTrieElement::_cmpBySpecificity);
        return arr;
    }

    private static int _cmpBySpecificity(ThemeTrieElementRule a, ThemeTrieElementRule b) {
        if (a.scopeDepth == b.scopeDepth) {
            int bParentScopesLen;
            List<String> aParentScopes = a.parentScopes;
            List<String> bParentScopes = b.parentScopes;
            int aParentScopesLen = aParentScopes == null ? 0 : aParentScopes.size();
            int n = bParentScopesLen = bParentScopes == null ? 0 : bParentScopes.size();
            if (aParentScopesLen == bParentScopesLen) {
                int i = 0;
                while (i < aParentScopesLen) {
                    int bLen;
                    String aScope = aParentScopes.get(i);
                    String bScope = bParentScopes.get(i);
                    int aLen = aScope.length();
                    if (aLen != (bLen = bScope.length())) {
                        return bLen - aLen;
                    }
                    ++i;
                }
            }
            return bParentScopesLen - aParentScopesLen;
        }
        return b.scopeDepth - a.scopeDepth;
    }

    public List<ThemeTrieElementRule> match(String scope) {
        String tail;
        String head;
        if ("".equals(scope)) {
            return ThemeTrieElement._sortBySpecificity(MoreCollections.asArrayList(this._mainRule, this._rulesWithParentScopes));
        }
        int dotIndex = scope.indexOf(46);
        if (dotIndex == -1) {
            head = scope;
            tail = "";
        } else {
            head = scope.substring(0, dotIndex);
            tail = scope.substring(dotIndex + 1);
        }
        if (this._children.containsKey(head)) {
            return this._children.get(head).match(tail);
        }
        return ThemeTrieElement._sortBySpecificity(MoreCollections.asArrayList(this._mainRule, this._rulesWithParentScopes));
    }

    public void insert(int scopeDepth, String scope, @Nullable List<String> parentScopes, int fontStyle, int foreground, int background) {
        ThemeTrieElement child;
        String tail;
        String head;
        if (scope.isEmpty()) {
            this.doInsertHere(scopeDepth, parentScopes, fontStyle, foreground, background);
            return;
        }
        int dotIndex = scope.indexOf(46);
        if (dotIndex == -1) {
            head = scope;
            tail = "";
        } else {
            head = scope.substring(0, dotIndex);
            tail = scope.substring(dotIndex + 1);
        }
        if (this._children.containsKey(head)) {
            child = this._children.get(head);
        } else {
            child = new ThemeTrieElement(this._mainRule.clone(), ThemeTrieElementRule.cloneArr(this._rulesWithParentScopes));
            this._children.put(head, child);
        }
        child.insert(scopeDepth + 1, tail, parentScopes, fontStyle, foreground, background);
    }

    private void doInsertHere(int scopeDepth, @Nullable List<String> parentScopes, int fontStyle, int foreground, int background) {
        if (parentScopes == null) {
            this._mainRule.acceptOverwrite(scopeDepth, fontStyle, foreground, background);
            return;
        }
        for (ThemeTrieElementRule rule : this._rulesWithParentScopes) {
            if (StringUtils.strArrCmp(rule.parentScopes, parentScopes) != 0) continue;
            rule.acceptOverwrite(scopeDepth, fontStyle, foreground, background);
            return;
        }
        if (fontStyle == -1) {
            fontStyle = this._mainRule.fontStyle;
        }
        if (foreground == 0) {
            foreground = this._mainRule.foreground;
        }
        if (background == 0) {
            background = this._mainRule.background;
        }
        this._rulesWithParentScopes.add(new ThemeTrieElementRule(scopeDepth, parentScopes, fontStyle, foreground, background));
    }

    public int hashCode() {
        int result = 31 + this._children.hashCode();
        result = 31 * result + this._mainRule.hashCode();
        return 31 * result + this._rulesWithParentScopes.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ThemeTrieElement) {
            ThemeTrieElement other = (ThemeTrieElement)obj;
            return this._children.equals(other._children) && this._mainRule.equals(other._mainRule) && this._rulesWithParentScopes.equals(other._rulesWithParentScopes);
        }
        return false;
    }
}

