/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.files.scp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.services.ssh.Activator;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.SshServiceResources;
import org.eclipse.rse.internal.services.ssh.files.SftpHostFile;
import org.eclipse.rse.internal.services.ssh.files.SshFileUtils;
import org.eclipse.rse.internal.services.ssh.files.scp.ScpFileAttr;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;

public class ScpFileService
extends AbstractFileService
implements IFilePermissionsService {
    private final ISshSessionProvider fSessionProvider;
    private String fUserHome = null;
    private static String lastErrorMessage = null;

    public ISshSessionProvider getSessionProvider() {
        return this.fSessionProvider;
    }

    public Session getSession() {
        return this.getSessionProvider().getSession();
    }

    public ScpFileService(ISshSessionProvider provider) {
        this.fSessionProvider = provider;
    }

    protected static void throwSystemException(String msg) throws SystemMessageException {
        throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.ssh", 4, msg));
    }

    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        if (fileFilter == null) {
            fileFilter = "*";
        }
        NamePatternMatcher filematcher = null;
        if (fileFilter.endsWith(",")) {
            String[] types = fileFilter.split(",");
            filematcher = new FileTypeMatcher(types, true);
        } else {
            filematcher = new NamePatternMatcher(fileFilter, true, true);
        }
        ArrayList<IHostFile> results = new ArrayList<IHostFile>();
        Session sess = this.getSession();
        String cmd = "ls -lAn " + SshFileUtils.escapePath(parentPath);
        String rc = SshFileUtils.execCommandSafe(sess, cmd);
        String[] lsStrings = rc.split("\n");
        int i = 0;
        while (i < lsStrings.length) {
            if (lsStrings[i].length() != 0 && !lsStrings[i].startsWith("total")) {
                IHostFile f;
                ScpFileAttr attr = new ScpFileAttr(lsStrings[i]);
                if (attr.getName() == null) {
                    Activator.warn("internalFetch(parentPath='" + parentPath + "'): Can't get name of " + lsStrings[i], null);
                } else if (filematcher.matches(attr.getName()) && this.isRightType(fileType, f = this.makeHostFile(parentPath, null, attr))) {
                    results.add(f);
                }
            }
            ++i;
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public int getCapabilities(IHostFile host) {
        return 63;
    }

    public IHostFilePermissions getFilePermissions(IHostFile file, IProgressMonitor monitor) throws SystemMessageException {
        if (file instanceof IHostFilePermissionsContainer) {
            return ((IHostFilePermissionsContainer)file).getPermissions();
        }
        return null;
    }

    public void setFilePermissions(IHostFile file, IHostFilePermissions permissions, IProgressMonitor monitor) throws SystemMessageException {
        Session session = this.getSession();
        String path = SshFileUtils.escapePath(file.getAbsolutePath());
        int permBits = permissions.getPermissionBits();
        String ownStr = String.valueOf(permissions.getUserOwner()) + ':' + permissions.getGroupOwner();
        String cmd = "chmod " + Integer.toOctalString(permBits) + " " + path;
        SshFileUtils.execCommandSafe(session, cmd);
        SshFileUtils.execCommandSafe(session, "chown " + ownStr + " " + path);
    }

    public void copy(String arg0, String arg1, String arg2, String arg3, IProgressMonitor arg4) throws SystemMessageException {
    }

    public void copyBatch(String[] arg0, String[] arg1, String arg2, IProgressMonitor arg3) throws SystemMessageException {
    }

    public IHostFile createFile(String remotePath, String fileName, IProgressMonitor arg2) throws SystemMessageException {
        Session session = this.getSession();
        String fullPath = SshFileUtils.concat(remotePath, fileName);
        SshFileUtils.execCommandSafe(session, "touch " + SshFileUtils.escapePath(fullPath));
        ScpFileAttr attr = ScpFileAttr.getAttr(session, fullPath);
        return this.makeHostFile(remotePath, fileName, attr);
    }

    public IHostFile createFolder(String remotePath, String fileName, IProgressMonitor arg2) throws SystemMessageException {
        Session session = this.getSession();
        String fullPath = SshFileUtils.concat(remotePath, fileName);
        SshFileUtils.execCommandSafe(session, "mkdir " + SshFileUtils.escapePath(fullPath));
        ScpFileAttr attr = ScpFileAttr.getAttr(session, fullPath);
        return this.makeHostFile(remotePath, fileName, attr);
    }

    public void delete(String remotePath, String fileName, IProgressMonitor arg2) throws SystemMessageException {
        Session session = this.getSession();
        String fullPathEsc = SshFileUtils.concatEscape(remotePath, fileName);
        SshFileUtils.execCommandSafe(session, "rm -rf " + fullPathEsc);
    }

    private static void setErrorMessage(String s) {
        lastErrorMessage = s;
    }

    public static String getLastError() {
        return lastErrorMessage;
    }

    private static int readAck(InputStream is) throws IOException {
        int ch;
        int rc = is.read();
        if (rc <= 0) {
            return rc;
        }
        StringBuffer sb = new StringBuffer();
        do {
            ch = is.read();
            sb.append((char)ch);
        } while (ch != SshFileUtils.EOL_CHAR);
        ScpFileService.setErrorMessage(sb.toString());
        return rc;
    }

    public void download(String remoteParent, String fileName, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            File localParentFile;
            if (!localFile.exists() && !(localParentFile = localFile.getParentFile()).exists()) {
                localParentFile.mkdirs();
            }
            this.internalDownload(remoteParent, fileName, localFile, monitor);
        }
        catch (Exception e) {
            SshFileUtils.throwSystemException(e);
        }
    }

    public IHostFile getFile(String remotePath, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        Session session = this.getSession();
        String fullPath = SshFileUtils.concat(remotePath, fileName);
        ScpFileAttr attr = ScpFileAttr.getAttr(session, fullPath);
        return this.makeHostFile(remotePath, fileName, attr);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) throws SystemMessageException {
        IHostFile root = null;
        try {
            root = this.getFile(null, "/", monitor);
        }
        catch (SystemMessageException e) {
            Activator.warn("Failed to get root file", (Exception)((Object)e));
        }
        if (root == null) {
            root = new SftpHostFile(null, "/", true, true, false, 0L, 0L);
        }
        return new IHostFile[]{root};
    }

    public IHostFile getUserHome() {
        if (this.fUserHome == null) {
            try {
                Session sess = this.getSession();
                this.fUserHome = SshFileUtils.execCommand(sess, "cd ;pwd").split("\n")[0];
            }
            catch (Exception e) {
                Activator.warn("Failed to execute pwd", e);
                return null;
            }
        }
        if (this.fUserHome == null) {
            return null;
        }
        int lastSlash = this.fUserHome.lastIndexOf(SshFileUtils.TARGET_SEPARATOR_CHAR);
        String name = this.fUserHome.substring(lastSlash + 1);
        String parent = this.fUserHome.substring(0, lastSlash + 1);
        IHostFile rc = null;
        try {
            rc = this.getFile(parent, name, null);
        }
        catch (SystemMessageException e) {
            Activator.warn("Failed to get user home file ", (Exception)((Object)e));
        }
        if (rc == null) {
            rc = new SftpHostFile(null, this.fUserHome, true, true, false, 0L, 0L);
        }
        return rc;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public void move(String oldPath, String oldName, String newPath, String newName, IProgressMonitor arg4) throws SystemMessageException {
        Session session = this.getSession();
        String oldFullPathEsc = SshFileUtils.concatEscape(newPath, oldName);
        String newFullPathEsc = SshFileUtils.concatEscape(newPath, newName);
        SshFileUtils.execCommandSafe(session, "mv " + oldFullPathEsc + " " + newFullPathEsc);
    }

    public void rename(String remotePath, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        Session session = this.getSession();
        String oldFullPathEsc = SshFileUtils.concatEscape(remotePath, oldName);
        String newFullPathEsc = SshFileUtils.concatEscape(remotePath, newName);
        SshFileUtils.execCommandSafe(session, "mv " + oldFullPathEsc + " " + newFullPathEsc);
    }

    public void rename(String remotePath, String oldName, String newName, IHostFile hostFile, IProgressMonitor monitor) throws SystemMessageException {
        this.rename(remotePath, oldName, newName, monitor);
    }

    public void setLastModified(String arg0, String arg1, long arg2, IProgressMonitor arg3) throws SystemMessageException {
        ScpFileService.throwSystemException(SshServiceResources.ScpFileService_LastModifiedNotSupportedError);
    }

    public void setReadOnly(String remotePath, String fileName, boolean disableWrite, IProgressMonitor monitor) throws SystemMessageException {
        String fullPath;
        Session session = this.getSession();
        ScpFileAttr attr = ScpFileAttr.getAttr(session, fullPath = SshFileUtils.concat(remotePath, fileName));
        if (attr == null) {
            ScpFileService.throwSystemException(String.valueOf(SshServiceResources.ScpFileService_AttributesError) + fullPath);
        }
        int perm = new HostFilePermissions(attr.getAttrs(), "", "").getPermissionBits();
        perm = disableWrite ? (perm &= 0xFFFFFF6D) : (perm |= 0x80);
        SshFileUtils.execCommandSafe(session, "chmod " + Integer.toOctalString(perm) + " " + SshFileUtils.escapePath(fullPath));
    }

    public void upload(InputStream stream, String remotePath, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
    }

    private void internalDownload(String remoteParent, String fileName, File localFile, IProgressMonitor monitor) throws Exception {
        int rc;
        String remotePath = SshFileUtils.concat(remoteParent, fileName);
        String cmd = "scp -f " + SshFileUtils.escapePath(remotePath);
        ChannelExec ch = SshFileUtils.openExecChannel(this.getSession(), cmd);
        InputStream is = ch.getInputStream();
        OutputStream os = ch.getOutputStream();
        ch.connect();
        byte[] buf = new byte[1024];
        buf[0] = 0;
        os.write(buf, 0, 1);
        os.flush();
        int c = is.read();
        if (c == 1) {
            String errmsg = SshFileUtils.readString(is);
            throw new Exception(NLS.bind((String)SshServiceResources.ScpFileService_DownloadException, (Object)remotePath, (Object)errmsg));
        }
        if (c != 67) {
            throw new Exception(NLS.bind((String)SshServiceResources.ScpFileService_DownloadException1, (Object)remotePath, (Object)("" + c)));
        }
        is.read(buf, 0, 5);
        long filesize = 0L;
        while (is.read(buf, 0, 1) >= 0 && buf[0] != 32) {
            filesize = filesize * 10L + (long)(buf[0] - 48);
        }
        String fname = SshFileUtils.readString(is);
        Activator.log("filesize=" + filesize + " fname=" + fname);
        buf[0] = 0;
        os.write(buf, 0, 1);
        os.flush();
        FileOutputStream fos = new FileOutputStream(localFile);
        monitor.beginTask(SshServiceResources.ScpFileService_DownloadFileTaskName, (int)filesize);
        long bytesDownloaded = 0L;
        do {
            int len;
            if (filesize - bytesDownloaded < (long)(len = buf.length)) {
                len = (int)(filesize - bytesDownloaded);
            }
            if ((rc = is.read(buf, 0, len)) < 0) break;
            monitor.worked(rc);
            fos.write(buf, 0, rc);
        } while ((bytesDownloaded += (long)rc) < filesize);
        fos.close();
        fos = null;
        monitor.done();
        c = is.read();
        if (c == 0) {
            buf[0] = 0;
            os.write(buf, 0, 1);
            os.flush();
        }
        os.close();
        is.close();
        ch.disconnect();
    }

    private void internalUpload(File localFile, String remotePath, String remoteFile, IProgressMonitor monitor) throws Exception {
        int len;
        monitor.beginTask(SshServiceResources.ScpFileService_UploadFileTaskName, (int)localFile.length() + 10);
        Session session = this.getSession();
        String cmd = "scp -p -t " + SshFileUtils.escapePath(remotePath);
        ChannelExec ch = SshFileUtils.openExecChannel(session, cmd);
        InputStream is = ch.getInputStream();
        OutputStream os = ch.getOutputStream();
        ch.connect();
        monitor.internalWorked(5.0);
        String fileHeader = "C0644 " + localFile.length() + " " + remoteFile + "\n";
        if (ScpFileService.readAck(is) != 0) {
            throw new Exception(String.valueOf(SshServiceResources.ScpFileService_ReadAckError) + ScpFileService.getLastError());
        }
        os.write(fileHeader.getBytes());
        os.flush();
        monitor.internalWorked(4.0);
        FileInputStream fis = new FileInputStream(localFile);
        byte[] buf = new byte[1024];
        while ((len = fis.read(buf, 0, buf.length)) > 0) {
            os.write(buf, 0, len);
            monitor.internalWorked((double)len);
        }
        fis.close();
        buf[0] = 0;
        os.write(buf, 0, 1);
        os.flush();
        if (ScpFileService.readAck(is) != 0) {
            throw new Exception(NLS.bind((String)SshServiceResources.ScpFileService_UploadException, (Object)localFile.getAbsolutePath(), (Object)ScpFileService.getLastError()));
        }
        monitor.internalWorked(1.0);
        os.close();
        is.close();
        monitor.done();
        ch.disconnect();
    }

    public void upload(File localFile, String remotePath, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            this.internalUpload(localFile, remotePath, remoteFile, monitor);
        }
        catch (Exception e) {
            SshFileUtils.throwSystemException(e);
        }
    }

    private IHostFile makeHostFile(String remotePath, String fileName, ScpFileAttr attr) {
        boolean isRoot;
        boolean bl = isRoot = remotePath == null || remotePath.length() == 0;
        if (attr == null) {
            SftpHostFile sftpHostFile = new SftpHostFile(isRoot ? null : remotePath, fileName, false, isRoot, false, 0L, 0L);
            sftpHostFile.setExists(false);
            return sftpHostFile;
        }
        boolean isLink = attr.isLink();
        boolean isDir = attr.isDirectory();
        if (fileName == null) {
            fileName = attr.getName();
        }
        SftpHostFile node = new SftpHostFile(isRoot ? null : remotePath, fileName, isDir, isRoot, isLink, 1000L * attr.getMTime(), attr.getSize());
        if (isLink && attr.getLinkName() != null) {
            node.setLinkTarget(attr.getLinkName());
        }
        node.setPermissions(attr.getFilePermissions());
        return node;
    }

    public String getDescription() {
        return SshServiceResources.ScpFileService_Description;
    }

    public String getName() {
        return SshServiceResources.ScpFileService_Name;
    }
}

