/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.local.controls;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.panels.AbstractExtendedConfigurationPanel;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.osgi.framework.Bundle;

public class LocalWizardConfigurationPanel
extends AbstractExtendedConfigurationPanel {
    private Object resource;

    public LocalWizardConfigurationPanel(IConfigurationPanelContainer container) {
        super(container);
    }

    public void setupPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createEncodingUI(panel, false);
        if ("macosx".equals(Platform.getOS()) || "win32".equals(Platform.getOS())) {
            this.setEncoding("UTF-8");
        } else {
            String encoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (encoding != null && !"".equals(encoding)) {
                this.setEncoding(encoding);
            }
        }
        Label label = new Label(panel, 256);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 300;
        layoutData.heightHint = 80;
        label.setLayoutData((Object)layoutData);
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
        if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16) {
            this.resource = this.getSelectionResource();
        }
        this.setControl(panel);
    }

    public void setupData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        String value = (String)data.get("encoding");
        if (value != null) {
            this.setEncoding(value);
        }
    }

    public void extractData(Map<String, Object> data) {
        data.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.local.LocalConnector");
        data.put("encoding", this.getEncoding());
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
        if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16 && this.resource instanceof IResource) {
            String dir = ((IResource)this.resource).getProject().getLocation().toString();
            data.put("process.working_dir", dir);
        }
    }

    protected void fillSettingsForHost(String host) {
    }

    protected void saveSettingsForHost(boolean add) {
    }

    public boolean isValid() {
        return true;
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        this.doSaveEncodingsWidgetValues(settings, idPrefix);
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        this.doRestoreEncodingsWidgetValues(settings, idPrefix);
    }

    protected String getHostFromSettings() {
        return null;
    }

    public boolean isWithHostList() {
        return false;
    }

    private IResource getSelectionResource() {
        StructuredSelection selection;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        Object object = selection = selectionService != null ? selectionService.getSelection() : StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                return (IResource)element;
            }
            if (element instanceof IAdaptable) {
                return (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
        }
        return null;
    }
}

