/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.serial.connector;

import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import java.util.Arrays;
import java.util.Enumeration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.connector.serial.connector.ISerialSettings;
import org.eclipse.tm.terminal.connector.serial.connector.SerialConnector;
import org.eclipse.tm.terminal.connector.serial.connector.SerialPortHandler;
import org.eclipse.tm.terminal.connector.serial.nls.Messages;

public class SerialConnectWorker
extends Thread {
    final ITerminalControl fControl;
    private final SerialConnector fConn;

    public SerialConnectWorker(SerialConnector conn, ITerminalControl control) {
        this.fControl = control;
        this.fConn = conn;
    }

    void addPort(String name) {
        String sep = System.getProperty("path.separator", ":");
        String names = System.getProperty("gnu.io.rxtx.SerialPorts");
        if (names == null) {
            StringBuffer buffer = new StringBuffer();
            boolean sepNeeded = false;
            Enumeration portIdEnum = CommPortIdentifier.getPortIdentifiers();
            while (portIdEnum.hasMoreElements()) {
                CommPortIdentifier identifier = (CommPortIdentifier)portIdEnum.nextElement();
                if (identifier.getPortType() != 1) continue;
                if (sepNeeded) {
                    buffer.append(sep);
                } else {
                    sepNeeded = true;
                }
                buffer.append(identifier.getName());
            }
            if (sepNeeded) {
                buffer.append(sep);
            }
            buffer.append(name);
            System.setProperty("gnu.io.rxtx.SerialPorts", buffer.toString());
        } else if (!Arrays.asList(names.split(sep)).contains(name)) {
            System.setProperty("gnu.io.rxtx.SerialPorts", String.valueOf(names) + sep + name);
        } else {
            return;
        }
        CommPortIdentifier.getPortIdentifiers();
    }

    public static final String getOwnershipId() {
        return "org.eclipse.tm.terminal.serial";
    }

    @Override
    public void run() {
        String portName = null;
        String strID = SerialConnectWorker.getOwnershipId();
        SerialPort serialPort = null;
        try {
            ISerialSettings s = this.fConn.getSerialSettings();
            portName = s.getSerialPort();
            try {
                this.fConn.setSerialPortIdentifier(CommPortIdentifier.getPortIdentifier((String)portName));
            }
            catch (NoSuchPortException noSuchPortException) {
                this.addPort(portName);
                this.fConn.setSerialPortIdentifier(CommPortIdentifier.getPortIdentifier((String)portName));
            }
            this.fConn.setSerialPortHandler(new SerialPortHandler(this.fConn, this.fControl));
            this.fConn.setSerialPortIdentifier(CommPortIdentifier.getPortIdentifier((String)portName));
            String currentOwner = this.fConn.getSerialPortIdentifier().getCurrentOwner();
            if (strID.equals(currentOwner)) {
                currentOwner = Messages.SerialConnectWorker_ANOTHER_TERMINAL;
            }
            final int[] answer = new int[]{64};
            final String fPortName = portName;
            final String fCurrentOwner = currentOwner;
            if (currentOwner != null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox mb = new MessageBox(SerialConnectWorker.this.fControl.getShell(), 196);
                        mb.setText(Messages.SerialConnectWorker_PROP_TITLE);
                        mb.setMessage(NLS.bind((String)Messages.SerialConnectWorker_PORT_IN_USE, (Object)fPortName, (Object)fCurrentOwner));
                        answer[0] = mb.open();
                    }
                });
            }
            if (answer[0] != 64) {
                this.fControl.setState(TerminalState.CLOSED);
                this.fConn.setSerialPortHandler(null);
                return;
            }
            try {
                int timeoutInMs = s.getTimeout() * 1000;
                serialPort = (SerialPort)this.fConn.getSerialPortIdentifier().open(strID, timeoutInMs);
                serialPort.setSerialPortParams(s.getBaudRate(), s.getDataBits(), s.getStopBits(), s.getParity());
                serialPort.setFlowControlMode(s.getFlowControl());
                serialPort.addEventListener((SerialPortEventListener)this.fConn.getSerialPortHandler());
                serialPort.notifyOnDataAvailable(true);
                this.fConn.getSerialPortIdentifier().addPortOwnershipListener((CommPortOwnershipListener)this.fConn.getSerialPortHandler());
                this.fConn.setSerialPort(serialPort);
                if (fCurrentOwner != null) {
                    this.fControl.displayTextInTerminal(NLS.bind((String)Messages.SerialConnectWorker_PORT_STOLEN, (Object)fPortName, (Object)fCurrentOwner));
                }
                this.fControl.setState(TerminalState.CONNECTED);
            }
            catch (PortInUseException portInUseException) {
                this.fControl.setState(TerminalState.CLOSED);
                String theOwner = portInUseException.currentOwner;
                if (strID.equals(theOwner)) {
                    theOwner = Messages.SerialConnectWorker_ANOTHER_TERMINAL;
                }
                this.fControl.displayTextInTerminal(NLS.bind((String)Messages.SerialConnectWorker_PORT_NOT_STOLEN, (Object)portName, (Object)theOwner));
            }
            catch (NoSuchPortException e) {
                this.fControl.setState(TerminalState.CLOSED);
                String msg = e.getMessage();
                if (msg == null) {
                    msg = portName;
                }
                this.fControl.displayTextInTerminal(NLS.bind((String)Messages.SerialConnectWorker_NO_SUCH_PORT, (Object)msg));
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
                if (serialPort != null) {
                    try {
                        serialPort.removeEventListener();
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        Logger.logException((Exception)e);
                    }
                    serialPort.close();
                    this.fConn.getSerialPortIdentifier().removePortOwnershipListener((CommPortOwnershipListener)this.fConn.getSerialPortHandler());
                }
                this.fControl.setState(TerminalState.CLOSED);
            }
        }
        finally {
            this.fConn.doneConnect();
        }
    }
}

