/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.widgets.ISystemCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemHostCombo
extends Composite
implements ISelectionProvider,
ISystemCombo,
ISystemResourceChangeListener,
ISystemShellProvider,
DisposeListener {
    protected Label connectionLabel = null;
    protected Combo connectionCombo = null;
    protected Button newButton = null;
    protected boolean showNewButton = true;
    protected boolean showLabel = true;
    protected boolean showQualifiedNames;
    protected boolean listeningForConnectionEvents = false;
    private IHost[] connections = null;
    private SystemNewConnectionAction newConnectionAction = null;
    private IRSESystemType[] restrictSystemTypesTo = null;
    private int gridColumns = 2;
    private String label;
    private IRSESystemType populateSystemType = null;
    private IRSESystemType[] populateSystemTypes = null;
    private ISubSystemConfiguration populateSSFactory = null;
    private String populateSSFactoryId = null;
    private String populateSSFactoryCategory = null;
    private Cursor waitCursor;

    public SystemHostCombo(Composite parent, int style, IRSESystemType systemType, IHost defaultConnection, boolean showNewButton) {
        super(parent, style);
        this.restrictSystemTypesTo = new IRSESystemType[1];
        this.restrictSystemTypesTo[0] = systemType;
        this.init(parent, showNewButton);
        this.populateSystemType = systemType;
        this.populateConnectionCombo(this.connectionCombo, systemType, defaultConnection, true);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public SystemHostCombo(Composite parent, int style, IRSESystemType[] systemTypes, IHost defaultConnection, boolean showNewButton) {
        super(parent, style);
        this.restrictSystemTypesTo = systemTypes;
        this.init(parent, showNewButton);
        this.populateSystemTypes = systemTypes;
        this.populateConnectionCombo(this.connectionCombo, systemTypes, defaultConnection);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public SystemHostCombo(Composite parent, int style, ISubSystemConfiguration ssConfig, IHost defaultConnection, boolean showNewButton) {
        super(parent, style);
        this.restrictSystemTypesTo = ssConfig.getSystemTypes();
        this.init(parent, showNewButton);
        this.populateSSFactory = ssConfig;
        this.populateConnectionCombo(this.connectionCombo, ssConfig, defaultConnection);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public SystemHostCombo(Composite parent, int style, IHost defaultConnection, String ssConfigId, boolean showNewButton) {
        super(parent, style);
        this.restrictSystemTypesTo = RSECorePlugin.getTheSystemRegistry().getSubSystemConfiguration(ssConfigId).getSystemTypes();
        this.init(parent, showNewButton);
        this.populateSSFactoryId = ssConfigId;
        this.populateConnectionCombo(this.connectionCombo, ssConfigId, defaultConnection);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public SystemHostCombo(Composite parent, int style, IHost defaultConnection, boolean showNewButton, String ssConfigCategory) {
        this(parent, style, defaultConnection, showNewButton, ssConfigCategory, true);
    }

    public SystemHostCombo(Composite parent, int style, IHost defaultConnection, boolean showNewButton, String ssConfigCategory, boolean showLabel) {
        super(parent, style);
        if (showNewButton) {
            ISubSystemConfigurationProxy[] ssfProxies = RSECorePlugin.getTheSystemRegistry().getSubSystemConfigurationProxiesByCategory(ssConfigCategory);
            Vector<IRSESystemType> vTypes = new Vector<IRSESystemType>();
            int idx = 0;
            while (idx < ssfProxies.length) {
                IRSESystemType[] types = ssfProxies[idx].getSubSystemConfiguration().getSystemTypes();
                int jdx = 0;
                while (jdx < types.length) {
                    RSESystemTypeAdapter a;
                    IRSESystemType systemType = types[jdx];
                    if (!vTypes.contains(systemType) && (a = (RSESystemTypeAdapter)systemType.getAdapter(RSESystemTypeAdapter.class)) != null && a.isEnabled(systemType)) {
                        vTypes.addElement(systemType);
                    }
                    ++jdx;
                }
                ++idx;
            }
            this.restrictSystemTypesTo = vTypes.toArray(new IRSESystemType[vTypes.size()]);
        }
        this.init(parent, showNewButton, showLabel);
        this.populateSSFactoryCategory = ssConfigCategory;
        this.populateConnectionCombo(this.connectionCombo, defaultConnection, ssConfigCategory);
        this.setConnectionToolTipText();
        this.addOurConnectionSelectionListener();
    }

    public void setAutoUpperCase(boolean enable) {
    }

    protected void init(Composite parent, boolean showNewButton) {
        this.init(parent, showNewButton, true);
    }

    protected void init(Composite parent, boolean showNewButton, boolean showLabel) {
        this.showNewButton = showNewButton;
        this.showLabel = showLabel;
        this.showQualifiedNames = SystemPreferencesManager.getQualifyConnectionNames();
        this.prepareComposite(3);
        if (showLabel) {
            this.connectionLabel = this.label == null ? SystemWidgetHelpers.createLabel(this, SystemResources.WIDGET_CONNECTION_LABEL) : SystemWidgetHelpers.createLabel(this, this.label);
        }
        this.connectionCombo = this.createConnectionCombo(this);
        if (showNewButton) {
            this.newConnectionAction = this.getNewConnectionAction(parent.getShell(), this);
            this.newConnectionAction.restrictSystemTypes(this.restrictSystemTypesTo);
            this.newButton = SystemHostCombo.createPushButton(this, SystemResources.WIDGET_BUTTON_NEWCONNECTION_LABEL, SystemResources.WIDGET_BUTTON_NEWCONNECTION_TOOLTIP);
            this.addOurButtonSelectionListener();
            if (!showLabel) {
                ((GridData)this.connectionCombo.getLayoutData()).horizontalSpan = 2;
            }
        } else {
            ((GridData)this.connectionCombo.getLayoutData()).horizontalSpan = showLabel ? 2 : 3;
        }
        this.addDisposeListener(this);
    }

    protected SystemNewConnectionAction getNewConnectionAction(Shell shell, ISelectionProvider selectionProvider) {
        return new SystemNewConnectionAction(shell, false, selectionProvider);
    }

    public IHost getHost() {
        IHost connection = null;
        int idx = this.connectionCombo.getSelectionIndex();
        if (idx >= 0 && this.connections != null && idx < this.connections.length) {
            connection = this.connections[idx];
        }
        return connection;
    }

    public Combo getCombo() {
        return this.connectionCombo;
    }

    public void setWidthHint(int widthHint) {
        ((GridData)this.getLayoutData()).widthHint = widthHint;
    }

    public void setButtonWidthHint(int widthHint) {
        if (this.newButton != null) {
            ((GridData)this.newButton.getLayoutData()).widthHint = widthHint;
        }
    }

    public void setButtonWidthHint(Control otherWidget) {
        if (this.newButton != null) {
            ((GridData)this.newButton.getLayoutData()).widthHint = otherWidget.getSize().x;
        }
    }

    public int getGridColumns() {
        return this.gridColumns;
    }

    public Button getNewButton() {
        return this.newButton;
    }

    public Label getPromptLabel() {
        return this.connectionLabel;
    }

    public void setItems(String[] items) {
        this.connectionCombo.setItems(items);
    }

    public String[] getItems() {
        return this.connectionCombo.getItems();
    }

    public String getText() {
        return this.connectionCombo.getText();
    }

    public void setEnabled(boolean enabled) {
        this.connectionCombo.setEnabled(enabled);
        if (this.newButton != null) {
            this.newButton.setEnabled(enabled);
        }
    }

    public void setToolTipText(String tip) {
        if (this.connectionLabel != null) {
            this.connectionLabel.setToolTipText(tip);
        }
    }

    public void setNewButtonToolTipText(String tip) {
        if (this.newButton != null) {
            this.newButton.setToolTipText(tip);
        }
    }

    public void setButtonToolTipText(String tip) {
        this.setNewButtonToolTipText(tip);
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.connectionLabel != null) {
            this.connectionLabel.setText(label);
        }
    }

    public boolean setFocus() {
        return this.connectionCombo.setFocus();
    }

    public void setNewButtonFocus() {
        if (this.newButton != null) {
            this.newButton.setFocus();
        }
    }

    public void select(int selIdx) {
        this.connectionCombo.select(selIdx);
        Event e = new Event();
        this.connectionCombo.notifyListeners(13, e);
    }

    public void setSelectionIndex(int selIdx) {
        this.select(selIdx);
    }

    public void select(IHost connection) {
        if (this.connections != null) {
            int matchIdx = -1;
            int idx = 0;
            while (matchIdx == -1 && idx < this.connections.length) {
                if (connection == this.connections[idx]) {
                    matchIdx = idx;
                }
                ++idx;
            }
            if (matchIdx != -1) {
                this.select(matchIdx);
            }
        }
    }

    public void clearSelection() {
        this.connectionCombo.clearSelection();
        this.connectionCombo.deselectAll();
        Event e = new Event();
        this.connectionCombo.notifyListeners(13, e);
    }

    public void clearTextSelection() {
        this.connectionCombo.clearSelection();
    }

    public int getSelectionIndex() {
        return this.connectionCombo.getSelectionIndex();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.connectionCombo.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.connectionCombo.removeSelectionListener(listener);
    }

    public void addNewButtonSelectionListener(SelectionListener listener) {
        if (this.newButton != null) {
            this.newButton.addSelectionListener(listener);
        }
    }

    public void removeNewButtonSelectionListener(SelectionListener listener) {
        if (this.newButton != null) {
            this.newButton.removeSelectionListener(listener);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.connectionCombo.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.connectionCombo.removeModifyListener(listener);
    }

    protected Composite prepareComposite(int numColumns) {
        this.gridColumns = numColumns;
        SystemHostCombo composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.showNewButton ? 250 : 200;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData(data);
        return composite;
    }

    protected Combo createConnectionCombo(Composite parent) {
        Combo combo = SystemHostCombo.createCombo(parent, true);
        this.setToolTipText(SystemResources.WIDGET_CONNECTION_TOOLTIP);
        return combo;
    }

    public static Combo createCombo(Composite parent, boolean readonly) {
        Combo combo = null;
        combo = !readonly ? new Combo(parent, 4) : new Combo(parent, 12);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected boolean populateConnectionCombo(Combo combo, IRSESystemType systemType, IHost defaultConnection, boolean preSelectIfNoMatch) {
        return this.populateConnectionCombo(combo, systemType, defaultConnection, preSelectIfNoMatch, false);
    }

    protected boolean populateConnectionCombo(Combo combo, IRSESystemType systemType, IHost defaultConnection, boolean preSelectIfNoMatch, boolean appendToCombo) {
        int idx;
        int i;
        boolean matchFound = false;
        Object additionalConnections = null;
        if (systemType == null) {
            additionalConnections = RSECorePlugin.getTheSystemRegistry().getHosts();
            if (additionalConnections != null) {
                boolean filtered = false;
                ArrayList<IHost> validHosts = new ArrayList<IHost>(((IHost[])additionalConnections).length);
                i = 0;
                while (i < ((IHost[])additionalConnections).length) {
                    IRSESystemType curSysType = additionalConnections[i].getSystemType();
                    RSESystemTypeAdapter a = (RSESystemTypeAdapter)curSysType.getAdapter(RSESystemTypeAdapter.class);
                    if (a.isEnabled(curSysType)) {
                        validHosts.add(additionalConnections[i]);
                    } else {
                        filtered = true;
                    }
                    ++i;
                }
                if (filtered) {
                    additionalConnections = validHosts.size() == 0 ? null : validHosts.toArray(new IHost[validHosts.size()]);
                }
            }
        } else {
            RSESystemTypeAdapter a = (RSESystemTypeAdapter)systemType.getAdapter(RSESystemTypeAdapter.class);
            if (a.isEnabled(systemType)) {
                additionalConnections = RSECorePlugin.getTheSystemRegistry().getHostsBySystemType(systemType);
            }
        }
        if (additionalConnections != null) {
            String[] connectionNames = new String[((IHost[])additionalConnections).length];
            int selectionIndex = -1;
            idx = 0;
            while (idx < connectionNames.length) {
                connectionNames[idx] = this.getConnectionName(additionalConnections[idx]);
                if (defaultConnection != null && additionalConnections[idx] == defaultConnection) {
                    selectionIndex = this.connections == null ? idx : this.connections.length + idx;
                }
                ++idx;
            }
            if (appendToCombo) {
                i = 0;
                while (i < connectionNames.length) {
                    combo.add(connectionNames[i]);
                    ++i;
                }
            } else {
                combo.setItems(connectionNames);
            }
            if (selectionIndex >= 0) {
                this.select(selectionIndex);
                matchFound = true;
            } else if (preSelectIfNoMatch && combo.getItemCount() > 0) {
                this.select(0);
            }
        }
        if (this.connections == null) {
            this.connections = additionalConnections;
        } else if (additionalConnections != null && ((IHost[])additionalConnections).length > 0) {
            IHost[] totalConnections = new IHost[this.connections.length + ((IHost[])additionalConnections).length];
            int totalIdx = 0;
            idx = 0;
            while (idx < this.connections.length) {
                totalConnections[totalIdx++] = this.connections[idx];
                ++idx;
            }
            idx = 0;
            while (idx < ((IHost[])additionalConnections).length) {
                totalConnections[totalIdx++] = additionalConnections[idx];
                ++idx;
            }
            this.connections = totalConnections;
        }
        return matchFound;
    }

    protected void populateConnectionCombo(Combo combo, IRSESystemType[] systemTypes, IHost defaultConnection) {
        boolean match = false;
        boolean anyMatch = false;
        int idx = 0;
        while (idx < systemTypes.length) {
            IRSESystemType systemType = systemTypes[idx];
            RSESystemTypeAdapter a = (RSESystemTypeAdapter)systemType.getAdapter(RSESystemTypeAdapter.class);
            if (a.isEnabled(systemType) && (match = this.populateConnectionCombo(combo, systemType, defaultConnection, false, true))) {
                anyMatch = true;
            }
            ++idx;
        }
        if (!anyMatch && combo.getItemCount() > 0) {
            this.select(0);
        }
    }

    protected boolean populateConnectionCombo(Combo combo, ISubSystemConfiguration ssConfig, IHost defaultConnection) {
        this.connections = RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfiguration(ssConfig);
        return this.addConnections(combo, this.connections, defaultConnection);
    }

    protected boolean populateConnectionCombo(Combo combo, String ssConfigId, IHost defaultConnection) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfiguration config = sr.getSubSystemConfiguration(ssConfigId);
        this.connections = sr.getHostsBySubSystemConfiguration(config);
        return this.addConnections(combo, this.connections, defaultConnection);
    }

    protected boolean populateConnectionCombo(Combo combo, IHost defaultConnection, String ssConfigCategory) {
        this.connections = RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory(ssConfigCategory);
        return this.addConnections(combo, this.connections, defaultConnection);
    }

    private boolean addConnections(Combo combo, IHost[] connections, IHost defaultConnection) {
        boolean filtered = false;
        ArrayList<IHost> filteredConnections = new ArrayList<IHost>(connections.length);
        int i = 0;
        while (i < connections.length) {
            IRSESystemType systemType = connections[i].getSystemType();
            RSESystemTypeAdapter a = (RSESystemTypeAdapter)systemType.getAdapter(RSESystemTypeAdapter.class);
            if (a != null && a.isEnabled(systemType)) {
                filteredConnections.add(connections[i]);
            } else {
                filtered = true;
            }
            ++i;
        }
        if (filtered) {
            connections = filteredConnections.toArray(new IHost[filteredConnections.size()]);
            this.connections = connections;
        }
        boolean matchFound = false;
        if (connections != null) {
            String[] connectionNames = new String[connections.length];
            int selectionIndex = -1;
            int idx = 0;
            while (idx < connectionNames.length) {
                connectionNames[idx] = this.getConnectionName(connections[idx]);
                if (defaultConnection != null && connections[idx] == defaultConnection) {
                    selectionIndex = idx;
                }
                ++idx;
            }
            combo.setItems(connectionNames);
            if (selectionIndex >= 0) {
                this.select(selectionIndex);
                matchFound = true;
            } else if (combo.getItemCount() > 0) {
                this.select(0);
            }
        }
        return matchFound;
    }

    protected static String sub(String msg, String subOld, String subNew) {
        StringBuffer temp = new StringBuffer();
        int lastHit = 0;
        int newHit = 0;
        newHit = msg.indexOf(subOld, lastHit);
        while (newHit != -1) {
            if (newHit >= 0) {
                temp.append(msg.substring(lastHit, newHit));
            }
            temp.append(subNew);
            lastHit = newHit += subOld.length();
            newHit = msg.indexOf(subOld, lastHit);
        }
        if (lastHit >= 0) {
            temp.append(msg.substring(lastHit));
        }
        return temp.toString();
    }

    private String getConnectionName(IHost conn) {
        if (this.showQualifiedNames) {
            return String.valueOf(conn.getSystemProfileName()) + "." + conn.getAliasName();
        }
        return conn.getAliasName();
    }

    public void refreshConnections() {
        this.connections = null;
        this.connectionCombo.removeAll();
        if (this.populateSystemType != null) {
            this.populateConnectionCombo(this.connectionCombo, this.populateSystemType, null, false);
        } else if (this.populateSystemTypes != null) {
            this.populateConnectionCombo(this.connectionCombo, this.populateSystemTypes, null);
        } else if (this.populateSSFactory != null) {
            this.populateConnectionCombo(this.connectionCombo, this.populateSSFactory, null);
        } else if (this.populateSSFactoryId != null) {
            this.populateConnectionCombo(this.connectionCombo, this.populateSSFactoryId, null);
        } else if (this.populateSSFactoryCategory != null) {
            this.populateConnectionCombo(this.connectionCombo, null, this.populateSSFactoryCategory);
        }
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        int type = event.getType();
        Object src = event.getSource();
        switch (type) {
            case 50: 
            case 53: 
            case 60: 
            case 65: {
                if (!(src instanceof IHost)) break;
                if (type == 65) {
                    this.showQualifiedNames = SystemPreferencesManager.getQualifyConnectionNames();
                }
                this.refreshConnections();
            }
        }
    }

    public void listenToConnectionEvents(boolean start) {
        if (start) {
            this.listeningForConnectionEvents = true;
            RSECorePlugin.getTheSystemRegistry().addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        } else {
            this.listeningForConnectionEvents = false;
            RSECorePlugin.getTheSystemRegistry().removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.listeningForConnectionEvents) {
            this.listeningForConnectionEvents = false;
            RSECorePlugin.getTheSystemRegistry().removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        }
    }

    protected void addOurButtonSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemHostCombo.this.setBusyCursor(true);
                SystemHostCombo.this.newConnectionAction.run();
                SystemHostCombo.this.setBusyCursor(false);
                IHost newConnection = (IHost)SystemHostCombo.this.newConnectionAction.getValue();
                if (newConnection != null) {
                    if (SystemHostCombo.this.listeningForConnectionEvents) {
                        SystemHostCombo.this.select(newConnection);
                    } else if (SystemHostCombo.this.connections == null) {
                        SystemHostCombo.this.connections = new IHost[1];
                        ((SystemHostCombo)SystemHostCombo.this).connections[0] = newConnection;
                        SystemHostCombo.this.addConnections(SystemHostCombo.this.connectionCombo, SystemHostCombo.this.connections, newConnection);
                    } else {
                        IHost[] totalConnections = new IHost[SystemHostCombo.this.connections.length + 1];
                        int totalIdx = 0;
                        int idx = 0;
                        while (idx < SystemHostCombo.this.connections.length) {
                            totalConnections[totalIdx++] = SystemHostCombo.this.connections[idx];
                            ++idx;
                        }
                        totalConnections[totalIdx] = newConnection;
                        SystemHostCombo.this.connections = totalConnections;
                        SystemHostCombo.this.addConnections(SystemHostCombo.this.connectionCombo, SystemHostCombo.this.connections, newConnection);
                    }
                }
            }
        };
        this.newButton.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void addOurConnectionSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemHostCombo.this.setConnectionToolTipText();
            }
        };
        this.connectionCombo.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void setConnectionToolTipText() {
        String tooltipText = "";
        IHost currConn = this.getHost();
        if (currConn != null) {
            tooltipText = currConn.getHostName();
        }
        this.connectionCombo.setToolTipText(tooltipText);
    }

    protected static Button createPushButton(Composite group, String label) {
        Button button = new Button(group, 8);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        button.setLayoutData((Object)data);
        return button;
    }

    protected static Button createPushButton(Composite group, String label, String tooltip) {
        Button button = SystemHostCombo.createPushButton(group, label);
        button.setToolTipText(tooltip);
        return button;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        StructuredSelection selection = StructuredSelection.EMPTY;
        IHost connection = this.getHost();
        if (connection != null) {
            selection = new StructuredSelection((Object)connection);
        }
        return selection;
    }

    public void setSelection(ISelection selection) {
    }

    public IHost[] getConnections() {
        return this.connections;
    }

    public void setConnections(IHost[] input) {
        this.connections = input;
    }

    protected void setBusyCursor(boolean setBusy) {
        if (setBusy) {
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            SystemPromptDialog.setDisplayCursor(this.getShell(), this.waitCursor);
        } else {
            SystemPromptDialog.setDisplayCursor(this.getShell(), null);
            if (this.waitCursor != null) {
                this.waitCursor.dispose();
            }
            this.waitCursor = null;
        }
    }
}

