/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;

public class RequiresDirective
extends ModuleDirective {
    public static final ChildListPropertyDescriptor MODIFIERS_PROPERTY = new ChildListPropertyDescriptor(RequiresDirective.class, "modifiers", ModuleModifier.class, false);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(RequiresDirective.class, "name", Name.class, true, false);
    private static final List PROPERTY_DESCRIPTORS_9_0;
    private final ASTNode.NodeList modifiers = new ASTNode.NodeList(MODIFIERS_PROPERTY);
    private volatile Name name;

    static {
        ArrayList propertyList = new ArrayList(3);
        RequiresDirective.createPropertyList(RequiresDirective.class, propertyList);
        RequiresDirective.addProperty(MODIFIERS_PROPERTY, propertyList);
        RequiresDirective.addProperty(NAME_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_9_0 = RequiresDirective.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS_9_0;
    }

    RequiresDirective(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return RequiresDirective.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((Name)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS_PROPERTY) {
            return this.modifiers();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 94;
    }

    @Override
    ASTNode clone0(AST target) {
        RequiresDirective result = new RequiresDirective(target);
        result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
        result.setName((Name)this.getName().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.modifiers);
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    public List modifiers() {
        return this.modifiers;
    }

    public int getModifiers() {
        int computedModifierFlags = 0;
        for (Object x : this.modifiers()) {
            if (!(x instanceof ModuleModifier)) continue;
            computedModifierFlags |= ((ModuleModifier)x).getKeyword().toFlagValue();
        }
        return computedModifierFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name getName() {
        if (this.name == null) {
            RequiresDirective requiresDirective = this;
            synchronized (requiresDirective) {
                if (this.name == null) {
                    this.preLazyInit();
                    this.name = this.postLazyInit(new SimpleName(this.ast), NAME_PROPERTY);
                }
            }
        }
        return this.name;
    }

    public void setName(Name name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Name oldChild = this.name;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.name = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.modifiers == null ? 0 : this.modifiers.listSize()) + (this.name == null ? 0 : this.getName().treeSize());
    }
}

