/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.BuildSupportManager;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class BuildPathCommand {
    private static final String UNSUPPORTED_OPERATION = "Unsupported operation. Please use your build tool project file to manage the source directories of the project.";

    private static String unsupportedOperationMessage(IProject targetProject) {
        return BuildSupportManager.obtainBuildSupports().stream().filter(bs -> bs.applies(targetProject)).findFirst().map(IBuildSupport::unsupportedOperationMessage).orElse(UNSUPPORTED_OPERATION);
    }

    public static Result addToSourcePath(String sourceFolderUri) {
        IPath sourceFolderPath = ResourceUtils.filePathFromURI(sourceFolderUri);
        IProject targetProject = BuildPathCommand.findBelongedProject(sourceFolderPath);
        if (targetProject != null && !ProjectUtils.isGeneralJavaProject(targetProject)) {
            return new Result(false, BuildPathCommand.unsupportedOperationMessage(targetProject));
        }
        IPath projectLocation = null;
        IProject projectRootResource = null;
        IPath[] exclusionPath = new IPath[]{};
        if (targetProject == null) {
            try {
                IPath workspaceRoot = ProjectUtils.findBelongedWorkspaceRoot(sourceFolderPath);
                if (workspaceRoot == null) {
                    return new Result(false, Messages.format("The folder ''{0}'' doesn''t belong to any workspace.", BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString()));
                }
                targetProject = ProjectUtils.createInvisibleProjectIfNotExist(workspaceRoot);
                IFolder workspaceLink = targetProject.getFolder("_");
                projectLocation = workspaceRoot;
                projectRootResource = workspaceLink;
                List<IProject> subProjects = ProjectUtils.getVisibleProjects(workspaceRoot);
                exclusionPath = (IPath[])subProjects.stream().map(project -> {
                    IPath relativePath = project.getLocation().makeRelativeTo(workspaceRoot);
                    return workspaceLink.getFolder(relativePath).getFullPath();
                }).toArray(IPath[]::new);
            }
            catch (CoreException | OperationCanceledException e) {
                JavaLanguageServerPlugin.logException("Failed to create the invisible project.", e);
                return new Result(false, "Failed to add the folder to the workspace invisible project's source path. Reason: " + e.getMessage());
            }
        } else {
            projectLocation = targetProject.getLocation();
            projectRootResource = targetProject;
        }
        IPath relativeSourcePath = sourceFolderPath.makeRelativeTo(projectLocation);
        IPath sourcePath = relativeSourcePath.isEmpty() ? projectRootResource.getFullPath() : projectRootResource.getFolder(relativeSourcePath).getFullPath();
        IJavaProject javaProject = JavaCore.create((IProject)targetProject);
        try {
            if (ProjectUtils.addSourcePath(sourcePath, exclusionPath, javaProject)) {
                Result result = new Result(true, Messages.format("Successfully added ''{0}'' to the project {1}''s source path.", new String[]{BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString(), targetProject.getName()}));
                result.sourcePaths = BuildPathCommand.getInvisibleProjectRelativeSourcePaths(javaProject);
                return result;
            }
            return new Result(true, Messages.format("No need to add it to source path again, because the folder ''{0}'' is already in the project {1}''s source path.", new String[]{BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString(), targetProject.getName()}));
        }
        catch (CoreException e) {
            return new Result(false, e.getMessage());
        }
    }

    public static Result removeFromSourcePath(String sourceFolderUri) {
        IPath sourceFolderPath = ResourceUtils.filePathFromURI(sourceFolderUri);
        IProject targetProject = BuildPathCommand.findBelongedProject(sourceFolderPath);
        if (targetProject != null && !ProjectUtils.isGeneralJavaProject(targetProject)) {
            return new Result(false, BuildPathCommand.unsupportedOperationMessage(targetProject));
        }
        IPath projectLocation = null;
        IProject projectRootResource = null;
        if (targetProject == null) {
            IPath workspaceRoot = ProjectUtils.findBelongedWorkspaceRoot(sourceFolderPath);
            if (workspaceRoot == null) {
                return new Result(false, Messages.format("The folder ''{0}'' doesn''t belong to any workspace.", BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString()));
            }
            String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(workspaceRoot);
            targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
            if (!targetProject.exists()) {
                return new Result(true, Messages.format("No need to remove it from source path, because the folder ''{0}'' isn''t on any project''s source path.", BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString()));
            }
            projectLocation = workspaceRoot;
            projectRootResource = targetProject.getFolder("_");
        } else {
            projectLocation = targetProject.getLocation();
            projectRootResource = targetProject;
        }
        IPath relativeSourcePath = sourceFolderPath.makeRelativeTo(projectLocation);
        IPath sourcePath = relativeSourcePath.isEmpty() ? projectRootResource.getFullPath() : projectRootResource.getFolder(relativeSourcePath).getFullPath();
        IJavaProject javaProject = JavaCore.create((IProject)targetProject);
        try {
            if (ProjectUtils.removeSourcePath(sourcePath, javaProject)) {
                Result result = new Result(true, Messages.format("Successfully removed ''{0}'' from the project {1}''s source path.", new String[]{BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString(), targetProject.getName()}));
                result.sourcePaths = BuildPathCommand.getInvisibleProjectRelativeSourcePaths(javaProject);
                return result;
            }
            return new Result(true, Messages.format("No need to remove it from source path, because the folder ''{0}'' isn''t on any project''s source path.", BuildPathCommand.getWorkspacePath(sourceFolderPath).toOSString()));
        }
        catch (CoreException e) {
            return new Result(false, e.getMessage());
        }
    }

    public static Result listSourcePaths() {
        try {
            IProject[] projects;
            ArrayList<SourcePath> sourcePathList = new ArrayList<SourcePath>();
            IProject[] iProjectArray = projects = ProjectUtils.getAllProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!"jdt.ls-java-project".equals(project.getName()) && ProjectUtils.isJavaProject(project)) {
                    sourcePathList.addAll(BuildPathCommand.tryAddProjectToSourcePath(project));
                }
                ++n2;
            }
            return new ListCommandResult(true, null, sourcePathList.toArray(new SourcePath[0]));
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve the existing source paths in current workspace.", e);
            return new ListCommandResult(false, e.getMessage());
        }
    }

    private static List<SourcePath> tryAddProjectToSourcePath(IProject project) throws JavaModelException {
        IPath[] paths;
        ArrayList<SourcePath> sourcePathList = new ArrayList<SourcePath>();
        IPath[] iPathArray = paths = ProjectUtils.listSourcePaths(JavaCore.create((IProject)project));
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IProject projectRoot;
                String projectType;
                String projectName;
                IPath entryPath;
                block3: {
                    IPath path;
                    entryPath = path = iPathArray[n2];
                    projectName = project.getName();
                    projectType = BuildPathCommand.determineProjectType(project);
                    projectRoot = project;
                    if (ProjectUtils.isVisibleProject(project)) break block3;
                    projectType = "Workspace";
                    IFolder workspaceLinkFolder = project.getFolder("_");
                    if (!workspaceLinkFolder.isLinked()) break block4;
                    projectRoot = workspaceLinkFolder;
                }
                IPath relativePath = entryPath.makeRelativeTo(projectRoot.getFullPath());
                IPath location = projectRoot.getRawLocation().append(relativePath);
                IPath displayPath = BuildPathCommand.getWorkspacePath(location);
                sourcePathList.add(new SourcePath(location != null ? location.toOSString() : "", displayPath != null ? displayPath.toOSString() : entryPath.toOSString(), entryPath.toOSString(), projectName, projectType));
            }
            ++n2;
        }
        return sourcePathList;
    }

    private static String determineProjectType(IProject project) {
        return BuildSupportManager.find(project).map(buildSupport -> buildSupport.buildToolName()).orElseGet(() -> "General");
    }

    private static String[] getInvisibleProjectRelativeSourcePaths(IJavaProject javaProject) throws JavaModelException {
        if (ProjectUtils.isVisibleProject(javaProject.getProject())) {
            return null;
        }
        IFolder workspaceLinkFolder = javaProject.getProject().getFolder("_");
        if (!workspaceLinkFolder.isLinked()) {
            return null;
        }
        IPath[] paths = ProjectUtils.listSourcePaths(javaProject);
        return (String[])Arrays.stream(paths).map(p -> p.makeRelativeTo(workspaceLinkFolder.getFullPath()).toString()).toArray(String[]::new);
    }

    private static IProject findBelongedProject(IPath sourceFolder) {
        List projects = Stream.of(ProjectUtils.getAllProjects()).filter(ProjectUtils::isJavaProject).sorted(new Comparator<IProject>(){

            @Override
            public int compare(IProject p1, IProject p2) {
                return p2.getLocation().toOSString().length() - p1.getLocation().toOSString().length();
            }
        }).collect(Collectors.toList());
        for (IProject project : projects) {
            if (!project.getLocation().isPrefixOf(sourceFolder)) continue;
            return project;
        }
        return null;
    }

    private static IPath getWorkspacePath(IPath path) {
        PreferenceManager manager = JavaLanguageServerPlugin.getPreferencesManager();
        Collection<IPath> rootPaths = manager.getPreferences().getRootPaths();
        if (rootPaths != null) {
            for (IPath rootPath : rootPaths) {
                if (!rootPath.isPrefixOf(path)) continue;
                return path.makeRelativeTo(rootPath.append(".."));
            }
        }
        return path;
    }

    public static class ListCommandResult
    extends Result {
        public SourcePath[] data;

        ListCommandResult(boolean status, String message) {
            super(status, message);
            this.data = new SourcePath[0];
        }

        ListCommandResult(boolean status, String message, SourcePath[] data) {
            super(status, message);
            this.data = data;
        }
    }

    public static class Result {
        public boolean status;
        public String message;
        public String[] sourcePaths;

        Result(boolean status, String message) {
            this.status = status;
            this.message = message;
        }
    }

    public static class SourcePath {
        public String path;
        public String displayPath;
        public String classpathEntry;
        public String projectName;
        public String projectType;

        SourcePath(String path, String displayPath, String classpathEntry, String projectName, String projectType) {
            this.path = path;
            this.displayPath = displayPath;
            this.classpathEntry = classpathEntry;
            this.projectName = projectName;
            this.projectType = projectType;
        }
    }
}

