/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeParameterPattern;

public class TypeParameterLocator
extends PatternLocator {
    protected TypeParameterPattern pattern;

    public TypeParameterLocator(TypeParameterPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    @Override
    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        if (this.pattern.findReferences && node instanceof SingleTypeReference && this.matchesName(this.pattern.name, ((SingleTypeReference)node).token)) {
            int level = this.pattern.mustResolve ? 2 : 3;
            return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, level);
        }
        return 0;
    }

    @Override
    public int match(Type node, MatchingNodeSet nodeSet, MatchLocator locator) {
        SimpleType simple;
        if (this.pattern.findReferences && node instanceof SimpleType && this.matchesName(this.pattern.name, (simple = (SimpleType)node).getName().toString().toCharArray())) {
            int level = this.pattern.mustResolve ? 2 : 3;
            return nodeSet.addMatch(node, level);
        }
        return 0;
    }

    @Override
    public int match(TypeParameter node, MatchingNodeSet nodeSet, MatchLocator locator) {
        if (this.pattern.findReferences && this.matchesName(this.pattern.name, node.getName().toString().toCharArray())) {
            int level = this.pattern.mustResolve ? 2 : 3;
            return nodeSet.addMatch(node, level);
        }
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, node.getName().toString().toCharArray())) {
            int level = this.pattern.mustResolve ? 2 : 3;
            return nodeSet.addMatch(node, level);
        }
        return 0;
    }

    @Override
    public int match(org.eclipse.jdt.internal.compiler.ast.TypeParameter node, MatchingNodeSet nodeSet) {
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, node.name)) {
            int level = this.pattern.mustResolve ? 2 : 3;
            return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, level);
        }
        return 0;
    }

    @Override
    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 6;
    }

    protected int matchTypeParameter(TypeVariableBinding variable, boolean matchName) {
        if (variable == null || variable.declaringElement == null) {
            return 1;
        }
        if (variable.declaringElement instanceof ReferenceBinding) {
            ReferenceBinding refBinding = (ReferenceBinding)variable.declaringElement;
            if (this.matchesName(refBinding.sourceName, this.pattern.declaringMemberName)) {
                return 3;
            }
        } else if (variable.declaringElement instanceof MethodBinding) {
            MethodBinding methBinding = (MethodBinding)variable.declaringElement;
            if (this.matchesName(methBinding.declaringClass.sourceName, this.pattern.methodDeclaringClassName) && (methBinding.isConstructor() || this.matchesName(methBinding.selector, this.pattern.declaringMemberName))) {
                int length;
                int n = length = this.pattern.methodArgumentTypes == null ? 0 : this.pattern.methodArgumentTypes.length;
                if (methBinding.parameters == null) {
                    if (length == 0) {
                        return 3;
                    }
                } else if (methBinding.parameters.length == length) {
                    int i = 0;
                    while (i < length) {
                        if (!this.matchesName(methBinding.parameters[i].shortReadableName(), this.pattern.methodArgumentTypes[i])) {
                            return 0;
                        }
                        ++i;
                    }
                    return 3;
                }
            }
        }
        return 0;
    }

    protected int matchTypeParameter(ITypeBinding variable, boolean matchName) {
        IMethodBinding methBinding;
        if (variable.getDeclaringMethod() != null && this.matchesName((methBinding = variable.getDeclaringMethod()).getDeclaringClass().getName().toCharArray(), this.pattern.methodDeclaringClassName) && (methBinding.isConstructor() || this.matchesName(methBinding.getName().toCharArray(), this.pattern.declaringMemberName))) {
            int length;
            int n = length = this.pattern.methodArgumentTypes == null ? 0 : this.pattern.methodArgumentTypes.length;
            if (methBinding.getParameterTypes() == null) {
                if (length == 0) {
                    return 3;
                }
            } else if (methBinding.getParameterTypes().length == length) {
                ITypeBinding[] p = methBinding.getParameterTypes();
                int i = 0;
                while (i < length) {
                    if (!this.matchesName(this.pattern.methodArgumentTypes[i], p[i].getName().toCharArray())) {
                        return 0;
                    }
                    ++i;
                }
                return 3;
            }
        }
        if (variable.getDeclaringMember() != null && this.matchesName(variable.getDeclaringMember().getName().toCharArray(), this.pattern.declaringMemberName)) {
            return 3;
        }
        return 0;
    }

    @Override
    protected int referenceType() {
        return 15;
    }

    @Override
    public int resolveLevel(org.eclipse.jdt.internal.compiler.ast.ASTNode possibleMatchingNode) {
        if (this.pattern.findReferences && possibleMatchingNode instanceof SingleTypeReference) {
            return this.resolveLevel((Binding)((SingleTypeReference)possibleMatchingNode).resolvedType);
        }
        if (this.pattern.findDeclarations && possibleMatchingNode instanceof org.eclipse.jdt.internal.compiler.ast.TypeParameter) {
            return this.matchTypeParameter(((org.eclipse.jdt.internal.compiler.ast.TypeParameter)possibleMatchingNode).binding, true);
        }
        return 0;
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof TypeVariableBinding)) {
            return 0;
        }
        return this.matchTypeParameter((TypeVariableBinding)binding, true);
    }

    @Override
    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof ITypeBinding)) {
            return 0;
        }
        ITypeBinding tb = (ITypeBinding)binding;
        int ret = this.matchTypeParameter(tb, true);
        if (ret == 3 && !this.pattern.findDeclarations && TypeParameterLocator.nodeSourceRangeMatchesElement(node, this.pattern.focus)) {
            return 0;
        }
        return ret;
    }

    private static boolean nodeSourceRangeMatchesElement(ASTNode node, IJavaElement focus) {
        if (focus == null) {
            return false;
        }
        ISourceRange sr = null;
        try {
            if (focus instanceof ISourceReference) {
                ISourceReference isr2 = (ISourceReference)((Object)focus);
                sr = isr2.getSourceRange();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (sr == null) {
            return false;
        }
        return sr.getOffset() == node.getStartPosition() && sr.getLength() == node.getLength();
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

