/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.buildpath.P2Utils;
import org.eclipse.jdt.junit.JUnitCore;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class BuildPathSupport {
    public static final String JUNIT_JUPITER_VERSION = "[5.0.0,6.0.0)";
    public static final String JUNIT_PLATFORM_VERSION = "[1.0.0,2.0.0)";
    public static final String JUNIT_JUPITER_API = "junit-jupiter-api";
    public static final String JUNIT_JUPITER_ENGINE = "junit-jupiter-engine";
    public static final String JUNIT_JUPITER_MIGRATIONSUPPORT = "junit-jupiter-migrationsupport";
    public static final String JUNIT_JUPITER_PARAMS = "junit-jupiter-params";
    public static final String JUNIT_PLATFORM_COMMONS = "junit-platform-commons";
    public static final String JUNIT_PLATFORM_ENGINE = "junit-platform-engine";
    public static final String JUNIT_PLATFORM_LAUNCHER = "junit-platform-launcher";
    public static final String JUNIT_PLATFORM_RUNNER = "junit-platform-runner";
    public static final String JUNIT_PLATFORM_SUITE_API = "junit-platform-suite-api";
    public static final String JUNIT_PLATFORM_SUITE_ENGINE = "junit-platform-suite-engine";
    public static final String JUNIT_PLATFORM_SUITE_COMMONS = "junit-platform-suite-commons";
    public static final String JUNIT_VINTAGE_ENGINE = "junit-vintage-engine";
    public static final JUnitPluginDescription JUNIT3_PLUGIN = new JUnitPluginDescription("org.junit", new VersionRange("[3.8.2,3.9)"), "junit.jar", "junit.jar", "org.junit.source", "source-bundle/", "org.eclipse.jdt.junit.junit3.javadoclocation");
    public static final JUnitPluginDescription JUNIT4_PLUGIN = new JUnitPluginDescription("org.junit", new VersionRange("[4.13.0,5.0.0)"), null, "org.junit_4.*.jar", "org.junit.source", "source-bundle/", "org.eclipse.jdt.junit.junit4.javadoclocation");
    private static final JUnitPluginDescription HAMCREST_PLUGIN = new JUnitPluginDescription("org.hamcrest", new VersionRange("[2.2.0,3.1.0)"), null, "org.hamcrest_2.*.jar", "org.hamcrest.source", "source-bundle/", "org.eclipse.jdt.junit.junit4.hamcrest.javadoclocation");
    public static final JUnitPluginDescription JUNIT_JUPITER_API_PLUGIN = new JUnitPluginDescription("junit-jupiter-api", new VersionRange("[5.0.0,6.0.0)"), null, "junit-jupiter-api_5.*.jar", "junit-jupiter-api.source", "", "org.eclipse.jdt.junit.junit5.jupiter.api.javadoclocation");
    public static final JUnitPluginDescription JUNIT_JUPITER_ENGINE_PLUGIN = new JUnitPluginDescription("junit-jupiter-engine", new VersionRange("[5.0.0,6.0.0)"), null, "junit-jupiter-engine_5.*.jar", "junit-jupiter-engine.source", "", "org.eclipse.jdt.junit.junit5.jupiter.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT_JUPITER_MIGRATIONSUPPORT_PLUGIN = new JUnitPluginDescription("junit-jupiter-migrationsupport", new VersionRange("[5.0.0,6.0.0)"), null, "junit-jupiter-migrationsupport_5.*.jar", "junit-jupiter-migrationsupport.source", "", "org.eclipse.jdt.junit.junit5.jupiter.migrationsupport.javadoclocation");
    public static final JUnitPluginDescription JUNIT_JUPITER_PARAMS_PLUGIN = new JUnitPluginDescription("junit-jupiter-params", new VersionRange("[5.0.0,6.0.0)"), null, "junit-jupiter-params_5.*.jar", "junit-jupiter-params.source", "", "org.eclipse.jdt.junit.junit5.jupiter.params.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_COMMONS_PLUGIN = new JUnitPluginDescription("junit-platform-commons", new VersionRange("[1.0.0,2.0.0)"), null, "junit-platform-commons_1.*.jar", "junit-platform-commons.source", "", "org.eclipse.jdt.junit.junit5.platform.commons.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_ENGINE_PLUGIN = new JUnitPluginDescription("junit-platform-engine", new VersionRange("[1.0.0,2.0.0)"), null, "junit-platform-engine_1.*.jar", "junit-platform-engine.source", "", "org.eclipse.jdt.junit.junit5.platform.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_LAUNCHER_PLUGIN = new JUnitPluginDescription("junit-platform-launcher", new VersionRange("[1.0.0,2.0.0)"), null, "junit-platform-launcher_1.*.jar", "junit-platform-launcher.source", "", "org.eclipse.jdt.junit.junit5.platform.launcher.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_RUNNER_PLUGIN = new JUnitPluginDescription("junit-platform-runner", new VersionRange("[1.0.0,2.0.0)"), null, "junit-platform-runner_1.*.jar", "junit-platform-runner.source", "", "org.eclipse.jdt.junit.junit5.platform.runner.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_SUITE_API_PLUGIN = new JUnitPluginDescription("junit-platform-suite-api", new VersionRange("[1.0.0,2.0.0)"), null, "junit-platform-suite-api_1.*.jar", "junit-platform-suite-api.source", "", "org.eclipse.jdt.junit.junit5.platform.suite.api.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_SUITE_ENGINE_PLUGIN = new JUnitPluginDescription("junit-platform-suite-engine", new VersionRange("[1.0.0,2.0.0)"), null, "junit-platform-suite-engine_1.*.jar", "junit-platform-suite-engine.source", "", "org.eclipse.jdt.junit.junit5.platform.suite.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT_PLATFORM_SUITE_COMMONS_PLUGIN = new JUnitPluginDescription("junit-platform-suite-commons", new VersionRange("[1.0.0,2.0.0)"), null, "junit-platform-suite-commons_1.*.jar", "junit-platform-suite-commons.source", "", "org.eclipse.jdt.junit.junit5.platform.suite.commons.javadoclocation");
    public static final JUnitPluginDescription JUNIT_VINTAGE_ENGINE_PLUGIN = new JUnitPluginDescription("junit-vintage-engine", new VersionRange("[4.12.0,6.0.0)"), null, "junit-vintage-engine_5.*.jar", "org.junit.vintage.engine.source", "", "org.eclipse.jdt.junit.junit5.vintage.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT_OPENTEST4J_PLUGIN = new JUnitPluginDescription("org.opentest4j", new VersionRange("[1.0.0,2.0.0)"), null, "org.opentest4j_1.*.jar", "org.opentest4j.source", "", "org.eclipse.jdt.junit.junit5.opentest4j.javadoclocation");
    public static final JUnitPluginDescription JUNIT_APIGUARDIAN_PLUGIN = new JUnitPluginDescription("org.apiguardian.api", new VersionRange("[1.0.0,2.0.0)"), null, "org.apiguardian.api_1.*.jar", "org.apiguardian.api.source", "", "org.eclipse.jdt.junit.junit5.apiguardian.javadoclocation");
    public static final JUnitPluginDescription JUNIT6_JUPITER_API_PLUGIN = new JUnitPluginDescription("junit-jupiter-api", new VersionRange("[6.0.0,7.0.0)"), null, "junit-jupiter-api_6.*.jar", "junit-jupiter-api.source", "", "org.eclipse.jdt.junit.junit5.jupiter.api.javadoclocation");
    public static final JUnitPluginDescription JUNIT6_JUPITER_ENGINE_PLUGIN = new JUnitPluginDescription("junit-jupiter-engine", new VersionRange("[6.0.0,7.0.0)"), null, "junit-jupiter-engine_6.*.jar", "junit-jupiter-engine.source", "", "org.eclipse.jdt.junit.junit5.jupiter.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT6_JUPITER_PARAMS_PLUGIN = new JUnitPluginDescription("junit-jupiter-params", new VersionRange("[6.0.0,7.0.0)"), null, "junit-jupiter-params_6.*.jar", "junit-jupiter-params.source", "", "org.eclipse.jdt.junit.junit5.jupiter.params.javadoclocation");
    public static final JUnitPluginDescription JUNIT6_PLATFORM_COMMONS_PLUGIN = new JUnitPluginDescription("junit-platform-commons", new VersionRange("[6.0.0,7.0.0)"), null, "junit-platform-commons_6.*.jar", "junit-platform-commons.source", "", "org.eclipse.jdt.junit.junit5.platform.commons.javadoclocation");
    public static final JUnitPluginDescription JUNIT6_PLATFORM_ENGINE_PLUGIN = new JUnitPluginDescription("junit-platform-engine", new VersionRange("[6.0.0,7.0.0)"), null, "junit-platform-engine_6.*.jar", "junit-platform-engine.source", "", "org.eclipse.jdt.junit.junit5.platform.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT6_PLATFORM_LAUNCHER_PLUGIN = new JUnitPluginDescription("junit-platform-launcher", new VersionRange("[6.0.0,7.0.0)"), null, "junit-platform-launcher_6.*.jar", "junit-platform-launcher.source", "", "org.eclipse.jdt.junit.junit5.platform.launcher.javadoclocation");
    public static final JUnitPluginDescription JUNIT6_PLATFORM_SUITE_API_PLUGIN = new JUnitPluginDescription("junit-platform-suite-api", new VersionRange("[6.0.0,7.0.0)"), null, "junit-platform-suite-api_6.*.jar", "junit-platform-suite-api.source", "", "org.eclipse.jdt.junit.junit5.platform.suite.api.javadoclocation");
    public static final JUnitPluginDescription JUNIT6_PLATFORM_SUITE_ENGINE_PLUGIN = new JUnitPluginDescription("junit-platform-suite-engine", new VersionRange("[6.0.0,7.0.0)"), null, "junit-platform-suite-engine_6.*.jar", "junit-platform-suite-engine.source", "", "org.eclipse.jdt.junit.junit5.platform.suite.engine.javadoclocation");
    public static final JUnitPluginDescription JUNIT4_AS_3_PLUGIN = new JUnitPluginDescription(BuildPathSupport.JUNIT4_PLUGIN.bundleId, BuildPathSupport.JUNIT4_PLUGIN.versionRange, BuildPathSupport.JUNIT4_PLUGIN.bundleRoot, BuildPathSupport.JUNIT4_PLUGIN.binaryImportedRoot, BuildPathSupport.JUNIT4_PLUGIN.sourceBundleId, BuildPathSupport.JUNIT4_PLUGIN.repositorySource, BuildPathSupport.JUNIT3_PLUGIN.javadocPreferenceKey){

        @Override
        public IAccessRule[] getAccessRules() {
            return new IAccessRule[]{JavaCore.newAccessRule((IPath)new Path("junit/"), (int)0), JavaCore.newAccessRule((IPath)new Path("**/*"), (int)1)};
        }
    };

    public static IClasspathEntry getJUnit3ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT3_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit4ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT4_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit5ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT5_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit6ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT6_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit3LibraryEntry() {
        return JUNIT3_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit4LibraryEntry() {
        return JUNIT4_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit4as3LibraryEntry() {
        return JUNIT4_AS_3_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getHamcrestLibraryEntry() {
        return HAMCREST_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitJupiterApiLibraryEntry() {
        return JUNIT_JUPITER_API_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitJupiterEngineLibraryEntry() {
        return JUNIT_JUPITER_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitJupiterMigrationSupportLibraryEntry() {
        return JUNIT_JUPITER_MIGRATIONSUPPORT_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitJupiterParamsLibraryEntry() {
        return JUNIT_JUPITER_PARAMS_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformCommonsLibraryEntry() {
        return JUNIT_PLATFORM_COMMONS_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformEngineLibraryEntry() {
        return JUNIT_PLATFORM_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformLauncherLibraryEntry() {
        return JUNIT_PLATFORM_LAUNCHER_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformRunnerLibraryEntry() {
        return JUNIT_PLATFORM_RUNNER_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformSuiteApiLibraryEntry() {
        return JUNIT_PLATFORM_SUITE_API_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformSuiteEngineLibraryEntry() {
        return JUNIT_PLATFORM_SUITE_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitPlatformSuiteCommonsLibraryEntry() {
        return JUNIT_PLATFORM_SUITE_COMMONS_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitVintageEngineLibraryEntry() {
        return JUNIT_VINTAGE_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitOpentest4jLibraryEntry() {
        return JUNIT_OPENTEST4J_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnitApiGuardianLibraryEntry() {
        return JUNIT_APIGUARDIAN_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit6JupiterApiLibraryEntry() {
        return JUNIT6_JUPITER_API_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit6JupiterEngineLibraryEntry() {
        return JUNIT6_JUPITER_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit6JupiterParamsLibraryEntry() {
        return JUNIT6_JUPITER_PARAMS_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit6PlatformCommonsLibraryEntry() {
        return JUNIT6_PLATFORM_COMMONS_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit6PlatformEngineLibraryEntry() {
        return JUNIT6_PLATFORM_ENGINE_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit6PlatformLauncherLibraryEntry() {
        return JUNIT6_PLATFORM_LAUNCHER_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit6PlatformSuiteApiLibraryEntry() {
        return JUNIT6_PLATFORM_SUITE_API_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit6PlatformSuiteEngineLibraryEntry() {
        return JUNIT6_PLATFORM_SUITE_ENGINE_PLUGIN.getLibraryEntry();
    }

    private BuildPathSupport() {
    }

    public static class JUnitPluginDescription {
        private final String bundleId;
        private final VersionRange versionRange;
        private final String bundleRoot;
        private final String binaryImportedRoot;
        private final String sourceBundleId;
        private final String repositorySource;
        private final String javadocPreferenceKey;
        private String resolvedVersion = null;

        public JUnitPluginDescription(String bundleId, VersionRange versionRange, String bundleRoot, String binaryImportedRoot, String sourceBundleId, String repositorySource, String javadocPreferenceKey) {
            this.bundleId = bundleId;
            this.versionRange = versionRange;
            this.bundleRoot = bundleRoot;
            this.binaryImportedRoot = binaryImportedRoot;
            this.sourceBundleId = sourceBundleId;
            this.repositorySource = repositorySource;
            this.javadocPreferenceKey = javadocPreferenceKey;
        }

        public IPath getBundleLocation() {
            return this.getBundleLocation(this.bundleId, this.versionRange);
        }

        public IPath getSourceBundleLocation() {
            return this.getSourceLocation(this.getBundleLocation());
        }

        private IPath getBundleLocation(String aBundleId, VersionRange aVersionRange) {
            return this.getBundleLocation(aBundleId, aVersionRange, false);
        }

        private IPath getBundleLocation(String aBundleId, VersionRange aVersionRange, boolean isSourceBundle) {
            BundleInfo bundleInfo = P2Utils.findBundle(aBundleId, aVersionRange, isSourceBundle);
            if (bundleInfo != null) {
                this.resolvedVersion = bundleInfo.getVersion();
                return P2Utils.getBundleLocationPath(bundleInfo);
            }
            Bundle[] bundles = Platform.getBundles((String)aBundleId, (String)aVersionRange.toString());
            Bundle bestMatch = null;
            if (bundles != null) {
                Bundle[] bundleArray = bundles;
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    if (bestMatch == null || bundle.getState() > bestMatch.getState()) {
                        bestMatch = bundle;
                    }
                    ++n2;
                }
            }
            if (bestMatch == null) {
                return null;
            }
            this.resolvedVersion = bestMatch.getVersion().toString();
            if (this.bundleRoot == null) {
                Optional bundleFile = FileLocator.getBundleFileLocation(bestMatch);
                return bundleFile.isPresent() ? new Path(((File)bundleFile.get()).getAbsolutePath()) : null;
            }
            URL rootUrl = bestMatch.getEntry("/");
            try {
                URL fileRootUrl = FileLocator.toFileURL((URL)rootUrl);
                return new Path(fileRootUrl.getPath());
            }
            catch (IOException ex) {
                JUnitCorePlugin.log(ex);
                return null;
            }
        }

        private IPath getBundleFileLocation(String aBundleId, VersionRange aVersionRange, String filePath) {
            BundleInfo bundleInfo = P2Utils.findBundle(aBundleId, aVersionRange, false);
            if (bundleInfo != null) {
                this.resolvedVersion = bundleInfo.getVersion();
                IPath bundleLocation = P2Utils.getBundleLocationPath(bundleInfo);
                if (bundleLocation != null) {
                    File bundleLoc = bundleLocation.toFile();
                    if (bundleLoc.isDirectory() && new File(bundleLoc, filePath).exists()) {
                        return bundleLocation.append(filePath);
                    }
                    if (bundleLoc.isFile() && bundleLoc.getName().endsWith(".jar")) {
                        return this.extractArchiveEntry(bundleInfo, bundleLoc, filePath);
                    }
                }
            } else {
                Bundle[] bundles = Platform.getBundles((String)aBundleId, (String)aVersionRange.toString());
                Bundle bestMatch = null;
                if (bundles != null) {
                    Bundle[] bundleArray = bundles;
                    int n = bundles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Bundle bundle = bundleArray[n2];
                        if (bestMatch == null || bundle.getState() > bestMatch.getState()) {
                            bestMatch = bundle;
                        }
                        ++n2;
                    }
                }
                if (bestMatch != null) {
                    try {
                        this.resolvedVersion = bestMatch.getVersion().toString();
                        URL rootUrl = bestMatch.getEntry(filePath);
                        if (rootUrl != null) {
                            URL fileRootUrl = FileLocator.toFileURL((URL)rootUrl);
                            return new Path(fileRootUrl.getPath());
                        }
                    }
                    catch (IOException ex) {
                        JUnitCorePlugin.log(ex);
                    }
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IPath extractArchiveEntry(BundleInfo bundleInfo, File bundleLoc, String filePath) {
            IPath container = JUnitCorePlugin.getDefault().getStateLocation().append(bundleInfo.getSymbolicName()).append(bundleInfo.getVersion());
            IPath extractedPath = container.append(filePath);
            if (extractedPath.toFile().exists()) {
                return extractedPath;
            }
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (JarFile jar = new JarFile(bundleLoc);){
                    ZipEntry entry = jar.getEntry(filePath);
                    if (entry == null) return null;
                    if (!container.toFile().exists() && !container.toFile().mkdirs()) {
                        JUnitCorePlugin.log((IStatus)new Status(4, "org.eclipse.jdt.junit.core", "Unable to create directory to hold " + filePath));
                        return null;
                    }
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try {
                        InputStream input = jar.getInputStream(entry);
                        try {
                            try (OutputStream output = Files.newOutputStream(extractedPath.toFile().toPath(), new OpenOption[0]);){
                                int bytesRead;
                                byte[] buffer = new byte[8192];
                                while ((bytesRead = input.read(buffer)) > 0) {
                                    output.write(buffer, 0, bytesRead);
                                }
                            }
                            if (input == null) return extractedPath;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (input == null) throw throwable2;
                            input.close();
                            throw throwable2;
                        }
                        input.close();
                        return extractedPath;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            catch (IOException ex) {
                JUnitCorePlugin.log(ex);
            }
            return null;
        }

        public IClasspathEntry getLibraryEntry() {
            IPath bundleLocation = this.getBundleLocation(this.bundleId, this.versionRange);
            if (bundleLocation != null) {
                IPath bundleRootLocation = null;
                if (this.bundleRoot != null && (bundleRootLocation = this.getBundleFileLocation(this.bundleId, this.versionRange, this.bundleRoot)) == null) {
                    bundleRootLocation = this.getLocationIfExists(bundleLocation, this.bundleRoot);
                }
                if (bundleRootLocation == null && this.binaryImportedRoot != null) {
                    bundleRootLocation = this.getLocationIfExists(bundleLocation, this.binaryImportedRoot);
                }
                if (bundleRootLocation == null) {
                    bundleRootLocation = this.getBundleLocation(this.bundleId, this.versionRange);
                }
                IPath srcLocation = this.getSourceLocation(bundleLocation);
                String javadocLocation = Platform.getPreferencesService().getString("org.eclipse.jdt.junit.core", this.javadocPreferenceKey, "", null);
                IClasspathAttribute[] attributes = javadocLocation.length() == 0 ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation)};
                return JavaCore.newLibraryEntry((IPath)bundleRootLocation, (IPath)srcLocation, null, (IAccessRule[])this.getAccessRules(), (IClasspathAttribute[])attributes, (boolean)false);
            }
            String message = "Unable to compute bundle location for '" + this.bundleId + "' with range " + String.valueOf(this.versionRange);
            JUnitCorePlugin.log(Status.error((String)message, (Throwable)new IllegalStateException(message)));
            return null;
        }

        public IAccessRule[] getAccessRules() {
            return new IAccessRule[0];
        }

        private IPath getSourceLocation(IPath bundleLocation) {
            IPath srcLocation = null;
            if (this.repositorySource != null) {
                srcLocation = this.getLocationIfExists(bundleLocation, this.repositorySource);
            }
            if (srcLocation == null) {
                if (bundleLocation != null) {
                    Version version = new Version(this.resolvedVersion);
                    srcLocation = this.getBundleLocation(this.sourceBundleId, new VersionRange('[', version, version, ']'), true);
                }
                if (srcLocation == null) {
                    srcLocation = this.getBundleLocation(this.sourceBundleId, this.versionRange, true);
                }
            }
            return srcLocation;
        }

        private IPath getLocationIfExists(IPath bundleLocationPath, String entryInBundle) {
            File bundleFile;
            Path srcLocation = null;
            if (bundleLocationPath != null && (bundleFile = bundleLocationPath.toFile()).isDirectory()) {
                File[] files;
                File srcFile = null;
                int starIdx = entryInBundle.indexOf(42);
                if (starIdx != -1 && (files = bundleFile.listFiles(new FilenameFilter(entryInBundle, starIdx){
                    private String pre;
                    private String post;
                    {
                        this.pre = string.substring(0, n);
                        this.post = string.substring(n + 1);
                    }

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(this.pre) && name.endsWith(this.post);
                    }
                })).length > 0) {
                    srcFile = files[0];
                }
                if (srcFile == null) {
                    srcFile = new File(bundleFile, entryInBundle);
                }
                if (srcFile.exists()) {
                    srcLocation = new Path(srcFile.getPath());
                    if (srcFile.isDirectory()) {
                        srcLocation = srcLocation.addTrailingSeparator();
                    }
                }
            }
            return srcLocation;
        }
    }
}

