/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin.dependency;

import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.impl.DefaultArtifact;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleModuleDependency;
import com.microsoft.java.bs.gradle.plugin.utils.AndroidUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.specs.Specs;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;

public class AndroidDependencyCollector {
    private static final String UNKNOWN = "unknown";

    public static Set<GradleModuleDependency> getModuleDependencies(Project project, Object variant) {
        HashSet<GradleModuleDependency> dependencies = new HashSet<GradleModuleDependency>();
        try {
            Configuration compileConfiguration = (Configuration)AndroidUtils.getProperty(variant, "compileConfiguration");
            dependencies.addAll(AndroidDependencyCollector.resolveConfigurationDependencies(project, compileConfiguration));
            Configuration runtimeConfiguration = (Configuration)AndroidUtils.getProperty(variant, "runtimeConfiguration");
            dependencies.addAll(AndroidDependencyCollector.resolveConfigurationDependencies(project, runtimeConfiguration));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return dependencies;
    }

    private static Set<GradleModuleDependency> resolveConfigurationDependencies(Project project, Configuration configuration) {
        return configuration.getIncoming().artifactView(viewConfiguration -> {
            viewConfiguration.lenient(true);
            viewConfiguration.componentFilter(Specs.satisfyAll());
        }).getArtifacts().getArtifacts().stream().map(artifactResult -> AndroidDependencyCollector.getArtifact(project, artifactResult)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static DefaultGradleModuleDependency getArtifact(Project project, ResolvedArtifactResult artifactResult) {
        ComponentArtifactIdentifier id = artifactResult.getId();
        File artifactFile = artifactResult.getFile();
        if (id instanceof ModuleComponentArtifactIdentifier) {
            return AndroidDependencyCollector.getModuleArtifactDependency(project, (ModuleComponentArtifactIdentifier)id, artifactFile);
        }
        if (id instanceof OpaqueComponentArtifactIdentifier) {
            return AndroidDependencyCollector.getFileArtifactDependency((OpaqueComponentArtifactIdentifier)id, artifactFile);
        }
        if (id instanceof ComponentFileArtifactIdentifier) {
            return AndroidDependencyCollector.getFileArtifactDependency((ComponentFileArtifactIdentifier)id, artifactFile);
        }
        return null;
    }

    private static DefaultGradleModuleDependency getModuleArtifactDependency(Project project, ModuleComponentArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        File javaDocJar;
        Set resolvedComponents;
        File sourceJar;
        ArtifactResolutionResult resolutionResult = project.getDependencies().createArtifactResolutionQuery().forComponents(new ComponentIdentifier[]{artifactIdentifier.getComponentIdentifier()}).withArtifacts(JvmLibrary.class, new Class[]{JavadocArtifact.class, SourcesArtifact.class}).execute();
        LinkedList<com.microsoft.java.bs.gradle.model.Artifact> artifacts = new LinkedList<com.microsoft.java.bs.gradle.model.Artifact>();
        if (resolvedArtifactFile != null) {
            artifacts.add(new DefaultArtifact(resolvedArtifactFile.toURI(), null));
        }
        if ((sourceJar = AndroidDependencyCollector.getNonClassesArtifact(resolvedComponents = resolutionResult.getResolvedComponents(), SourcesArtifact.class)) != null) {
            artifacts.add(new DefaultArtifact(sourceJar.toURI(), "sources"));
        }
        if ((javaDocJar = AndroidDependencyCollector.getNonClassesArtifact(resolvedComponents, JavadocArtifact.class)) != null) {
            artifacts.add(new DefaultArtifact(javaDocJar.toURI(), "javadoc"));
        }
        return new DefaultGradleModuleDependency(artifactIdentifier.getComponentIdentifier().getGroup(), artifactIdentifier.getComponentIdentifier().getModule(), artifactIdentifier.getComponentIdentifier().getVersion(), artifacts);
    }

    private static File getNonClassesArtifact(Set<ComponentArtifactsResult> resolvedComponents, Class<? extends Artifact> artifactClass) {
        for (ComponentArtifactsResult component : resolvedComponents) {
            Set artifacts = component.getArtifacts(artifactClass);
            for (ArtifactResult artifact : artifacts) {
                if (!(artifact instanceof ResolvedArtifactResult)) continue;
                return ((ResolvedArtifactResult)artifact).getFile();
            }
        }
        return null;
    }

    private static DefaultGradleModuleDependency getFileArtifactDependency(ComponentFileArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        return AndroidDependencyCollector.getFileArtifactDependency(artifactIdentifier.getCapitalizedDisplayName(), resolvedArtifactFile);
    }

    private static DefaultGradleModuleDependency getFileArtifactDependency(OpaqueComponentArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        return AndroidDependencyCollector.getFileArtifactDependency(artifactIdentifier.getCapitalizedDisplayName(), resolvedArtifactFile);
    }

    private static DefaultGradleModuleDependency getFileArtifactDependency(String displayName, File resolvedArtifactFile) {
        LinkedList<com.microsoft.java.bs.gradle.model.Artifact> artifacts = new LinkedList<com.microsoft.java.bs.gradle.model.Artifact>();
        if (resolvedArtifactFile != null) {
            artifacts.add(new DefaultArtifact(resolvedArtifactFile.toURI(), null));
        }
        return new DefaultGradleModuleDependency(UNKNOWN, displayName, UNKNOWN, artifacts);
    }
}

