/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.util.KeyToSignature;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public class TypeArgumentMatchingUtility {
    public static boolean validateSingleTypeArgMatches(boolean requiresExactMatch, String patternSig, IBinding patternBinding, IBinding domBinding) {
        return TypeArgumentMatchingUtility.validateSingleTypeArgMatches(requiresExactMatch, patternSig, patternBinding, domBinding, null);
    }

    public static boolean validateSingleTypeArgMatches(boolean requiresExactMatch, String patternSig, IBinding patternBinding, IBinding domBinding, PatternLocator locator) {
        String string;
        ITypeBinding domTypeBinding = domBinding instanceof ITypeBinding ? (ITypeBinding)domBinding : null;
        String domKey1 = domBinding == null ? null : domBinding.getKey();
        String domSig = null;
        if (TypeArgumentMatchingUtility.isQuestionMark(domKey1)) {
            domSig = domKey1;
        } else if (domKey1 != null) {
            try {
                KeyToSignature ks = new KeyToSignature(domKey1, 0);
                ks.parse();
                domSig = ks.toString();
            }
            catch (RuntimeException ks) {
                // empty catch block
            }
        }
        if (domSig == null && domBinding != null) {
            if (domBinding instanceof JavacTypeBinding) {
                JavacTypeBinding jctb = (JavacTypeBinding)domBinding;
                v0 = jctb.getGenericTypeSignature(false);
            } else {
                v0 = domSig = domBinding.getKey();
            }
        }
        if (requiresExactMatch) {
            if (Objects.equals(patternSig, domSig)) {
                return true;
            }
            if (patternSig.equals("*") && TypeArgumentMatchingUtility.isQuestionMark(domSig)) {
                return true;
            }
            if (patternSig.startsWith("Q")) {
                char[] bindingCharArr;
                String patternSimpleName = null;
                try {
                    patternSimpleName = Signature.getSignatureSimpleName((String)patternSig);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                String bindingSimpleName = null;
                try {
                    bindingSimpleName = Signature.getSignatureSimpleName((String)domSig);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (Objects.equals(patternSimpleName, bindingSimpleName)) {
                    return true;
                }
                char[] patternCharArr = patternSimpleName == null ? null : patternSimpleName.toCharArray();
                char[] cArray = bindingCharArr = bindingSimpleName == null ? null : bindingSimpleName.toCharArray();
                if (locator != null && locator.matchesName(patternCharArr, bindingCharArr)) {
                    return true;
                }
                if (patternSimpleName != null && patternSimpleName.startsWith(bindingSimpleName + "<")) {
                    return true;
                }
            }
            return false;
        }
        if (patternSig.equals("*")) {
            return true;
        }
        if (patternSig.equals(domSig)) {
            return true;
        }
        if (patternBinding == null) {
            string = null;
        } else if (patternBinding instanceof JavacTypeBinding) {
            JavacTypeBinding jctb = (JavacTypeBinding)patternBinding;
            string = jctb.getGenericTypeSignature(false);
        } else {
            string = patternBinding.getKey();
        }
        String patternKeyFromBinding = string;
        List<Object> patternAncestors = new ArrayList();
        if (patternBinding instanceof ITypeBinding) {
            ITypeBinding patternTypeBinding = (ITypeBinding)patternBinding;
            patternAncestors = patternSig.startsWith("+") || patternSig.startsWith("-") ? TypeArgumentMatchingUtility.findAllSuperclassAndInterfaceBindingsForWildcard(patternTypeBinding) : TypeArgumentMatchingUtility.findAllSuperclassAndInterfaceBindings(patternTypeBinding);
        }
        List patternAncestorKeys = patternAncestors.stream().map(x -> {
            String string;
            if (x instanceof JavacTypeBinding) {
                JavacTypeBinding jctb = (JavacTypeBinding)x;
                string = jctb.getGenericTypeSignature(false);
            } else {
                string = x.getKey();
            }
            return string;
        }).collect(Collectors.toList());
        if (patternSig.startsWith("-")) {
            if (domSig.startsWith("-") || !domSig.startsWith("+")) {
                String domKey;
                if (domBinding instanceof JavacTypeBinding) {
                    JavacTypeBinding jctb = (JavacTypeBinding)domBinding;
                    v3 = jctb.getGenericTypeSignature(false);
                } else {
                    v3 = domKey = domBinding.getKey();
                }
                if (!patternAncestorKeys.contains(domKey)) {
                    return false;
                }
            } else if (domSig.startsWith("+") && !TypeArgumentMatchingUtility.isQuestionMark(domSig)) {
                return false;
            }
        } else if (patternSig.startsWith("+")) {
            if (domSig.startsWith("-")) {
                return false;
            }
            List<IBinding> domHeirarchy = TypeArgumentMatchingUtility.findAllSuperclassAndInterfaceBindingsForWildcard(domTypeBinding);
            List<String> domHeirarchyStrings = domHeirarchy.stream().map(x -> {
                String string;
                if (x instanceof JavacTypeBinding) {
                    JavacTypeBinding jctb = (JavacTypeBinding)x;
                    string = jctb.getGenericTypeSignature(false);
                } else {
                    string = x.getKey();
                }
                return string;
            }).collect(Collectors.toList());
            if (patternKeyFromBinding != null ? !TypeArgumentMatchingUtility.resolvedPatternMatchesDom(patternSig.substring(1), patternKeyFromBinding, domTypeBinding, domHeirarchyStrings) : !TypeArgumentMatchingUtility.unresolvedPatternMatchesDom(patternSig, domSig, domTypeBinding, domHeirarchyStrings)) {
                return false;
            }
        } else if (domSig.startsWith("-")) {
            List<IBinding> domHeirarchy = TypeArgumentMatchingUtility.findAllSuperclassAndInterfaceBindingsForWildcard(domTypeBinding);
            List domHeirarchyStrings = domHeirarchy.stream().map(x -> {
                String string;
                if (x instanceof JavacTypeBinding) {
                    JavacTypeBinding jctb = (JavacTypeBinding)x;
                    string = jctb.getGenericTypeSignature(false);
                } else {
                    string = x.getKey();
                }
                return string;
            }).collect(Collectors.toList());
            if (patternKeyFromBinding == null && !domHeirarchyStrings.contains(patternKeyFromBinding)) {
                return false;
            }
        } else if (domSig.startsWith("+")) {
            if (domTypeBinding != null) {
                String boundKey;
                ITypeBinding bound = domTypeBinding.getBound();
                if (bound == null) {
                    v4 = null;
                } else if (bound instanceof JavacTypeBinding) {
                    JavacTypeBinding jctb = (JavacTypeBinding)bound;
                    v4 = jctb.getGenericTypeSignature(false);
                } else {
                    v4 = boundKey = bound.getKey();
                }
                if (!(TypeArgumentMatchingUtility.isQuestionMark(domSig) || boundKey != null && patternAncestorKeys.contains(boundKey))) {
                    return false;
                }
            }
        } else if (!patternSig.equals(domSig)) {
            boolean unresolvedMatch = TypeArgumentMatchingUtility.unresolvedPatternMatchesDom(patternSig, domSig, domTypeBinding, new ArrayList<String>());
            if (unresolvedMatch) {
                return true;
            }
            if (locator != null && patternSig.startsWith("Q") && domSig != null) {
                boolean stringMatch;
                String dSig;
                String patSig1 = patternSig.substring(1);
                String string2 = dSig = domSig.lastIndexOf(".") == -1 ? null : domSig.substring(domSig.lastIndexOf(".") + 1);
                if (dSig != null && (stringMatch = locator.matchesName(patSig1.toCharArray(), dSig.toCharArray()))) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean resolvedPatternMatchesDom(String patternSig, String patternKeyFromBinding, ITypeBinding domTypeBinding, List<String> domHeirarchyStrings) {
        String k;
        if (domTypeBinding instanceof JavacTypeBinding) {
            JavacTypeBinding jctb = (JavacTypeBinding)domTypeBinding;
            v0 = jctb.getGenericTypeSignature(false);
        } else {
            v0 = k = domTypeBinding.getKey();
        }
        if (TypeArgumentMatchingUtility.isQuestionMark(k)) {
            return true;
        }
        if (domHeirarchyStrings.contains(patternSig)) {
            return true;
        }
        if (patternKeyFromBinding != null) {
            if (domHeirarchyStrings.contains(patternKeyFromBinding)) {
                return true;
            }
            if (patternKeyFromBinding.startsWith("+") && domHeirarchyStrings.contains(patternKeyFromBinding.substring(1))) {
                return true;
            }
        }
        return false;
    }

    private static boolean unresolvedPatternMatchesDom(String patternSig, String domSig, ITypeBinding domTypeBinding, List<String> domHeirarchyStrings) {
        boolean patternSigIsUnresolved = false;
        String patternSigTrimmed = null;
        if (patternSig.startsWith("Q")) {
            patternSigTrimmed = patternSig.substring(1);
            patternSigIsUnresolved = true;
        } else if (patternSig.startsWith("+Q")) {
            patternSigTrimmed = patternSig.substring(2);
            patternSigIsUnresolved = true;
        }
        if (patternSigIsUnresolved && domSig.endsWith("." + patternSigTrimmed)) {
            return true;
        }
        String patternSigWithoutPrefix = patternSig.startsWith("+") || patternSig.startsWith("-") ? patternSig.substring(1) : patternSig;
        String domSigWithoutPrefix = domSig.startsWith("+") || domSig.startsWith("-") ? domSig.substring(1) : domSig;
        String patternSig2 = patternSigWithoutPrefix.substring(1);
        if (patternSig2.equals(domSigWithoutPrefix.substring(1))) {
            return true;
        }
        return domSig.endsWith("." + patternSig2);
    }

    private static boolean isQuestionMark(String k) {
        boolean isQuestionMark = "+Ljava/lang/Object;".equals(k) || "+Ljava.lang.Object;".equals(k) || "+Qjava.lang.Object;".equals(k);
        return isQuestionMark;
    }

    private static List<IBinding> findAllSuperclassAndInterfaceBindingsForWildcard(ITypeBinding binding) {
        ITypeBinding param;
        ArrayList<IBinding> ret = new ArrayList<IBinding>();
        if (binding == null) {
            return ret;
        }
        ITypeBinding iTypeBinding = param = binding.isWildcardType() ? binding.getBound() : binding;
        if (param != null) {
            ret.add((IBinding)param);
            TypeArgumentMatchingUtility.fillAllSuperclassAndInterfaceBindings(param, ret);
        } else {
            ret.add((IBinding)binding);
        }
        return ret;
    }

    private static List<IBinding> findAllSuperclassAndInterfaceBindings(ITypeBinding binding) {
        ArrayList<IBinding> ret = new ArrayList<IBinding>();
        if (binding == null) {
            return ret;
        }
        TypeArgumentMatchingUtility.fillAllSuperclassAndInterfaceBindings(binding, ret);
        return ret;
    }

    private static void fillAllSuperclassAndInterfaceBindings(ITypeBinding binding, List<IBinding> list) {
        if (binding == null) {
            return;
        }
        ITypeBinding[] ifaces = binding.getInterfaces();
        for (int q = 0; q < ifaces.length; ++q) {
            ITypeBinding oneInterface = ifaces[q];
            if (oneInterface == null) continue;
            list.add((IBinding)oneInterface);
            TypeArgumentMatchingUtility.fillAllSuperclassAndInterfaceBindings(oneInterface, list);
        }
        ITypeBinding superClaz = binding.getSuperclass();
        if (superClaz != null) {
            list.add((IBinding)superClaz);
            TypeArgumentMatchingUtility.fillAllSuperclassAndInterfaceBindings(superClaz, list);
        }
    }
}

