/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakeDefaultLiteral;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.YieldStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;

public class SwitchStatement
extends Expression {
    public static final SingletonBootstrap PRIMITIVE_CLASS__BOOTSTRAP = new SingletonBootstrap("ConstantBootStraps.primitiveClass", PRIMITIVE_CLASS, PRIMITIVE_CLASS__SIGNATURE);
    public static final SingletonBootstrap GET_STATIC_FINAL__BOOTSTRAP = new SingletonBootstrap("ConstantBootStraps.getStaticFinal", GET_STATIC_FINAL, GET_STATIC_FINAL__SIGNATURE);
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public BranchLabel breakLabel;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public CaseStatement nullCase;
    public int blockStart;
    public int caseCount;
    public static final CaseStatement.LabelExpression[] NO_LABEL_EXPRESSIONS = new CaseStatement.LabelExpression[0];
    public CaseStatement.LabelExpression[] labelExpressions = NO_LABEL_EXPRESSIONS;
    public int labelExpressionIndex = 0;
    public int nConstants;
    public int switchBits;
    public boolean containsPatterns;
    public boolean containsRecordPatterns;
    public boolean containsNull;
    boolean nullProcessed = false;
    BranchLabel switchPatternRestartTarget;
    public Pattern totalPattern;
    public static final int CASE = 0;
    public static final int FALLTHROUGH = 1;
    public static final int BREAKING = 2;
    public static final int LabeledRules = 1;
    public static final int InvalidSelector = 2;
    public static final int Exhaustive = 4;
    public static final int QualifiedEnum = 8;
    public static final int LabeledBlockStatementGroup = 16;
    private static final char[] SecretSelectorVariableName = " selector".toCharArray();
    public SyntheticMethodBinding synthetic;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;
    LocalVariableBinding selector = null;
    boolean isNonTraditional = false;
    boolean isPrimitiveSwitch = false;
    List<Pattern> caseLabelElements = new ArrayList<Pattern>(0);
    public List<TypeBinding> caseLabelElementTypes = new ArrayList<TypeBinding>(0);

    protected boolean needToCheckFlowInAbsenceOfDefaultBranch() {
        return !this.isExhaustive();
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            TypeBinding resolvedTypeBinding;
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
            if (!this.containsNull && this.expression.resolvedType instanceof ReferenceBinding) {
                this.expression.checkNPE(currentScope, flowContext, flowInfo, 1);
            }
            this.breakLabel = new BranchLabel();
            SwitchFlowContext switchContext = new SwitchFlowContext(flowContext, this, this.breakLabel, true, true);
            CompilerOptions compilerOptions = currentScope.compilerOptions();
            FlowInfo caseInits = FlowInfo.DEAD_END;
            this.preSwitchInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
            if (this.statements != null) {
                int initialComplaintLevel;
                int complaintLevel = initialComplaintLevel = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
                int fallThroughState = 0;
                int prevCaseStmtIndex = -100;
                int i = 0;
                int max = this.statements.length;
                while (i < max) {
                    Statement statement = this.statements[i];
                    if (statement instanceof CaseStatement) {
                        CaseStatement caseStatement;
                        this.scope.enclosingCase = caseStatement = (CaseStatement)statement;
                        if (prevCaseStmtIndex == i - 1 && this.statements[prevCaseStmtIndex].containsPatternVariable()) {
                            this.scope.problemReporter().illegalFallthroughFromAPattern(this.statements[prevCaseStmtIndex]);
                        }
                        prevCaseStmtIndex = i;
                        if (fallThroughState == 1 && complaintLevel <= 0) {
                            if (statement.containsPatternVariable()) {
                                this.scope.problemReporter().IllegalFallThroughToPattern(this.scope.enclosingCase);
                            } else if ((statement.bits & 0x20000000) == 0) {
                                this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                            }
                        }
                        caseInits = caseInits.mergedWith(flowInfo.unconditionalInits());
                        if (caseStatement.constantExpressions == NO_EXPRESSIONS && (this.switchBits & 1) != 0 && this.expression.resolvedType instanceof ReferenceBinding) {
                            if (this.expression instanceof NameReference) {
                                NameReference reference = (NameReference)this.expression;
                                if (reference.localVariableBinding() != null) {
                                    caseInits.markAsDefinitelyNonNull(reference.localVariableBinding());
                                } else if (reference.lastFieldBinding() != null && this.scope.compilerOptions().enableSyntacticNullAnalysisForFields) {
                                    switchContext.recordNullCheckedFieldReference(reference, 2);
                                }
                            } else if (this.expression instanceof FieldReference && this.scope.compilerOptions().enableSyntacticNullAnalysisForFields) {
                                switchContext.recordNullCheckedFieldReference((FieldReference)this.expression, 2);
                            }
                        }
                        complaintLevel = initialComplaintLevel;
                        fallThroughState = this.containsPatterns ? 1 : 0;
                    } else {
                        fallThroughState = (this.switchBits & 1) != 0 || statement.doesNotCompleteNormally() ? 2 : 1;
                    }
                    complaintLevel = statement.complainIfUnreachable(caseInits, this.scope, complaintLevel, true);
                    if (complaintLevel < 2) {
                        caseInits = statement.analyseCode(this.scope, switchContext, caseInits);
                        if (compilerOptions.enableSyntacticNullAnalysisForFields) {
                            switchContext.expireNullCheckedFieldInfo();
                        }
                        if (compilerOptions.analyseResourceLeaks) {
                            FakedTrackingVariable.cleanUpUnassigned(this.scope, statement, caseInits, false);
                        }
                    }
                    ++i;
                }
            }
            if ((resolvedTypeBinding = this.expression.resolvedType).isEnum()) {
                SourceTypeBinding sourceTypeBinding = currentScope.classScope().referenceContext.binding;
                this.synthetic = sourceTypeBinding.addSyntheticMethodForSwitchEnum(resolvedTypeBinding, this);
            }
            if (this.defaultCase == null && this.needToCheckFlowInAbsenceOfDefaultBranch()) {
                flowInfo.addPotentialInitializationsFrom(caseInits.mergedWith(switchContext.initsOnBreak));
                this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
                FlowInfo flowInfo2 = flowInfo;
                return flowInfo2;
            }
            UnconditionalFlowInfo mergedInfo = caseInits.mergedWith(switchContext.initsOnBreak);
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
            UnconditionalFlowInfo unconditionalFlowInfo = mergedInfo;
            return unconditionalFlowInfo;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    public void generateCodeForStringSwitch(BlockScope currentScope, CodeStream codeStream) {
        try {
            int pc = codeStream.position;
            boolean hasCases = this.caseCount > 1 || this.caseCount == 1 && this.defaultCase == null;
            int constSize = hasCases ? this.labelExpressions.length : 0;
            BranchLabel[] sourceCaseLabels = this.gatherLabels(codeStream, new BranchLabel[this.nConstants], BranchLabel::new);
            class StringSwitchCase
            implements Comparable {
                int hashCode;
                String string;
                BranchLabel label;

                public StringSwitchCase(int hashCode, String string, BranchLabel label) {
                    this.hashCode = hashCode;
                    this.string = string;
                    this.label = label;
                }

                public int compareTo(Object o) {
                    StringSwitchCase that = (StringSwitchCase)o;
                    if (this.hashCode == that.hashCode) {
                        return 0;
                    }
                    if (this.hashCode > that.hashCode) {
                        return 1;
                    }
                    return -1;
                }

                public String toString() {
                    return "StringSwitchCase :\ncase " + this.hashCode + ":(" + this.string + ")\n";
                }
            }
            Object[] stringCases = new StringSwitchCase[constSize];
            CaseLabel[] hashCodeCaseLabels = new CaseLabel[constSize];
            int[] hashCodes = new int[constSize];
            int i = 0;
            while (i < constSize) {
                String literal = this.labelExpressions[i].constant.stringValue();
                stringCases[i] = new StringSwitchCase(literal.hashCode(), literal, sourceCaseLabels[i]);
                hashCodeCaseLabels[i] = new CaseLabel(codeStream);
                hashCodeCaseLabels[i].tagBits |= 2;
                ++i;
            }
            Arrays.sort(stringCases);
            int uniqHashCount = 0;
            int lastHashCode = 0;
            int i2 = 0;
            int length = constSize;
            while (i2 < length) {
                int hashCode = ((StringSwitchCase)stringCases[i2]).hashCode;
                if (i2 == 0 || hashCode != lastHashCode) {
                    int n = uniqHashCount++;
                    int n2 = hashCode;
                    hashCodes[n] = n2;
                    lastHashCode = n2;
                }
                ++i2;
            }
            if (uniqHashCount != constSize) {
                int[] nArray = hashCodes;
                hashCodes = new int[uniqHashCount];
                System.arraycopy(nArray, 0, hashCodes, 0, uniqHashCount);
                CaseLabel[] caseLabelArray = hashCodeCaseLabels;
                hashCodeCaseLabels = new CaseLabel[uniqHashCount];
                System.arraycopy(caseLabelArray, 0, hashCodeCaseLabels, 0, uniqHashCount);
            }
            int[] sortedIndexes = new int[uniqHashCount];
            int i3 = 0;
            while (i3 < uniqHashCount) {
                sortedIndexes[i3] = i3;
                ++i3;
            }
            CaseLabel defaultCaseLabel = new CaseLabel(codeStream);
            defaultCaseLabel.tagBits |= 2;
            this.breakLabel.initialize(codeStream);
            BranchLabel defaultBranchLabel = new BranchLabel(codeStream);
            if (hasCases) {
                defaultBranchLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = defaultBranchLabel;
            }
            this.expression.generateCode(currentScope, codeStream, true);
            codeStream.store(this.selector, true);
            codeStream.addVariable(this.selector);
            codeStream.invokeStringHashCode();
            if (hasCases) {
                codeStream.lookupswitch(defaultCaseLabel, hashCodes, sortedIndexes, hashCodeCaseLabels);
                int i4 = 0;
                int j = 0;
                int max = constSize;
                while (i4 < max) {
                    int hashCode = ((StringSwitchCase)stringCases[i4]).hashCode;
                    if (i4 == 0 || hashCode != lastHashCode) {
                        lastHashCode = hashCode;
                        if (i4 != 0) {
                            codeStream.goto_(defaultBranchLabel);
                        }
                        hashCodeCaseLabels[j++].place();
                    }
                    codeStream.load(this.selector);
                    codeStream.ldc(((StringSwitchCase)stringCases[i4]).string);
                    codeStream.invokeStringEquals();
                    codeStream.ifne(((StringSwitchCase)stringCases[i4]).label);
                    ++i4;
                }
                codeStream.goto_(defaultBranchLabel);
            } else {
                codeStream.pop();
            }
            if (this.statements != null) {
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                int n3 = 0;
                while (n3 < n) {
                    Statement statement = statementArray[n3];
                    if (statement instanceof CaseStatement) {
                        CaseStatement caseStatement;
                        this.scope.enclosingCase = caseStatement = (CaseStatement)statement;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                        if (statement == this.defaultCase) {
                            defaultCaseLabel.place();
                        }
                    }
                    statement.generateCode(this.scope, codeStream);
                    if ((this.switchBits & 1) != 0 && statement instanceof Block && statement.canCompleteNormally()) {
                        codeStream.goto_(this.breakLabel);
                    }
                    ++n3;
                }
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            codeStream.removeVariable(this.selector);
            if (this.scope != currentScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null) {
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd, true);
                defaultCaseLabel.place();
                defaultBranchLabel.place();
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private <T extends BranchLabel> T[] gatherLabels(CodeStream codeStream, T[] caseLabels, Function<CodeStream, T> newLabel) {
        int i = 0;
        int j = 0;
        int max = this.caseCount;
        while (i < max) {
            CaseStatement stmt = this.cases[i];
            Expression[] peeledLabelExpressions = stmt.peeledLabelExpressions();
            int length = peeledLabelExpressions.length;
            BranchLabel[] targetLabels = new BranchLabel[length];
            int count = 0;
            int k = 0;
            while (k < length) {
                Expression e = peeledLabelExpressions[k];
                if (!(e instanceof FakeDefaultLiteral)) {
                    int n = count++;
                    caseLabels[j] = (BranchLabel)newLabel.apply(codeStream);
                    targetLabels[n] = caseLabels[j];
                    if (e == this.totalPattern) {
                        this.defaultCase = stmt;
                    }
                    ((BranchLabel)caseLabels[j++]).tagBits |= 2;
                }
                ++k;
            }
            stmt.targetLabels = new BranchLabel[count];
            System.arraycopy(targetLabels, 0, stmt.targetLabels, 0, count);
            ++i;
        }
        return caseLabels;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.expression.resolvedType.id == 11 && !this.isNonTraditional) {
            this.generateCodeForStringSwitch(currentScope, codeStream);
            return;
        }
        try {
            boolean hasCases;
            int pc = codeStream.position;
            this.breakLabel.initialize(codeStream);
            CaseLabel[] caseLabels = (CaseLabel[])this.gatherLabels(codeStream, new CaseLabel[this.nConstants], CaseLabel::new);
            CaseLabel defaultLabel = new CaseLabel(codeStream);
            boolean bl = hasCases = this.caseCount > 1 || this.caseCount == 1 && this.defaultCase == null;
            if (hasCases) {
                defaultLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = defaultLabel;
            }
            TypeBinding resolvedType1 = this.expression.resolvedType;
            boolean valueRequired = false;
            int constantCount = this.labelExpressions.length;
            int[] constants = new int[constantCount];
            if (this.needPatternDispatchCopy()) {
                this.generateCodeSwitchPatternPrologue(currentScope, codeStream);
                valueRequired = true;
                i = 0;
                int j = 0;
                int length = this.labelExpressions.length;
                while (i < length) {
                    if (this.nullCase == null && this.labelExpressions[i].expression == this.totalPattern) {
                        this.labelExpressions[i].index = -1;
                    }
                    constants[i] = this.labelExpressions[i].index - j;
                    if (this.labelExpressions[i].expression instanceof NullLiteral) {
                        j = 1;
                    }
                    ++i;
                }
            } else {
                i = 0;
                int length = this.labelExpressions.length;
                while (i < length) {
                    constants[i] = this.labelExpressions[i].intValue();
                    ++i;
                }
                if (resolvedType1.isEnum()) {
                    codeStream.invoke((byte)-72, this.synthetic, null);
                    this.expression.generateCode(currentScope, codeStream, true);
                    codeStream.invokeEnumOrdinal(resolvedType1.constantPoolName());
                    codeStream.iaload();
                    if (!hasCases) {
                        codeStream.pop();
                    }
                    valueRequired = hasCases;
                } else {
                    valueRequired = this.expression.constant == Constant.NotAConstant || hasCases;
                    this.expression.generateCode(currentScope, codeStream, valueRequired);
                    if (resolvedType1.id == 33) {
                        codeStream.generateUnboxingConversion(5);
                    }
                }
            }
            if (hasCases) {
                int[] sortedIndexes = new int[constantCount];
                int i = 0;
                while (i < constantCount) {
                    sortedIndexes[i] = i;
                    ++i;
                }
                int[] localKeysCopy = new int[constantCount];
                System.arraycopy(constants, 0, localKeysCopy, 0, constantCount);
                CodeStream.sort(localKeysCopy, 0, constantCount - 1, sortedIndexes);
                int max = localKeysCopy[constantCount - 1];
                int min = localKeysCopy[0];
                if ((long)((double)constantCount * 2.5) > (long)max - (long)min) {
                    codeStream.tableswitch(defaultLabel, min, max, constants, sortedIndexes, caseLabels);
                } else {
                    codeStream.lookupswitch(defaultLabel, constants, sortedIndexes, caseLabels);
                }
                codeStream.recordPositionsFrom(codeStream.position, this.expression.sourceEnd);
            } else if (valueRequired) {
                codeStream.pop();
            }
            if (this.statements != null) {
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Statement statement = statementArray[n2];
                    if (statement instanceof CaseStatement) {
                        CaseStatement caseStatement;
                        this.scope.enclosingCase = caseStatement = (CaseStatement)statement;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                    }
                    statement.generateCode(this.scope, codeStream);
                    if ((this.switchBits & 1) != 0 && statement instanceof Block && statement.canCompleteNormally()) {
                        codeStream.goto_(this.breakLabel);
                    }
                    ++n2;
                }
            }
            boolean needsThrowingDefault = false;
            if (this.defaultCase == null) {
                needsThrowingDefault = resolvedType1.isEnum() && (this instanceof SwitchExpression || this.containsNull);
                needsThrowingDefault |= this.isExhaustive();
            }
            if (needsThrowingDefault) {
                if (this.preSwitchInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                }
                if (this.scope.compilerOptions().complianceLevel >= 0x3F0000L) {
                    if (this.statements.length > 0 && this.statements[this.statements.length - 1].canCompleteNormally()) {
                        codeStream.goto_(this.breakLabel);
                    }
                    defaultLabel.place();
                    codeStream.newJavaLangMatchException();
                    codeStream.dup();
                    codeStream.aconst_null();
                    codeStream.aconst_null();
                    codeStream.invokeJavaLangMatchExceptionConstructor();
                    codeStream.athrow();
                } else {
                    defaultLabel.place();
                    codeStream.newJavaLangIncompatibleClassChangeError();
                    codeStream.dup();
                    codeStream.invokeJavaLangIncompatibleClassChangeErrorDefaultConstructor();
                    codeStream.athrow();
                }
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            this.generateCodeSwitchPatternEpilogue(codeStream);
            if (this.scope != currentScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null && !needsThrowingDefault) {
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd, true);
                defaultLabel.place();
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private void generateCodeSwitchPatternEpilogue(CodeStream codeStream) {
        if (this.needPatternDispatchCopy()) {
            codeStream.removeVariable(this.selector);
        }
    }

    private void generateCodeSwitchPatternPrologue(BlockScope currentScope, CodeStream codeStream) {
        this.expression.generateCode(currentScope, codeStream, true);
        if (!this.containsNull && !this.expression.resolvedType.isPrimitiveType()) {
            codeStream.dup();
            codeStream.invokeJavaUtilObjectsrequireNonNull();
            codeStream.pop();
        }
        codeStream.store(this.selector, false);
        codeStream.addVariable(this.selector);
        int invokeDynamicNumber = codeStream.classFile.recordBootstrapMethod(this);
        codeStream.load(this.selector);
        codeStream.loadInt(0);
        this.switchPatternRestartTarget = new BranchLabel(codeStream);
        this.switchPatternRestartTarget.place();
        if (this.expression.resolvedType.isEnum()) {
            this.generateEnumSwitchPatternPrologue(codeStream, invokeDynamicNumber);
        } else {
            this.generateTypeSwitchPatternPrologue(codeStream, invokeDynamicNumber);
        }
        boolean hasQualifiedEnums = (this.switchBits & 8) != 0;
        int i = 0;
        while (i < this.labelExpressions.length) {
            CaseStatement.LabelExpression c = this.labelExpressions[i];
            if (hasQualifiedEnums) {
                c.index = i;
            }
            if (c.type.isPrimitiveType()) {
                SingletonBootstrap descriptor;
                SingletonBootstrap singletonBootstrap = c.isPattern() ? PRIMITIVE_CLASS__BOOTSTRAP : (descriptor = c.type.id == 5 ? GET_STATIC_FINAL__BOOTSTRAP : null);
                if (descriptor != null) {
                    c.primitivesBootstrapIdx = codeStream.classFile.recordSingletonBootstrapMethod(descriptor);
                }
            } else if (c.isQualifiedEnum()) {
                c.enumDescIdx = codeStream.classFile.recordBootstrapMethod(c);
                c.classDescIdx = codeStream.classFile.recordBootstrapMethod(c.type);
            }
            ++i;
        }
    }

    private void generateTypeSwitchPatternPrologue(CodeStream codeStream, int invokeDynamicNumber) {
        TypeBinding exprType = this.expression.resolvedType;
        char[] signature = this.typeSwitchSignature(exprType);
        int argsSize = TypeIds.getCategory(exprType.id) + 1;
        codeStream.invokeDynamic(invokeDynamicNumber, argsSize, 1, ConstantPool.TYPESWITCH, signature, TypeBinding.INT);
    }

    char[] typeSwitchSignature(TypeBinding exprType) {
        char[] arg1 = switch (exprType.id) {
            case 26, 27, 28, 29, 30, 31, 32, 33 -> {
                if (this.isPrimitiveSwitch) {
                    yield exprType.signature();
                }
                yield "Ljava/lang/Object;".toCharArray();
            }
            default -> exprType.id > 128 && exprType.erasure().isBoxedPrimitiveType() ? exprType.erasure().signature() : (exprType.isPrimitiveType() ? exprType.signature() : "Ljava/lang/Object;".toCharArray());
        };
        return CharOperation.concat("(".toCharArray(), arg1, "I)I".toCharArray());
    }

    private void generateEnumSwitchPatternPrologue(CodeStream codeStream, int invokeDynamicNumber) {
        String genericTypeSignature = new String(this.expression.resolvedType.genericTypeSignature());
        String callingParams = "(" + genericTypeSignature + "I)I";
        codeStream.invokeDynamic(invokeDynamicNumber, 2, 1, "enumSwitch".toCharArray(), callingParams.toCharArray(), TypeBinding.INT);
    }

    @Override
    public StringBuilder printStatement(int indent, StringBuilder output) {
        SwitchStatement.printIndent(indent, output).append("switch (");
        this.expression.printExpression(0, output).append(") {");
        if (this.statements != null) {
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                output.append('\n');
                if (statement instanceof CaseStatement) {
                    statement.printStatement(indent, output);
                } else {
                    statement.printStatement(indent + 2, output);
                }
                ++n2;
            }
        }
        output.append("\n");
        return SwitchStatement.printIndent(indent, output).append('}');
    }

    private void preprocess() {
        int n = 0;
        Statement[] statementArray = this.statements;
        int n2 = this.statements.length;
        int n3 = 0;
        while (n3 < n2) {
            Statement statement = statementArray[n3];
            if (statement instanceof CaseStatement) {
                CaseStatement caseStatement = (CaseStatement)statement;
                ++n;
                int count = 0;
                Expression[] expressionArray = caseStatement.peeledLabelExpressions();
                int n4 = expressionArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Expression e = expressionArray[n5];
                    if (!(e instanceof FakeDefaultLiteral)) {
                        ++count;
                    }
                    ++n5;
                }
                this.nConstants += count;
            }
            ++n3;
        }
        this.labelExpressions = new CaseStatement.LabelExpression[this.nConstants];
        this.cases = new CaseStatement[n];
    }

    boolean isAllowedType(TypeBinding type) {
        if (type == null) {
            return false;
        }
        switch (type.id) {
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    private boolean duplicateConstant(CaseStatement.LabelExpression current, CaseStatement.LabelExpression prior) {
        if (current.expression instanceof Pattern || prior.expression instanceof Pattern) {
            return false;
        }
        if (current.expression instanceof NullLiteral ^ prior.expression instanceof NullLiteral) {
            return false;
        }
        if (current.constant.equals(prior.constant)) {
            return true;
        }
        if (current.type.id == 5) {
            this.switchBits |= 4;
        }
        return false;
    }

    void gatherLabelExpression(CaseStatement.LabelExpression labelExpression) {
        if (labelExpression.expression instanceof Pattern) {
            Pattern pattern = (Pattern)labelExpression.expression;
            if (this.defaultCase != null) {
                this.scope.problemReporter().patternDominatedByAnother(pattern);
            } else {
                int i = 0;
                while (i < this.labelExpressionIndex) {
                    Pattern priorPattern;
                    Expression expression = this.labelExpressions[i].expression;
                    if (expression instanceof Pattern && (priorPattern = (Pattern)expression).dominates(pattern)) {
                        this.scope.problemReporter().patternDominatedByAnother(pattern);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            if (labelExpression.expression instanceof NullLiteral) {
                if (this.defaultCase != null) {
                    this.scope.problemReporter().patternDominatedByAnother(labelExpression.expression);
                }
            } else {
                TypeBinding boxedType = labelExpression.type.isBaseType() ? this.scope.environment().computeBoxingType(labelExpression.type) : labelExpression.type;
                int i = 0;
                while (i < this.labelExpressionIndex) {
                    Pattern priorPattern;
                    Expression expression = this.labelExpressions[i].expression;
                    if (expression instanceof Pattern && (priorPattern = (Pattern)expression).coversType(boxedType, this.scope)) {
                        this.scope.problemReporter().patternDominatedByAnother(labelExpression.expression);
                        break;
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < this.labelExpressionIndex) {
                if (this.duplicateConstant(labelExpression, this.labelExpressions[i])) {
                    this.scope.problemReporter().duplicateCase(labelExpression.expression);
                    break;
                }
                ++i;
            }
        }
        this.labelExpressions[this.labelExpressionIndex++] = labelExpression;
    }

    @Override
    public void resolve(BlockScope upperScope) {
        try {
            CompilerOptions compilerOptions;
            TypeBinding expressionType;
            block27: {
                block28: {
                    expressionType = this.expression.resolveType(upperScope);
                    if (expressionType != null && !expressionType.isValidBinding()) {
                        expressionType = null;
                    }
                    compilerOptions = upperScope.compilerOptions();
                    if (expressionType == null) break block27;
                    this.expression.computeConversion(upperScope, expressionType, expressionType);
                    if (!expressionType.isBaseType()) break block28;
                    if (JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(compilerOptions)) {
                        this.isPrimitiveSwitch = true;
                    }
                    if (this.expression.isConstantValueOfTypeAssignableToType(expressionType, TypeBinding.INT) || expressionType.isCompatibleWith(TypeBinding.INT)) break block27;
                }
                if (expressionType.id != 11 && !expressionType.isEnum() && !upperScope.isBoxingCompatibleWith(expressionType, TypeBinding.INT)) {
                    if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) && (!expressionType.isBaseType() || expressionType.id == 12 || expressionType.id == 6)) {
                        this.isNonTraditional = true;
                    } else if (!this.isPrimitiveSwitch) {
                        upperScope.problemReporter().incorrectSwitchType(this.expression, expressionType);
                        expressionType = null;
                    }
                }
            }
            this.scope = new BlockScope(upperScope);
            if (expressionType != null) {
                this.reserveSecretVariablesSlot();
            } else {
                this.switchBits |= 2;
            }
            if (this.statements != null) {
                this.preprocess();
                LocalVariableBinding[] patternVariables = NO_VARIABLES;
                Statement[] statementArray = this.statements;
                int n = this.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Statement statement = statementArray[n2];
                    if (statement instanceof CaseStatement) {
                        CaseStatement caseStatement = (CaseStatement)statement;
                        caseStatement.swich = this;
                        caseStatement.resolve(this.scope);
                        patternVariables = caseStatement.bindingsWhenTrue();
                    } else {
                        statement.resolveWithBindings(patternVariables, this.scope);
                        patternVariables = LocalVariableBinding.merge(patternVariables, statement.bindingsWhenComplete());
                    }
                    ++n2;
                }
                if (expressionType != null && (expressionType.id == 5 || expressionType.id == 33) && this.defaultCase != null && this.isExhaustive()) {
                    upperScope.problemReporter().caseDefaultPlusTrueAndFalse(this);
                }
                if (this.labelExpressions.length != this.labelExpressionIndex) {
                    this.labelExpressions = new CaseStatement.LabelExpression[this.labelExpressionIndex];
                    System.arraycopy(this.labelExpressions, 0, this.labelExpressions, 0, this.labelExpressionIndex);
                }
            } else if ((this.bits & 8) != 0) {
                upperScope.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
            }
            if (expressionType != null) {
                if (!expressionType.isBaseType() && upperScope.isBoxingCompatibleWith(expressionType, TypeBinding.INT) && !this.containsPatterns && !this.containsNull) {
                    this.expression.computeConversion(upperScope, TypeBinding.INT, expressionType);
                }
                this.releaseUnusedSecretVariable();
                this.complainIfNotExhaustiveSwitch(upperScope, expressionType, compilerOptions);
            }
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private void complainIfNotExhaustiveSwitch(BlockScope upperScope, TypeBinding selectorType, CompilerOptions compilerOptions) {
        boolean isEnhanced = this.isEnhancedSwitch(upperScope, selectorType);
        if (selectorType != null && selectorType.isEnum()) {
            Set<FieldBinding> unenumeratedConstants;
            int constantCount;
            if (isEnhanced) {
                this.switchBits |= 4;
            }
            if (this.defaultCase != null && !compilerOptions.reportMissingEnumCaseDespiteDefault) {
                return;
            }
            int casesCount = this.caseCount;
            if (this.defaultCase != null && this.defaultCase.constantExpressions == NO_EXPRESSIONS) {
                --casesCount;
            }
            int n = constantCount = this.labelExpressions == null ? 0 : this.labelExpressions.length;
            if (this.totalPattern == null && (this.containsPatterns || this.containsNull || constantCount >= casesCount && constantCount != ((ReferenceBinding)selectorType).enumConstantCount()) && (unenumeratedConstants = this.unenumeratedConstants((ReferenceBinding)selectorType, constantCount)).size() != 0) {
                this.switchBits &= 0xFFFFFFFB;
                if (this.defaultCase == null || (this.defaultCase.bits & 0x40000000) == 0) {
                    if (isEnhanced) {
                        upperScope.problemReporter().enhancedSwitchMissingDefaultCase(this.expression);
                    } else {
                        for (FieldBinding enumConstant : unenumeratedConstants) {
                            this.reportMissingEnumConstantCase(upperScope, enumConstant);
                        }
                    }
                }
            }
            if (this.defaultCase == null) {
                if (this instanceof SwitchExpression || compilerOptions.getSeverity(0x40008000) == 256) {
                    upperScope.methodScope().hasMissingSwitchDefault = true;
                } else {
                    upperScope.problemReporter().missingDefaultCase(this, true, selectorType);
                }
            }
            return;
        }
        if (this.isExhaustive() || this.defaultCase != null || selectorType == null) {
            if (isEnhanced) {
                this.switchBits |= 4;
            }
            return;
        }
        if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) && selectorType.isSealed() && this.caseElementsCoverSealedType((ReferenceBinding)selectorType, this.caseLabelElementTypes)) {
            this.switchBits |= 4;
            return;
        }
        if (selectorType.isRecordWithComponents() && this.containsRecordPatterns && this.caseElementsCoverRecordType(upperScope, compilerOptions, (ReferenceBinding)selectorType)) {
            this.switchBits |= 4;
            return;
        }
        if (!this.isExhaustive()) {
            if (isEnhanced) {
                upperScope.problemReporter().enhancedSwitchMissingDefaultCase(this.expression);
            } else {
                upperScope.problemReporter().missingDefaultCase(this, false, selectorType);
            }
        }
    }

    private Set<FieldBinding> unenumeratedConstants(ReferenceBinding enumType, int constantCount) {
        FieldBinding[] enumFields = ((ReferenceBinding)enumType.erasure()).fields();
        HashSet<FieldBinding> unenumerated = new HashSet<FieldBinding>(Arrays.asList(enumFields));
        int i = 0;
        int max = enumFields.length;
        while (i < max) {
            FieldBinding enumConstant = enumFields[i];
            if ((enumConstant.modifiers & 0x4000) == 0) {
                unenumerated.remove(enumConstant);
            } else {
                int j = 0;
                while (j < constantCount) {
                    Expression expression;
                    if (TypeBinding.equalsEquals(this.labelExpressions[j].expression.resolvedType, enumType) && (expression = this.labelExpressions[j].expression) instanceof NameReference) {
                        NameReference reference = (NameReference)expression;
                        FieldBinding field = reference.fieldBinding();
                        int intValue = field.original().id + 1;
                        if (enumConstant.id + 1 == intValue) {
                            unenumerated.remove(enumConstant);
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return unenumerated;
    }

    private boolean isExhaustive() {
        return (this.switchBits & 4) != 0;
    }

    private boolean isEnhancedSwitch(BlockScope upperScope, TypeBinding expressionType) {
        if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(upperScope.compilerOptions()) && expressionType != null && !(this instanceof SwitchExpression)) {
            boolean acceptableType = !expressionType.isEnum();
            switch (expressionType.id) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    acceptableType = false;
                }
            }
            if (acceptableType || this.containsPatterns || this.containsNull) {
                return true;
            }
        }
        if (expressionType != null && !(this instanceof SwitchExpression) && JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(upperScope.compilerOptions())) {
            switch (expressionType.id) {
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean caseElementsCoverRecordType(BlockScope skope, CompilerOptions compilerOptions, ReferenceBinding recordType) {
        RNode head = new RNode(recordType);
        for (Pattern pattern : this.caseLabelElements) {
            head.addPattern(pattern);
        }
        CoverageCheckerVisitor ccv = new CoverageCheckerVisitor();
        head.traverse(ccv);
        return ccv.covers;
    }

    private boolean caseElementsCoverSealedType(ReferenceBinding sealedType, List<TypeBinding> listedTypes) {
        List<ReferenceBinding> allAllowedTypes = sealedType.getAllEnumerableAvatars();
        Iterator<ReferenceBinding> iterator = allAllowedTypes.iterator();
        block0: while (iterator.hasNext()) {
            int constantCount;
            Set<FieldBinding> unenumeratedConstants;
            ReferenceBinding next = iterator.next();
            if (next.isAbstract() && next.isSealed()) {
                iterator.remove();
                continue;
            }
            if (next.isEnum() && (unenumeratedConstants = this.unenumeratedConstants(next, constantCount = this.labelExpressions == null ? 0 : this.labelExpressions.length)).size() == 0) {
                iterator.remove();
                continue;
            }
            for (TypeBinding type : listedTypes) {
                if (!next.erasure().isCompatibleWith(type.erasure())) continue;
                iterator.remove();
                continue block0;
            }
        }
        return allAllowedTypes.size() == 0;
    }

    private boolean needPatternDispatchCopy() {
        if (this.containsPatterns || this.containsNull || (this.switchBits & 8) != 0) {
            return true;
        }
        TypeBinding eType = this.expression.resolvedType;
        if (eType == null) {
            return false;
        }
        switch (eType.id) {
            case 30: 
            case 31: 
            case 32: {
                return true;
            }
            case 7: 
            case 8: 
            case 9: {
                if (!this.isPrimitiveSwitch) break;
                return true;
            }
        }
        return !eType.isPrimitiveOrBoxedPrimitiveType() && !eType.isEnum() && eType.id != 11;
    }

    private void reserveSecretVariablesSlot() {
        this.selector = new LocalVariableBinding(SecretSelectorVariableName, (TypeBinding)this.scope.getJavaLangObject(), 0, false);
        this.scope.addLocalVariable(this.selector);
        this.selector.setConstant(Constant.NotAConstant);
    }

    private void releaseUnusedSecretVariable() {
        if (this.selector != null) {
            if (this.expression.resolvedType.id == 11 && !this.isNonTraditional) {
                this.selector.useFlag = 1;
                this.selector.type = this.scope.getJavaLangString();
            } else if (this.needPatternDispatchCopy()) {
                this.selector.useFlag = 1;
                this.selector.type = this.expression.resolvedType;
            }
        }
    }

    protected void reportMissingEnumConstantCase(BlockScope upperScope, FieldBinding enumConstant) {
        upperScope.problemReporter().missingEnumConstantCase(this, enumConstant);
    }

    @Override
    public boolean isTrulyExpression() {
        return false;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, blockScope);
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public void branchChainTo(BranchLabel label) {
        if (this.breakLabel.forwardReferenceCount() > 0) {
            label.becomeDelegateFor(this.breakLabel);
        }
    }

    @Override
    public boolean doesNotCompleteNormally() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        Statement[] statementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement.breaksOut(null)) {
                return false;
            }
            ++n2;
        }
        return this.statements[this.statements.length - 1].doesNotCompleteNormally();
    }

    @Override
    public boolean completesByContinue() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        Statement[] statementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement.completesByContinue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.statements == null || this.statements.length == 0) {
            return true;
        }
        if ((this.switchBits & 1) == 0) {
            if (this.statements[this.statements.length - 1].canCompleteNormally()) {
                return true;
            }
            if (this.totalPattern == null && this.defaultCase == null) {
                return true;
            }
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                if (statement.breaksOut(null)) {
                    return true;
                }
                ++n2;
            }
        } else {
            Statement[] statementArray = this.statements;
            int n = this.statements.length;
            int n3 = 0;
            while (n3 < n) {
                Statement stmt = statementArray[n3];
                if (!(stmt instanceof CaseStatement)) {
                    if (this.totalPattern == null && this.defaultCase == null) {
                        return true;
                    }
                    if (stmt instanceof Expression) {
                        return true;
                    }
                    if (stmt.canCompleteNormally()) {
                        return true;
                    }
                    if (stmt instanceof YieldStatement && ((YieldStatement)stmt).isImplicit) {
                        return true;
                    }
                    if (stmt instanceof Block) {
                        Block block = (Block)stmt;
                        if (block.canCompleteNormally()) {
                            return true;
                        }
                        if (block.breaksOut(null)) {
                            return true;
                        }
                    }
                }
                ++n3;
            }
        }
        return false;
    }

    @Override
    public boolean continueCompletes() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        Statement[] statementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            if (statement.continueCompletes()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        return this.printStatement(indent, output);
    }

    class CoverageCheckerVisitor
    extends NodeVisitor {
        public boolean covers;

        CoverageCheckerVisitor() {
            this.covers = true;
        }

        @Override
        public boolean visit(TNode node) {
            ReferenceBinding referenceBinding;
            if (node.hasError) {
                return false;
            }
            ArrayList<TypeBinding> availableTypes = new ArrayList<TypeBinding>();
            if (node.children != null) {
                for (Node node2 : node.children) {
                    if (node.type.isSubtypeOf(node2.type, false)) {
                        this.covers = true;
                    }
                    node2.traverse(this);
                    if (node.type.isSubtypeOf(node2.type, false) && this.covers) {
                        return false;
                    }
                    availableTypes.add(node2.type);
                }
            }
            if (node.type instanceof ReferenceBinding && (referenceBinding = (ReferenceBinding)node.type).isSealed()) {
                this.covers &= SwitchStatement.this.caseElementsCoverSealedType(referenceBinding, availableTypes);
                return this.covers;
            }
            this.covers = false;
            return false;
        }
    }

    class Node {
        TypeBinding type;
        boolean hasError = false;

        Node() {
        }

        public void traverse(NodeVisitor visitor) {
            visitor.visit(this);
            visitor.endVisit(this);
        }
    }

    abstract class NodeVisitor {
        NodeVisitor() {
        }

        public void endVisit(Node node) {
        }

        public void endVisit(PatternNode node) {
        }

        public void endVisit(RecordPatternNode node) {
        }

        public void endVisit(RNode node) {
        }

        public void endVisit(TNode node) {
        }

        public boolean visit(Node node) {
            return true;
        }

        public boolean visit(PatternNode node) {
            return true;
        }

        public boolean visit(RecordPatternNode node) {
            return true;
        }

        public boolean visit(RNode node) {
            return true;
        }

        public boolean visit(TNode node) {
            return true;
        }
    }

    class PatternNode
    extends Node {
        TNode next;

        PatternNode(TypeBinding type) {
            this.type = type;
        }

        public void addPattern(RecordPattern rp, int i) {
            TypeBinding ref = SwitchStatement.this.expression.resolvedType;
            if (!(ref instanceof ReferenceBinding)) {
                return;
            }
            RecordComponentBinding[] comps = ref.components();
            if (comps == null || comps.length <= i) {
                return;
            }
            if (this.next == null) {
                this.next = new TNode(comps[i].type);
            }
            this.next.addPattern(rp, i);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[Pattern node] {\n");
            sb.append("    type:");
            sb.append(this.type != null ? this.type.toString() : "null");
            sb.append("    next:");
            sb.append(this.next != null ? this.next.toString() : "null");
            sb.append("\n}\n");
            return sb.toString();
        }

        @Override
        public void traverse(NodeVisitor visitor) {
            if (visitor.visit(this) && this.next != null) {
                visitor.visit(this.next);
            }
            visitor.endVisit(this);
        }
    }

    class RNode
    extends Node {
        TNode firstComponent;

        RNode(TypeBinding rec) {
            RecordComponentBinding comp;
            int len;
            this.type = rec;
            RecordComponentBinding[] comps = rec.components();
            int n = len = comps != null ? comps.length : 0;
            if (len > 0 && (comp = comps[0]) != null && comp.type != null) {
                this.firstComponent = new TNode(comp.type);
            }
        }

        void addPattern(Pattern p) {
            if (p instanceof RecordPattern) {
                this.addPattern((RecordPattern)p);
            }
        }

        void addPattern(RecordPattern rp) {
            if (!TypeBinding.equalsEquals(this.type, rp.type.resolvedType)) {
                return;
            }
            if (this.firstComponent == null) {
                return;
            }
            this.firstComponent.addPattern(rp, 0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[RNode] {\n");
            sb.append("    type:");
            sb.append(this.type != null ? this.type.toString() : "null");
            sb.append("    firstComponent:");
            sb.append(this.firstComponent != null ? this.firstComponent.toString() : "null");
            sb.append("\n}\n");
            return sb.toString();
        }

        @Override
        public void traverse(NodeVisitor visitor) {
            if (this.firstComponent != null) {
                visitor.visit(this.firstComponent);
            }
            visitor.endVisit(this);
        }
    }

    class RecordPatternNode
    extends PatternNode {
        RNode rNode;

        RecordPatternNode(TypeBinding type) {
            super(type);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[RecordPattern node] {\n");
            sb.append("    type:");
            sb.append(this.type != null ? this.type.toString() : "null");
            sb.append("    next:");
            sb.append(this.next != null ? this.next.toString() : "null");
            sb.append("    rNode:");
            sb.append(this.rNode != null ? this.rNode.toString() : "null");
            sb.append("\n}\n");
            return sb.toString();
        }

        @Override
        public void traverse(NodeVisitor visitor) {
            if (visitor.visit(this) && visitor.visit(this.rNode) && this.next != null) {
                visitor.visit(this.next);
            }
            visitor.endVisit(this);
        }
    }

    public record SingletonBootstrap(String id, char[] selector, char[] signature) {
    }

    class TNode
    extends Node {
        List<PatternNode> children;

        TNode(TypeBinding type) {
            this.type = type;
            this.children = new ArrayList<PatternNode>();
        }

        public void addPattern(RecordPattern rp, int i) {
            if (rp.patterns.length <= i) {
                this.hasError = true;
                return;
            }
            TypeBinding childType = rp.patterns[i].resolvedType;
            PatternNode child = null;
            for (PatternNode c : this.children) {
                if (!TypeBinding.equalsEquals(childType, c.type)) continue;
                child = c;
                break;
            }
            if (child == null) {
                PatternNode patternNode = child = childType.isRecord() ? new RecordPatternNode(childType) : new PatternNode(childType);
                if (this.type.isSubtypeOf(childType, false)) {
                    this.children.add(0, child);
                } else {
                    this.children.add(child);
                }
            }
            if (i + 1 < rp.patterns.length) {
                child.addPattern(rp, i + 1);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[TNode] {\n");
            sb.append("    type:");
            sb.append(this.type != null ? this.type.toString() : "null");
            sb.append("    children:");
            if (this.children == null) {
                sb.append("null");
            } else {
                for (Node node : this.children) {
                    sb.append(node.toString());
                }
            }
            sb.append("\n}\n");
            return sb.toString();
        }

        @Override
        public void traverse(NodeVisitor visitor) {
            if (visitor.visit(this) && this.children != null) {
                for (PatternNode child : this.children) {
                    if (!visitor.visit(child)) break;
                }
            }
            visitor.endVisit(this);
        }
    }
}

