/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.MethodNameMatch;
import org.eclipse.jdt.core.search.MethodNameMatchRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.WorkspaceSymbolParams;

public class WorkspaceSymbolHandler {
    public static List<SymbolInformation> search(String query, IProgressMonitor monitor) {
        return WorkspaceSymbolHandler.search(query, 0, null, false, monitor);
    }

    public static List<SymbolInformation> search(String query, String projectName, boolean sourceOnly, IProgressMonitor monitor) {
        return WorkspaceSymbolHandler.search(query, 0, projectName, sourceOnly, monitor);
    }

    public static List<SymbolInformation> search(String query, int maxResults, String projectName, boolean sourceOnly, IProgressMonitor monitor) {
        HashSet<SymbolInformation> symbols;
        block12: {
            symbols = new HashSet<SymbolInformation>();
            if (StringUtils.isBlank((CharSequence)query)) {
                return new ArrayList<SymbolInformation>(symbols);
            }
            try {
                try {
                    monitor.beginTask("Searching the types...", 100);
                    IJavaSearchScope searchScope = WorkspaceSymbolHandler.createSearchScope(projectName, sourceOnly);
                    String tQuery = query.trim();
                    String qualifierName = null;
                    String typeName = tQuery;
                    int qualifierMatchRule = 2;
                    int qualIndex = tQuery.lastIndexOf(46);
                    if (qualIndex != -1) {
                        qualifierName = tQuery.substring(0, qualIndex);
                        typeName = tQuery.substring(qualIndex + 1);
                        if (!qualifierName.contains("*") && !qualifierName.contains("?")) {
                            qualifierName = String.format("*%s*", qualifierName);
                        }
                    }
                    int typeMatchRule = 128;
                    if (typeName.contains("*") || typeName.contains("?")) {
                        typeMatchRule = 2;
                    }
                    PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
                    SearchEngine engine = new SearchEngine();
                    boolean isSymbolTagSupported = preferenceManager != null && preferenceManager.getClientPreferences().isSymbolTagSupported();
                    WorkspaceSymbolTypeRequestor typeRequestor = new WorkspaceSymbolTypeRequestor(symbols, maxResults, sourceOnly, isSymbolTagSupported, monitor);
                    if (!typeName.isEmpty()) {
                        engine.searchAllTypeNames(qualifierName == null ? null : qualifierName.toCharArray(), qualifierMatchRule, typeName.toCharArray(), typeMatchRule, 0, searchScope, (TypeNameMatchRequestor)typeRequestor, 3, monitor);
                    }
                    engine.searchAllTypeNames(tQuery.toCharArray(), qualifierMatchRule, null, typeMatchRule, 0, searchScope, (TypeNameMatchRequestor)typeRequestor, 3, monitor);
                    if (preferenceManager != null && preferenceManager.getPreferences().isIncludeSourceMethodDeclarations()) {
                        monitor.beginTask("Searching methods...", 100);
                        IJavaSearchScope nonSourceSearchScope = WorkspaceSymbolHandler.createSearchScope(projectName, true);
                        WorkspaceSymbolMethodRequestor methodRequestor = new WorkspaceSymbolMethodRequestor(symbols, maxResults, isSymbolTagSupported, monitor);
                        engine.searchAllMethodNames(null, 2, query.trim().toCharArray(), typeMatchRule, nonSourceSearchScope, (MethodNameMatchRequestor)methodRequestor, 3, monitor);
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof OperationCanceledException)) {
                        JavaLanguageServerPlugin.logException("Problem getting search for" + query, e);
                    }
                    monitor.done();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        return new ArrayList<SymbolInformation>(symbols);
    }

    private static IJavaSearchScope createSearchScope(String projectName, boolean sourceOnly) throws JavaModelException {
        IJavaProject project = ProjectUtils.getJavaProject(projectName);
        IJavaProject[] targetProjects = project != null ? new IJavaProject[]{project} : ProjectUtils.getJavaProjects();
        int scope = 9;
        PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (!sourceOnly && preferenceManager != null && preferenceManager.isClientSupportsClassFileContent()) {
            scope |= 6;
        }
        boolean excludeTestCode = preferenceManager.getPreferences().getSearchScope() == Preferences.SearchScope.main;
        return SearchEngine.createJavaSearchScope((boolean)excludeTestCode, (IJavaElement[])targetProjects, (int)scope);
    }

    public static class SearchSymbolParams
    extends WorkspaceSymbolParams {
        public String projectName;
        public boolean sourceOnly;
        public int maxResults;

        public SearchSymbolParams(String query, String projectName) {
            super(query);
            this.projectName = projectName;
        }
    }

    private static class WorkspaceSymbolMethodRequestor
    extends MethodNameMatchRequestor {
        private Set<SymbolInformation> symbols;
        private int maxResults;
        private boolean isSymbolTagSupported;
        private IProgressMonitor monitor;

        public WorkspaceSymbolMethodRequestor(Set<SymbolInformation> symbols, int maxResults, boolean isSymbolTagSupported, IProgressMonitor monitor) {
            this.symbols = symbols;
            this.maxResults = maxResults;
            this.isSymbolTagSupported = isSymbolTagSupported;
            this.monitor = monitor;
        }

        public void acceptMethodNameMatch(MethodNameMatch match) {
            try {
                if (this.maxResults > 0 && this.symbols.size() >= this.maxResults) {
                    this.monitor.setCanceled(true);
                    return;
                }
                Location location = null;
                try {
                    location = JDTUtils.toLocation((IJavaElement)match.getMethod());
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException("Unable to determine location for " + match.getMethod().getElementName(), e);
                    return;
                }
                if (location != null && match.getMethod().getElementName() != null && !match.getMethod().getElementName().isEmpty()) {
                    SymbolInformation symbolInformation = new SymbolInformation();
                    symbolInformation.setContainerName(match.getMethod().getDeclaringType().getFullyQualifiedName());
                    symbolInformation.setName(match.getMethod().getElementName());
                    symbolInformation.setKind(SymbolKind.Method);
                    if (Flags.isDeprecated((int)match.getMethod().getFlags())) {
                        if (this.isSymbolTagSupported) {
                            symbolInformation.setTags(List.of(SymbolTag.Deprecated));
                        } else {
                            symbolInformation.setDeprecated(Boolean.valueOf(true));
                        }
                    }
                    symbolInformation.setLocation(location);
                    this.symbols.add(symbolInformation);
                    if (this.maxResults > 0 && this.symbols.size() >= this.maxResults) {
                        this.monitor.setCanceled(true);
                    }
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException("Unable to determine location for " + match.getMethod().getElementName(), e);
                return;
            }
        }
    }

    private static class WorkspaceSymbolTypeRequestor
    extends TypeNameMatchRequestor {
        private Set<SymbolInformation> symbols;
        private int maxResults;
        private boolean sourceOnly;
        private boolean isSymbolTagSupported;
        private IProgressMonitor monitor;

        public WorkspaceSymbolTypeRequestor(Set<SymbolInformation> symbols, int maxResults, boolean sourceOnly, boolean isSymbolTagSupported, IProgressMonitor monitor) {
            this.symbols = symbols;
            this.maxResults = maxResults;
            this.sourceOnly = sourceOnly;
            this.isSymbolTagSupported = isSymbolTagSupported;
            this.monitor = monitor;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            try {
                if (this.maxResults > 0 && this.symbols.size() >= this.maxResults) {
                    this.monitor.setCanceled(true);
                    return;
                }
                Location location = null;
                try {
                    if (!this.sourceOnly && match.getType().isBinary()) {
                        location = JDTUtils.toLocation((IClassFile)match.getType().getClassFile());
                    } else if (!match.getType().isBinary()) {
                        location = JDTUtils.toLocation((IJavaElement)match.getType());
                    }
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException("Unable to determine location for " + match.getSimpleTypeName(), e);
                    return;
                }
                if (location != null && match.getSimpleTypeName() != null && !match.getSimpleTypeName().isEmpty()) {
                    SymbolInformation symbolInformation = new SymbolInformation();
                    symbolInformation.setContainerName(match.getTypeContainerName());
                    symbolInformation.setName(match.getSimpleTypeName());
                    symbolInformation.setKind(this.mapKind(match));
                    if (Flags.isDeprecated((int)match.getType().getFlags())) {
                        if (this.isSymbolTagSupported) {
                            symbolInformation.setTags(List.of(SymbolTag.Deprecated));
                        } else {
                            symbolInformation.setDeprecated(Boolean.valueOf(true));
                        }
                    }
                    symbolInformation.setLocation(location);
                    this.symbols.add(symbolInformation);
                    if (this.maxResults > 0 && this.symbols.size() >= this.maxResults) {
                        this.monitor.setCanceled(true);
                    }
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException("Unable to determine location for " + match.getSimpleTypeName(), e);
                return;
            }
        }

        private SymbolKind mapKind(TypeNameMatch match) {
            int flags = match.getModifiers();
            if (Flags.isInterface((int)flags)) {
                return SymbolKind.Interface;
            }
            if (Flags.isAnnotation((int)flags)) {
                return SymbolKind.Property;
            }
            if (Flags.isEnum((int)flags)) {
                return SymbolKind.Enum;
            }
            return SymbolKind.Class;
        }
    }
}

