/// <reference types="node" />
/// <reference types="node" />
import stream = require('stream');
import * as ee from 'events';
import { DebugProtocol } from '@vscode/debugprotocol';
export declare class ProtocolClient extends ee.EventEmitter {
    private static TWO_CRLF;
    private outputStream;
    private sequence;
    private pendingRequests;
    private rawData;
    private contentLength;
    constructor();
    protected connect(readable: stream.Readable, writable: stream.Writable): void;
    send(command: 'initialize', args: DebugProtocol.InitializeRequestArguments): Promise<DebugProtocol.InitializeResponse>;
    send(command: 'configurationDone', args: DebugProtocol.ConfigurationDoneArguments): Promise<DebugProtocol.ConfigurationDoneResponse>;
    send(command: 'launch', args: DebugProtocol.LaunchRequestArguments): Promise<DebugProtocol.LaunchResponse>;
    send(command: 'attach', args: DebugProtocol.AttachRequestArguments): Promise<DebugProtocol.AttachResponse>;
    send(command: 'restart', args: DebugProtocol.RestartArguments): Promise<DebugProtocol.RestartResponse>;
    send(command: 'disconnect', args: DebugProtocol.DisconnectArguments): Promise<DebugProtocol.DisconnectResponse>;
    send(command: 'setBreakpoints', args: DebugProtocol.SetBreakpointsArguments): Promise<DebugProtocol.SetBreakpointsResponse>;
    send(command: 'setFunctionBreakpoints', args: DebugProtocol.SetFunctionBreakpointsArguments): Promise<DebugProtocol.SetFunctionBreakpointsResponse>;
    send(command: 'setExceptionBreakpoints', args: DebugProtocol.SetExceptionBreakpointsArguments): Promise<DebugProtocol.SetExceptionBreakpointsResponse>;
    send(command: 'dataBreakpointInfo', args: DebugProtocol.DataBreakpointInfoArguments): Promise<DebugProtocol.DataBreakpointInfoResponse>;
    send(command: 'setDataBreakpoints', args: DebugProtocol.SetDataBreakpointsArguments): Promise<DebugProtocol.SetDataBreakpointsResponse>;
    send(command: 'continue', args: DebugProtocol.ContinueArguments): Promise<DebugProtocol.ContinueResponse>;
    send(command: 'next', args: DebugProtocol.NextArguments): Promise<DebugProtocol.NextResponse>;
    send(command: 'stepIn', args: DebugProtocol.StepInArguments): Promise<DebugProtocol.StepInResponse>;
    send(command: 'stepOut', args: DebugProtocol.StepOutArguments): Promise<DebugProtocol.StepOutResponse>;
    send(command: 'stepBack', args: DebugProtocol.StepBackArguments): Promise<DebugProtocol.StepBackResponse>;
    send(command: 'reverseContinue', args: DebugProtocol.ReverseContinueArguments): Promise<DebugProtocol.ReverseContinueResponse>;
    send(command: 'restartFrame', args: DebugProtocol.RestartFrameArguments): Promise<DebugProtocol.RestartFrameResponse>;
    send(command: 'goto', args: DebugProtocol.GotoArguments): Promise<DebugProtocol.GotoResponse>;
    send(command: 'pause', args: DebugProtocol.PauseArguments): Promise<DebugProtocol.PauseResponse>;
    send(command: 'stackTrace', args: DebugProtocol.StackTraceArguments): Promise<DebugProtocol.StackTraceResponse>;
    send(command: 'scopes', args: DebugProtocol.ScopesArguments): Promise<DebugProtocol.ScopesResponse>;
    send(command: 'variables', args: DebugProtocol.VariablesArguments): Promise<DebugProtocol.VariablesResponse>;
    send(command: 'setVariable', args: DebugProtocol.SetVariableArguments): Promise<DebugProtocol.SetVariableResponse>;
    send(command: 'source', args: DebugProtocol.SourceArguments): Promise<DebugProtocol.SourceResponse>;
    send(command: 'threads'): Promise<DebugProtocol.ThreadsResponse>;
    send(command: 'modules'): Promise<DebugProtocol.ModulesResponse>;
    send(command: 'evaluate', args: DebugProtocol.EvaluateArguments): Promise<DebugProtocol.EvaluateResponse>;
    send(command: 'stepInTargets', args: DebugProtocol.StepInTargetsArguments): Promise<DebugProtocol.StepInTargetsResponse>;
    send(command: 'gotoTargets', args: DebugProtocol.GotoTargetsArguments): Promise<DebugProtocol.GotoTargetsResponse>;
    send(command: 'completions', args: DebugProtocol.CompletionsArguments): Promise<DebugProtocol.CompletionsResponse>;
    send(command: 'exceptionInfo', args: DebugProtocol.ExceptionInfoArguments): Promise<DebugProtocol.ExceptionInfoResponse>;
    send(command: string, args?: any): Promise<DebugProtocol.Response>;
    private doSend;
    private handleData;
    private dispatch;
}
