"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GDBServerFileSystemProcessManager = void 0;
/*********************************************************************
 * Copyright (c) 2024 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
const child_process_1 = require("child_process");
const fs_1 = require("fs");
const path_1 = require("path");
const GDBFileSystemProcessManagerBase_1 = require("./GDBFileSystemProcessManagerBase");
const createEnvValues_1 = require("../../util/createEnvValues");
class GDBServerFileSystemProcessManager extends GDBFileSystemProcessManagerBase_1.GDBFileSystemProcessManagerBase {
    constructor() {
        super(...arguments);
        this.token = 0;
    }
    getCwd(requestArgs) {
        var _a;
        const cwd = ((_a = requestArgs.target) === null || _a === void 0 ? void 0 : _a.cwd) ||
            requestArgs.cwd ||
            (requestArgs.program && (0, fs_1.existsSync)(requestArgs.program)
                ? (0, path_1.dirname)(requestArgs.program)
                : process.cwd());
        return (0, fs_1.existsSync)(cwd) ? cwd : process.cwd();
    }
    start(requestArgs) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestArgs.target === undefined) {
                requestArgs.target = {};
            }
            const target = requestArgs.target;
            const serverExe = target.server !== undefined ? target.server : 'gdbserver';
            const serverCwd = this.getCwd(requestArgs);
            const serverParams = target.serverParameters !== undefined
                ? target.serverParameters
                : ['--once', ':0', requestArgs.program];
            // this.killGdbServer = target.automaticallyKillServer !== false;
            const gdbEnvironment = requestArgs.environment
                ? (0, createEnvValues_1.createEnvValues)(process.env, requestArgs.environment)
                : process.env;
            const serverEnvironment = target.environment
                ? (0, createEnvValues_1.createEnvValues)(gdbEnvironment, target.environment)
                : gdbEnvironment;
            this.proc = (0, child_process_1.spawn)(serverExe, serverParams, {
                cwd: serverCwd,
                env: serverEnvironment,
            });
            return this.proc;
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => {
                var _a;
                if (!this.proc || this.proc.exitCode !== null) {
                    resolve();
                }
                else {
                    this.proc.on('exit', () => {
                        resolve();
                    });
                    (_a = this.proc) === null || _a === void 0 ? void 0 : _a.kill();
                }
                setTimeout(() => {
                    reject();
                }, 1000);
            });
        });
    }
}
exports.GDBServerFileSystemProcessManager = GDBServerFileSystemProcessManager;
//# sourceMappingURL=GDBServerFileSystemProcessManager.js.map