/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramDataModel;

public class HistogramRequest
extends TmfEventRequest<ITmfEvent> {
    protected final HistogramDataModel fHistogram;

    public HistogramRequest(HistogramDataModel histogram, TmfTimeRange range, int rank, int nbEvents, int blockSize, ITmfDataRequest.ExecutionType execType) {
        super(ITmfEvent.class, range, (long)rank, nbEvents, blockSize > 0 ? blockSize : 1000, execType);
        this.fHistogram = histogram;
    }

    public void handleData(ITmfEvent event) {
        super.handleData(event);
        if (event != null) {
            long timestamp = event.getTimestamp().getValue();
            this.fHistogram.countEvent(this.getNbRead(), timestamp);
        }
    }

    public void handleCompleted() {
        this.fHistogram.complete();
        super.handleCompleted();
    }

    public void handleCancel() {
        super.handleCancel();
    }
}

