/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelRoot;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.model.UiModelRoot;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewContentProvider;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewDeleteSessionAction;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewDoubleClickListener;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewLabelProvider;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewLogReaderAction;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewRefreshAction;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewSaveDefaultSessionAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class OprofileView
extends ViewPart {
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.createTreeViewer(parent);
        this.createActionMenu();
        OprofileUiPlugin.getDefault().setOprofileView(this);
    }

    private void createTreeViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 4);
        this.viewer.setContentProvider((IContentProvider)new OprofileViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OprofileViewLabelProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new OprofileViewDoubleClickListener());
    }

    private void createActionMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new OprofileViewLogReaderAction());
        manager.add((IAction)new OprofileViewRefreshAction());
        manager.add((IAction)new OprofileViewSaveDefaultSessionAction());
        manager.add((IAction)new OprofileViewDeleteSessionAction(this.getTreeViewer()));
    }

    private TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void refreshView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.oprofile.ui.OProfileView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        IRunnableWithProgress refreshRunner = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(OprofileUiMessages.getString("view.dialog.parsing.text"), 2);
                OpModelRoot dataModelRoot = OpModelRoot.getDefault();
                dataModelRoot.refreshModel();
                monitor.worked(1);
                final UiModelRoot UiRoot = UiModelRoot.getDefault();
                UiRoot.refreshModel();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        OprofileUiPlugin.getDefault().getOprofileView().getTreeViewer().setInput((Object)UiRoot);
                    }
                });
                monitor.worked(1);
                monitor.done();
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        try {
            dialog.run(true, false, refreshRunner);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
    }
}

