/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.launching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchPlugin;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.OprofileCounter;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileView;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractOprofileLaunchConfigurationDelegate
extends ProfileLaunchConfigurationDelegate {
    protected ILaunchConfiguration config;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.config = config;
        LaunchOptions options = new LaunchOptions();
        options.loadConfiguration(config);
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        options.setBinaryImage(exePath.toOSString());
        OprofileDaemonEvent[] daemonEvents = null;
        if (!config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", false)) {
            OprofileCounter[] counters = OprofileCounter.getCounters(config);
            ArrayList<OprofileDaemonEvent> events = new ArrayList<OprofileDaemonEvent>();
            int i = 0;
            while (i < counters.length) {
                if (counters[i].getEnabled()) {
                    events.add(counters[i].getDaemonEvent());
                }
                ++i;
            }
            daemonEvents = new OprofileDaemonEvent[events.size()];
            events.toArray(daemonEvents);
        }
        if (!this.preExec(options, daemonEvents)) {
            return;
        }
        try {
            File wd = this.getWorkingDirectory(config);
            if (wd == null) {
                wd = new File(System.getProperty("user.home", "."));
            }
            String[] arguments = this.getProgramArgumentsArray(config);
            ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
            command.add(exePath.toOSString());
            command.addAll(Arrays.asList(arguments));
            String[] commandArray = command.toArray(new String[command.size()]);
            boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            Process process = this.execute(commandArray, this.getEnvironment(config), wd, usePty);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
            this.postExec(options, daemonEvents, launch, process);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract boolean preExec(LaunchOptions var1, OprofileDaemonEvent[] var2);

    protected abstract void postExec(LaunchOptions var1, OprofileDaemonEvent[] var2, ILaunch var3, Process var4);

    protected String getPluginID() {
        return OprofileLaunchPlugin.getUniqueIdentifier();
    }

    protected void refreshOprofileView() {
        OprofileView view = OprofileUiPlugin.getDefault().getOprofileView();
        if (view != null) {
            view.refreshView();
        } else {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.oprofile.ui.OProfileView");
            }
            catch (PartInitException e2) {
                e2.printStackTrace();
            }
            OprofileUiPlugin.getDefault().getOprofileView().refreshView();
        }
    }

    protected void oprofileShutdown() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().shutdownDaemon();
    }

    protected void oprofileReset() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().reset();
    }

    protected void oprofileSetupDaemon(OprofileDaemonOptions options, OprofileDaemonEvent[] events) throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().setupDaemon(options, events);
    }

    protected void oprofileStartCollection() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().startCollection();
    }

    protected void oprofileDumpSamples() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().dumpSamples();
    }

    protected boolean oprofileStatus() throws OpcontrolException {
        return OprofileCorePlugin.getDefault().getOpcontrolProvider().status();
    }

    protected IProject getProject() {
        try {
            IProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)this.config).getProject();
            return project;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

