/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.systemtap.ui.consolelog.LoggedCommand2;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpExec;
import org.eclipse.linuxtools.systemtap.ui.consolelog.actions.StopScriptAction;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ConsoleStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ErrorStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView;
import org.eclipse.linuxtools.systemtap.ui.structures.IPasswordPrompt;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;

public class ScriptConsole
extends IOConsole {
    private LoggedCommand2 cmd = null;
    private ErrorStreamDaemon errorDaemon;
    private ConsoleStreamDaemon consoleDaemon;

    public static ScriptConsole getInstance(String name) {
        ScriptConsole console = null;
        try {
            IConsole[] ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            if (ic != null) {
                StopScriptAction ssa = new StopScriptAction();
                ssa.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                int i = 0;
                while (i < ic.length) {
                    ScriptConsole activeConsole;
                    if (ic[i] instanceof ScriptConsole && (activeConsole = (ScriptConsole)ic[i]).getName().endsWith(name)) {
                        ssa.run(i);
                        activeConsole.clearConsole();
                        activeConsole.setName(name);
                        console = activeConsole;
                    }
                    ++i;
                }
            }
            if (console == null) {
                console = new ScriptConsole(name, null);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            }
        }
        catch (NullPointerException nullPointerException) {
            console = null;
        }
        return console;
    }

    private ScriptConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    protected void createConsoleDaemon() {
        this.consoleDaemon = new ConsoleStreamDaemon(this);
    }

    protected void createErrorDaemon(IErrorParser parser) {
        ErrorView errorView = null;
        try {
            IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.consolelog.views.ErrorView");
            if (ivp != null && ivp instanceof ErrorView) {
                errorView = (ErrorView)ivp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.errorDaemon = new ErrorStreamDaemon(this, errorView, parser);
    }

    public void run(String[] command, String[] envVars, IPasswordPrompt prompt, IErrorParser errorParser) {
        this.createConsoleDaemon();
        if (errorParser != null) {
            this.createErrorDaemon(errorParser);
        }
        this.cmd = new LoggedCommand2(command, envVars, prompt, 100, this.getName());
        if (this.errorDaemon != null) {
            this.cmd.addErrorStreamListener(this.errorDaemon);
        }
        this.cmd.addInputStreamListener(this.consoleDaemon);
        this.cmd.start();
        this.activate();
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
    }

    public boolean isRunning() {
        return this.cmd.isRunning();
    }

    public boolean isDisposed() {
        return this.cmd.isDisposed();
    }

    public void saveStream(File file) {
        if (this.isRunning() && !this.cmd.saveLog(file)) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("ScriptConsole.Problem"), (String)Localization.getString("ScriptConsole.ErrorSavingLog"));
        }
    }

    public LoggedCommand2 getCommand() {
        return this.cmd;
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            String[] command = new String[1];
            String moduleName = this.getName();
            if ((moduleName = moduleName.substring(0, moduleName.indexOf(46))).indexOf(45) != -1) {
                moduleName = moduleName.substring(0, moduleName.indexOf(45));
            }
            command[0] = "ps -ef | grep " + moduleName + " | grep stapio | awk '{print $2}' | xargs kill -SIGINT";
            ScpExec stop = new ScpExec(command, moduleName);
            stop.start();
            this.cmd.stop();
            this.cmd.removeErrorStreamListener(this.errorDaemon);
            this.cmd.removeInputStreamListener(this.consoleDaemon);
            this.setName(String.valueOf(Localization.getString("ScriptConsole.Terminated")) + super.getName());
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (this.cmd != null) {
                this.cmd.dispose();
            }
            this.cmd = null;
            if (this.errorDaemon != null) {
                this.errorDaemon.dispose();
            }
            this.errorDaemon = null;
            if (this.consoleDaemon != null) {
                this.consoleDaemon.dispose();
            }
            this.consoleDaemon = null;
        }
    }

    public void setName(String name) {
        try {
            super.setName(name);
            if (ConsolePlugin.getDefault() != null) {
                ConsolePlugin.getDefault().getConsoleManager().refresh((IConsole)this);
            }
        }
        catch (Exception exception) {}
    }
}

