/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.widgets;

import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.widgets.Criteria;

public class FilterCriteria {
    protected static final String ACTIVE = "active";
    protected static final String POSITIVE = "positive";
    protected static final String LOADERCLASSNAME = "loaderClassName";
    protected Criteria criteria;
    protected boolean active;
    protected boolean positive;
    protected String loaderClassName;

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(":");
        if (this.criteria != null) {
            sb.append(" expression=");
            sb.append(this.criteria.getExpression());
            sb.append(" active=");
            sb.append(this.active);
            sb.append(" positive=");
            sb.append(this.positive);
        } else {
            sb.append("empty criteria");
        }
        return sb.toString();
    }

    public FilterCriteria(Criteria criteria_, boolean active_, boolean positive_) {
        this.setCriteria(criteria_);
        this.setActive(active_);
        this.setPositive(positive_);
    }

    public FilterCriteria(Criteria criteria_, boolean active_, boolean positive_, String loaderClassName_) {
        this.setCriteria(criteria_);
        this.setActive(active_);
        this.setPositive(positive_);
        this.setLoaderClassName(loaderClassName_);
    }

    public FilterCriteria(FilterCriteria other) {
        this.criteria = new Criteria(other.criteria);
        this.active = other.active;
        this.positive = other.positive;
        this.loaderClassName = other.loaderClassName;
    }

    protected FilterCriteria() {
    }

    public void setCriteria(Criteria criteria_) {
        this.criteria = criteria_;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setActive(boolean active_) {
        this.active = active_;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setPositive(boolean positive_) {
        this.positive = positive_;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public void setLoaderClassName(String loaderClassName_) {
        this.loaderClassName = loaderClassName_;
    }

    public String getLoaderClassName() {
        return this.loaderClassName;
    }

    public static FilterCriteria find(FilterCriteria what, List<FilterCriteria> list) {
        if (what != null && list != null) {
            try {
                for (FilterCriteria fc : list) {
                    if (!what.compareTo(fc)) continue;
                    return fc;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public boolean compareTo(FilterCriteria to) {
        if (this.isPositive() == to.isPositive() && this.getCriteria().compareTo(to.getCriteria())) {
            if (this.getLoaderClassName() == null && to.getLoaderClassName() == null) {
                return true;
            }
            if (this.getLoaderClassName() != null && to.getLoaderClassName() != null && this.getLoaderClassName().equals(to.getLoaderClassName())) {
                return true;
            }
        }
        return false;
    }

    public void save(DialogSettings settings) {
        settings.put(ACTIVE, this.isActive());
        settings.put(POSITIVE, this.isPositive());
        if (this.getLoaderClassName() != null) {
            settings.put(LOADERCLASSNAME, this.getLoaderClassName());
        } else {
            settings.put(LOADERCLASSNAME, "");
        }
        if (this.criteria != null) {
            this.criteria.save(settings);
        }
    }

    public void load(DialogSettings settings) {
        this.setActive(settings.getBoolean(ACTIVE));
        this.setPositive(settings.getBoolean(POSITIVE));
        String loaderClassName_ = settings.get(LOADERCLASSNAME);
        this.setLoaderClassName(loaderClassName_ != null && loaderClassName_.length() > 0 ? loaderClassName_ : null);
        if (this.criteria != null) {
            this.criteria.load(settings);
        }
    }
}

