/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.experiment;

import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.TmfLocation;

public class TmfExperimentLocation
extends TmfLocation<ITmfLocation<?>[]> {
    private long[] fRanks;

    public TmfExperimentLocation(ITmfLocation<?>[] locations, long[] ranks) {
        super(locations);
        this.fRanks = ranks;
    }

    @Override
    public TmfExperimentLocation clone() {
        super.clone();
        ITmfLocation[] locations = (ITmfLocation[])this.getLocation();
        ITmfLocation[] clones = new ITmfLocation[locations.length];
        int i = 0;
        while (i < locations.length) {
            clones[i] = locations[i].clone();
            ++i;
        }
        return new TmfExperimentLocation(clones, (long[])this.fRanks.clone());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("[TmfExperimentLocation");
        ITmfLocation[] locations = (ITmfLocation[])this.getLocation();
        int i = 0;
        while (i < locations.length) {
            result.append("[" + locations[i].toString() + "," + this.fRanks[i] + "]");
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public long[] getRanks() {
        return this.fRanks;
    }
}

