/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.event;

import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventType;
import org.eclipse.linuxtools.tmf.event.TmfNoSuchFieldException;

public class TmfEventContent
implements Cloneable {
    public static final String FIELD_ID_TIMESTAMP = "$time$";
    public static final String FIELD_ID_SOURCE = "$sour$";
    public static final String FIELD_ID_TYPE = "$type$";
    public static final String FIELD_ID_REFERENCE = "$refe$";
    public static final String FIELD_ID_CONTENT = "$cont$";
    protected TmfEvent fParentEvent;
    protected Object fRawContent;
    protected Object[] fFields;

    public TmfEventContent(TmfEvent parent, Object content) {
        this.fParentEvent = parent;
        this.fRawContent = content;
    }

    public TmfEventContent(TmfEventContent other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fParentEvent = other.fParentEvent;
        this.fRawContent = other.fRawContent;
        this.fFields = other.fFields;
    }

    private TmfEventContent() {
        throw new AssertionError();
    }

    public TmfEvent getEvent() {
        return this.fParentEvent;
    }

    public TmfEventType getType() {
        return this.fParentEvent.getType();
    }

    public Object getContent() {
        return this.fRawContent;
    }

    public Object[] getFields() {
        if (this.fFields == null) {
            this.parseContent();
        }
        return this.fFields;
    }

    public Object getField(String id) throws TmfNoSuchFieldException {
        if (this.fFields == null) {
            this.parseContent();
        }
        try {
            return this.fFields[this.getType().getFieldIndex(id)];
        }
        catch (TmfNoSuchFieldException e) {
            if (id.equals(FIELD_ID_TIMESTAMP)) {
                return new Long(this.fParentEvent.getTimestamp().getValue()).toString();
            }
            if (id.equals(FIELD_ID_SOURCE)) {
                return this.fParentEvent.getSource().getSourceId().toString();
            }
            if (id.equals(FIELD_ID_TYPE)) {
                return this.fParentEvent.getType().getTypeId().toString();
            }
            if (id.equals(FIELD_ID_REFERENCE)) {
                return this.fParentEvent.getReference().getReference().toString();
            }
            if (id.equals(FIELD_ID_CONTENT)) {
                return this.fParentEvent.getContent().toString();
            }
            throw e;
        }
    }

    public Object getField(int n) {
        if (this.fFields == null) {
            this.parseContent();
        }
        if (n >= 0 && n < this.fFields.length) {
            return this.fFields[n];
        }
        return null;
    }

    public void setEvent(TmfEvent event) {
        this.fParentEvent = event;
    }

    protected void parseContent() {
        this.fFields = new Object[1];
        this.fFields[0] = this.fRawContent;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.fParentEvent != null ? this.fParentEvent.hashCode() : 0);
        result = 37 * result + (this.fRawContent != null ? this.fRawContent.hashCode() : 0);
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TmfEventContent)) {
            return false;
        }
        TmfEventContent o = (TmfEventContent)other;
        return this.fRawContent.equals(o.fRawContent);
    }

    public String toString() {
        Object[] fields = this.getFields();
        StringBuilder result = new StringBuilder("[TmfEventContent(");
        int i = 0;
        while (i < fields.length) {
            if (i > 0) {
                result.append(",");
            }
            result.append(fields[i]);
            ++i;
        }
        result.append(")]");
        return result.toString();
    }

    public TmfEventContent clone() {
        TmfEventContent clone = null;
        try {
            clone = (TmfEventContent)super.clone();
            clone.fParentEvent = this.fParentEvent;
            clone.fRawContent = this.fRawContent;
            clone.fFields = this.fFields;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

