/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;

public abstract class TmfProjectTreeNode
implements ITmfProjectTreeNode {
    protected ITmfProjectTreeNode fParent = null;
    protected List<ITmfProjectTreeNode> fChildren = null;

    public TmfProjectTreeNode(ITmfProjectTreeNode parent) {
        this.fParent = parent;
        this.fChildren = new ArrayList<ITmfProjectTreeNode>();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ITmfProjectTreeNode getParent() {
        return this.fParent;
    }

    @Override
    public boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    @Override
    public List<ITmfProjectTreeNode> getChildren() {
        return this.fChildren;
    }

    @Override
    public abstract void refreshChildren();

    @Override
    public void refresh() {
        this.fParent.refresh();
    }

    @Override
    public void removeChild(ITmfProjectTreeNode child) {
        for (ITmfProjectTreeNode node : this.fChildren) {
            if (node != child) continue;
            node.removeChildren();
            this.fChildren.remove(node);
            return;
        }
    }

    @Override
    public void removeChildren() {
        for (ITmfProjectTreeNode node : this.fChildren) {
            node.removeChildren();
        }
        this.fChildren.clear();
    }
}

