/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.model;

import java.lang.reflect.Array;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfExperimentNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectTreeNode;

public class TmfExperimentFolderNode
extends TmfProjectTreeNode {
    private final IFolder fExperimentFolder;

    public TmfExperimentFolderNode(IFolder folder) {
        this(null, folder);
    }

    public TmfExperimentFolderNode(ITmfProjectTreeNode parent, IFolder folder) {
        super(parent);
        this.fExperimentFolder = folder;
    }

    @Override
    public String getName() {
        return this.fExperimentFolder.getName();
    }

    @Override
    public void refreshChildren() {
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.fExperimentFolder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                TmfExperimentNode node;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder && (node = this.find(resource.getName())) == null) {
                    node = new TmfExperimentNode(this, (IFolder)resource);
                    this.fChildren.add(node);
                }
                ++n2;
            }
            for (ITmfProjectTreeNode node : this.fChildren) {
                if (this.exists(node.getName(), resources)) {
                    node.refreshChildren();
                    continue;
                }
                this.fChildren.remove(node);
            }
        }
        catch (CoreException coreException) {}
    }

    private TmfExperimentNode find(String name) {
        for (ITmfProjectTreeNode node : this.fChildren) {
            if (!(node instanceof TmfExperimentNode) || !node.getName().equals(name)) continue;
            return (TmfExperimentNode)node;
        }
        return null;
    }

    private boolean exists(String name, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public TmfProjectNode getProject() {
        return (TmfProjectNode)this.getParent();
    }

    public IFolder getFolder() {
        return this.fExperimentFolder;
    }

    public TmfExperimentNode[] getExperiments() {
        TmfExperimentNode[] result = (TmfExperimentNode[])Array.newInstance(TmfExperimentNode.class, this.fChildren.size());
        return this.fChildren.toArray(result);
    }

    public void addExperiment(IFolder experiment) {
    }
}

