/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.tmf.ui.internal.Messages;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TmfTimeFilterDialog
extends TitleAreaDialog {
    private CheckboxTableViewer viewer;
    private Object[] threads;
    private boolean[] filter;
    private ViewContentProvider viewContentProvider;
    private TraceComparator viewTraceComparator;
    private ViewLabelProvider viewViewLabelProvider;

    public TmfTimeFilterDialog(Shell parentShell, Object[] threads, boolean[] filter) {
        super(parentShell);
        this.threads = threads;
        if (filter != null) {
            this.filter = (boolean[])filter.clone();
        }
        this.viewContentProvider = new ViewContentProvider();
        this.viewTraceComparator = new TraceComparator();
        this.viewViewLabelProvider = new ViewLabelProvider();
    }

    public static boolean getTraceFilter(Shell parentShell, Object[] threads, boolean[] filter) {
        TmfTimeFilterDialog dlg = new TmfTimeFilterDialog(parentShell, threads, filter);
        if (dlg.open() != 0) {
            return false;
        }
        boolean[] f = dlg.getFilter();
        if (Arrays.equals(f, filter)) {
            return false;
        }
        int i = f.length - 1;
        while (i >= 0) {
            filter[i] = f[i];
            --i;
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2560);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setBackground(parent.getBackground());
        this.createColumns(table);
        this.viewer.setContentProvider((IContentProvider)this.viewContentProvider);
        this.viewer.setComparator((ViewerComparator)this.viewTraceComparator);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.viewViewLabelProvider);
        this.viewer.setInput(new Object());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object o = event.getElement();
                int i = TmfTimeFilterDialog.this.threads.length - 1;
                while (i >= 0) {
                    if (TmfTimeFilterDialog.this.threads[i].equals(o)) {
                        ((TmfTimeFilterDialog)TmfTimeFilterDialog.this).filter[i] = event.getChecked();
                    }
                    --i;
                }
            }
        });
        if (this.filter != null) {
            int i = 0;
            while (i < this.filter.length) {
                this.viewer.setChecked(this.threads[i], this.filter[i]);
                ++i;
            }
        }
        this.setMessage(Messages.TmfTimeFilterDialog_TRACE_FILTER_DESC);
        this.setTitle(Messages.TmfTimeFilterDialog_TRACE_FILTER);
        TmfTimeFilterDialog.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        return composite;
    }

    private void createColumns(Table table) {
        table.setHeaderVisible(true);
        String[] headers = new String[]{"", Messages.TmfTimeFilterDialog_TRACE_ID, Messages.TmfTimeFilterDialog_TRACE_NAME};
        int[] width = new int[]{20, 80, 400};
        int i = 0;
        while (i < headers.length) {
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setText(headers[i]);
            tc.setWidth(width[i]);
            ++i;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TmfTimeFilterDialog_EDIT_PROFILING_OPTIONS);
    }

    public boolean[] getFilter() {
        return this.filter;
    }

    public void setViewContentProvider(ViewContentProvider viewContentProvider) {
        this.viewContentProvider = viewContentProvider;
    }

    public void setViewThreadComparator(TraceComparator viewThreadComparator) {
        this.viewTraceComparator = viewThreadComparator;
    }

    public void setViewViewLabelProvider(ViewLabelProvider viewViewLabelProvider) {
        this.viewViewLabelProvider = viewViewLabelProvider;
    }

    class TraceComparator
    extends ViewerComparator {
        TraceComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int id2;
            int id1 = ((ITmfTimeAnalysisEntry)e1).getId();
            if (id1 == (id2 = ((ITmfTimeAnalysisEntry)e2).getId())) {
                return 0;
            }
            return id1 < id2 ? -1 : 1;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            return TmfTimeFilterDialog.this.threads;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public Image getImage(Object obj) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ITmfTimeAnalysisEntry t = (ITmfTimeAnalysisEntry)element;
            if (columnIndex == 1) {
                return String.valueOf(t.getId());
            }
            if (columnIndex == 2) {
                return t.getName();
            }
            return "";
        }
    }
}

