/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.propertypage;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.rpm.core.utils.RPMQuery;
import org.eclipse.linuxtools.rpm.ui.propertypage.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class TargetPage
extends PropertyPage {
    private static final String RPM_ARCH = Messages.getString("TargetPage.Architecture");
    private static final String RPM_PLATFORM = Messages.getString("TargetPage.Platform");
    private static final String RPM_OS = Messages.getString("TargetPage.OS");
    private static final String RPM_HOST = Messages.getString("TargetPage.BuildHost");
    private static final String RPM_TIME = Messages.getString("TargetPage.BuildTime");
    private static final int ARCH_FIELD_WIDTH = 8;
    private static final int PLATFORM_FIELD_WIDTH = 20;
    private static final int OS_FIELD_WIDTH = 10;
    private static final int HOST_FIELD_WIDTH = 40;
    private static final int TIME_FIELD_WIDTH = 35;
    private Label rpm_archText;
    private Label rpm_platformText;
    private Label rpm_osText;
    private Label rpm_hostText;
    private Label rpm_timeText;

    private void addTargetFields(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label rpmArchLabel = new Label(composite, 0);
        rpmArchLabel.setText(RPM_ARCH);
        this.rpm_archText = new Label(composite, 256);
        GridData gdArch = new GridData();
        gdArch.widthHint = this.convertWidthInCharsToPixels(8);
        this.rpm_archText.setLayoutData((Object)gdArch);
        Label rpmPlatformLabel = new Label(composite, 0);
        rpmPlatformLabel.setText(RPM_PLATFORM);
        this.rpm_platformText = new Label(composite, 256);
        GridData gdPlatform = new GridData();
        gdPlatform.widthHint = this.convertWidthInCharsToPixels(20);
        this.rpm_platformText.setLayoutData((Object)gdPlatform);
        Label rpmOSLabel = new Label(composite, 0);
        rpmOSLabel.setText(RPM_OS);
        this.rpm_osText = new Label(composite, 256);
        GridData gdOS = new GridData();
        gdOS.widthHint = this.convertWidthInCharsToPixels(10);
        this.rpm_osText.setLayoutData((Object)gdOS);
        Label rpmHostLabel = new Label(composite, 0);
        rpmHostLabel.setText(RPM_HOST);
        this.rpm_hostText = new Label(composite, 256);
        GridData gdHost = new GridData();
        gdHost.widthHint = this.convertWidthInCharsToPixels(40);
        this.rpm_hostText.setLayoutData((Object)gdHost);
        Label rpmTimeLabel = new Label(composite, 0);
        rpmTimeLabel.setText(RPM_TIME);
        this.rpm_timeText = new Label(composite, 256);
        GridData gdTime = new GridData();
        gdTime.widthHint = this.convertWidthInCharsToPixels(35);
        this.rpm_timeText.setLayoutData((Object)gdTime);
        try {
            IFile rpmFile = (IFile)this.getElement();
            String rpm_arch = RPMQuery.getArch((IFile)rpmFile);
            this.rpm_archText.setText(rpm_arch);
            String rpm_platform = RPMQuery.getPlatform((IFile)rpmFile);
            this.rpm_platformText.setText(rpm_platform);
            String rpm_os = RPMQuery.getOS((IFile)rpmFile);
            this.rpm_osText.setText(rpm_os);
            String rpm_host = RPMQuery.getBuildHost((IFile)rpmFile);
            this.rpm_hostText.setText(rpm_host);
            String rpm_time = RPMQuery.getBuildTime((IFile)rpmFile);
            this.rpm_timeText.setText(rpm_time);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(new StatusAdapter(e.getStatus()), 3);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addTargetFields(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }
}

