/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.tracecontrol.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.lttng.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceConfig;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class TraceResource
extends AbstractResource
implements Comparable<TraceResource> {
    public static final String Ltt_Trace_Property_TracePath = "trace_path";
    public static final String Ltt_Trace_Property_TraceNumberOfChannels = "num_threads";
    public static final String Ltt_Trace_Property_FlightRecorderMode = "flight_only";
    public static final String Ltt_Trace_Property_NormalMode = "normal_only";
    public static final String Ltt_Trace_Property_NetworkTrace = "isNetwork";
    public static final String Ltt_Trace_Property_TraceTransport = "transport";
    private static final Map<String, PropertyInfo> fPropertyInfo = new HashMap<String, PropertyInfo>();
    private String fName;
    private String fId;
    private TargetResource fParent;
    private TraceState fTraceState;
    private TraceConfig fTraceConfig;

    static {
        fPropertyInfo.put(Ltt_Trace_Property_TracePath, new PropertyInfo(Messages.Ltt_Trace_Property_TracePathName, Messages.Ltt_Trace_Property_TracePathDescription));
        fPropertyInfo.put(Ltt_Trace_Property_TraceNumberOfChannels, new PropertyInfo(Messages.Ltt_Trace_Property_NumberOfChannelsName, Messages.Ltt_Trace_Property_NumberOfChannelsDescr));
        fPropertyInfo.put(Ltt_Trace_Property_FlightRecorderMode, new PropertyInfo(Messages.Ltt_Trace_Property_FlighRecorderModeName, Messages.Ltt_Trace_Property_FlighRecorderModeDesc));
        fPropertyInfo.put(Ltt_Trace_Property_NormalMode, new PropertyInfo(Messages.Ltt_Trace_Property_NormalModeName, Messages.Ltt_Trace_Property_NormalModeDesc));
        fPropertyInfo.put(Ltt_Trace_Property_NetworkTrace, new PropertyInfo(Messages.Ltt_Trace_Property_NetworkTraceName, Messages.Ltt_Trace_Property_NetWorkTraceDescr));
        fPropertyInfo.put(Ltt_Trace_Property_TraceTransport, new PropertyInfo(Messages.Ltt_Trace_Property_TraceTransportName, Messages.Ltt_Trace_Property_TraceTransportDesc));
    }

    public TraceResource(ISubSystem parentSubSystem) {
        super(parentSubSystem);
    }

    public TraceState getTraceState() {
        return this.fTraceState;
    }

    public void setTraceState(TraceState traceState) {
        this.fTraceState = traceState;
    }

    public TraceConfig getTraceConfig() {
        return this.fTraceConfig;
    }

    public void setTraceConfig(TraceConfig traceConfig) {
        this.fTraceConfig = traceConfig;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getId() {
        return this.fId;
    }

    public void setId(String id) {
        this.fId = id;
    }

    public TargetResource getParent() {
        return this.fParent;
    }

    public void setParent(TargetResource target) {
        this.fParent = target;
    }

    public Map<String, PropertyInfo> getPropertyInfo() {
        return fPropertyInfo;
    }

    public String getProperty(String property) {
        if (this.fTraceConfig != null && fPropertyInfo.containsKey(property)) {
            if (Ltt_Trace_Property_TracePath.equals(property)) {
                return this.fTraceConfig.getTracePath();
            }
            if (Ltt_Trace_Property_TraceNumberOfChannels.equals(property)) {
                return String.valueOf(this.fTraceConfig.getNumChannel());
            }
            if (Ltt_Trace_Property_FlightRecorderMode.equals(property)) {
                return String.valueOf(this.fTraceConfig.getMode() == 1);
            }
            if (Ltt_Trace_Property_NormalMode.equals(property)) {
                return String.valueOf(this.fTraceConfig.getMode() == 2);
            }
            if (Ltt_Trace_Property_NetworkTrace.equals(property)) {
                return String.valueOf(this.fTraceConfig.isNetworkTrace());
            }
            if (Ltt_Trace_Property_TraceTransport.equals(property)) {
                return String.valueOf(this.fTraceConfig.getTraceTransport());
            }
        }
        return "";
    }

    public boolean isNetworkTraceAndStarted() {
        return this.fTraceConfig != null && this.fTraceConfig.isNetworkTrace() && !"network".equals(this.fTraceConfig.getTracePath()) && this.fTraceState == TraceState.STARTED;
    }

    public boolean isUst() {
        return this.fParent.isUst();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TraceResource) {
            TraceResource otherTrace = (TraceResource)other;
            if (this.fName == null && otherTrace.fName == null) {
                return false;
            }
            if (this.fName == null && otherTrace.fName != null) {
                return false;
            }
            if (this.fName != null && otherTrace.fName == null) {
                return false;
            }
            return this.fName.equals(otherTrace.fName);
        }
        return false;
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    @Override
    public int compareTo(TraceResource o) {
        return this.fName.toLowerCase().compareTo(o.fName.toLowerCase());
    }

    public String toString() {
        return "[TraceResource (" + this.fName + ")]";
    }

    public static class PropertyInfo {
        private final String name;
        private final String description;

        PropertyInfo(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum TraceState {
        CREATED,
        CONFIGURED,
        STARTED,
        PAUSED,
        STOPPED;

    }
}

