/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.ui.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.IAutoconfErrorHandler;
import org.eclipse.linuxtools.cdt.autotools.ui.editors.parser.ParseException;
import org.eclipse.ui.IEditorInput;

public class AutoconfErrorHandler
implements IAutoconfErrorHandler {
    public static final String CDT_ANNOTATION_INFO = "org.eclipse.cdt.ui.info";
    public static final String CDT_ANNOTATION_WARNING = "org.eclipse.cdt.ui.warning";
    public static final String CDT_ANNOTATION_ERROR = "org.eclipse.cdt.ui.error";
    private int CDT_WARNING = 1;
    private int CDT_ERROR = 2;
    private Map<Position, Annotation> annotations = new HashMap<Position, Annotation>();
    private AnnotationModel fAnnotationModel;

    public AutoconfErrorHandler(IEditorInput input) {
        this.fAnnotationModel = (AnnotationModel)AutoconfEditor.getAutoconfDocumentProvider().getAnnotationModel(input);
    }

    public void handleError(ParseException e) {
        Integer charStart = new Integer(e.getStartOffset());
        Integer charEnd = new Integer(e.getEndOffset());
        String annotationType = CDT_ANNOTATION_INFO;
        if (e.getSeverity() == this.CDT_ERROR) {
            annotationType = CDT_ANNOTATION_ERROR;
        } else if (e.getSeverity() == this.CDT_WARNING) {
            annotationType = CDT_ANNOTATION_WARNING;
        }
        AutoconfAnnotation annotation = new AutoconfAnnotation(annotationType, true, e.getLocalizedMessage());
        Position p = new Position(charStart.intValue(), charEnd - charStart);
        this.fAnnotationModel.addAnnotation((Annotation)annotation, p);
        this.annotations.put(p, annotation);
    }

    public void removeAllExistingMarkers() {
        this.fAnnotationModel.removeAllAnnotations();
        this.annotations.clear();
    }

    public void removeExistingMarkers(int offset, int length) {
        Iterator i = this.fAnnotationModel.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation annotation = (Annotation)i.next();
            Position p = this.fAnnotationModel.getPosition(annotation);
            int pStart = p.getOffset();
            if (pStart < offset || pStart >= offset + length) continue;
            this.fAnnotationModel.removeAnnotation(annotation);
        }
    }

    private class AutoconfAnnotation
    extends Annotation
    implements IQuickFixableAnnotation {
        public AutoconfAnnotation(String annotationType, boolean persist, String message) {
            super(annotationType, persist, message);
        }

        public void setQuickFixable(boolean state) {
        }

        public boolean isQuickFixableStateSet() {
            return true;
        }

        public boolean isQuickFixable() throws AssertionFailedException {
            return false;
        }
    }
}

