/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.views;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.systemtap.ui.editor.RecentFileMenuManager;
import org.eclipse.linuxtools.systemtap.ui.ide.internal.IDEPlugin;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class BrowserView
extends ViewPart {
    protected TreeViewer viewer;

    public void createPartControl(Composite parent) {
        parent.getShell().setCursor(new Cursor((Device)parent.getShell().getDisplay(), 1));
        this.viewer = new TreeViewer(parent, 2818);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        RecentFileMenuManager.getInstance().registerActionBar(this.getViewSite().getActionBars());
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
    }

    abstract void refresh();

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getChildren(Object par) {
            TreeNode parent = (TreeNode)par;
            Object[] children = new Object[parent.getChildCount()];
            int i = 0;
            while (i < children.length) {
                children[i] = parent.getChildAt(i);
                ++i;
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return ((TreeNode)parent).getChildCount() > 0;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            TreeNode treeObj = (TreeNode)obj;
            String item = treeObj.getData().toString();
            Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            if (treeObj.getChildCount() > 0) {
                img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (item.endsWith(".c")) {
                img = IDEPlugin.getImageDescriptor("icons/files/file_c.gif").createImage();
            }
            if (item.endsWith(".h")) {
                img = IDEPlugin.getImageDescriptor("icons/files/file_h.gif").createImage();
            }
            if (item.endsWith(")") && !item.endsWith("\")")) {
                img = (item = item.substring(0, item.indexOf("(")).trim()).endsWith(":long") ? IDEPlugin.getImageDescriptor("icons/vars/var_long.gif").createImage() : (item.endsWith(":string") ? IDEPlugin.getImageDescriptor("icons/vars/var_str.gif").createImage() : IDEPlugin.getImageDescriptor("icons/vars/var_void.gif").createImage());
            } else {
                if (item.startsWith("probe")) {
                    img = IDEPlugin.getImageDescriptor("icons/misc/probe_obj.gif").createImage();
                }
                if (item.endsWith(":long")) {
                    img = IDEPlugin.getImageDescriptor("icons/vars/var_long.gif").createImage();
                } else if (item.endsWith(":string")) {
                    img = IDEPlugin.getImageDescriptor("icons/vars/var_str.gif").createImage();
                } else if (item.endsWith(":unknown")) {
                    img = IDEPlugin.getImageDescriptor("icons/vars/var_unk.gif").createImage();
                }
            }
            return img;
        }
    }

    protected class ViewUpdater
    implements IUpdateListener {
        protected ViewUpdater() {
        }

        public void handleUpdateEvent() {
            try {
                BrowserView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        BrowserView.this.refresh();
                    }
                });
            }
            catch (Exception exception) {}
        }
    }
}

