/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class CWordFinder {
    private static final char CBRACE_L = '{';
    private static final char CBRACE_R = '}';
    private static final char BRACE_R = ')';

    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos + 1;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start >= offset && end == offset) {
                return new Region(offset, 0);
            }
            return new Region(start, end - start);
        }
        return null;
    }

    public static IRegion findFunction(IDocument document, int offset) {
        int leftbracket = -1;
        int leftbracketcount = 0;
        int rightbracket = -1;
        int rightbracketcount = 0;
        int functionstart = -1;
        int functionend = -1;
        try {
            char c;
            int length = document.getLength();
            int pos = offset;
            leftbracketcount = 0;
            rightbracketcount = 0;
            while (pos < length) {
                c = document.getChar(pos);
                if (c == ')' && ++rightbracketcount >= leftbracketcount) {
                    rightbracket = pos;
                    break;
                }
                if (c == '(') {
                    ++leftbracketcount;
                }
                if (c == ';') break;
                ++pos;
            }
            if (rightbracket == -1) {
                return new Region(offset, 0);
            }
            pos = rightbracket;
            leftbracketcount = 0;
            rightbracketcount = 0;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (c == ')') {
                    ++rightbracketcount;
                }
                if (c == '(' && ++leftbracketcount >= rightbracketcount) {
                    leftbracket = pos;
                    break;
                }
                if (c == ';') break;
                --pos;
            }
            if (leftbracket == -1) {
                return new Region(offset, 0);
            }
            pos = leftbracket - 1;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (functionend == -1 && c == ' ') {
                    --pos;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) {
                    functionstart = pos;
                    if (functionend == -1) {
                        functionend = pos;
                    }
                    --pos;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (functionstart > -1 && functionend > -1) {
            return new Region(functionstart, functionend - functionstart + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGlobal(IDocument document, int offset) {
        try {
            int pos = offset;
            int bracketcount = 0;
            while (true) {
                char c;
                if (pos <= 0) {
                    return true;
                }
                if ((c = document.getChar(pos--)) == '}') {
                    ++bracketcount;
                    continue;
                }
                if (c != '{' || bracketcount-- != 0) continue;
                do {
                    if ((c = document.getChar(pos--)) != ')') continue;
                    return false;
                } while (Character.isWhitespace(c));
                ++pos;
                bracketcount = 0;
            }
        }
        catch (BadLocationException badLocationException) {}
        return true;
    }

    public static int countLFs(String s) {
        int counter = 0;
        char lf = '\u0000';
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (lf == '\u0000') {
                if (c == '\n' || c == '\r') {
                    lf = c;
                    ++counter;
                }
            } else if (lf == c) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public static boolean hasCBraces(String s) {
        return s.indexOf(123) > -1 || s.indexOf(125) > -1;
    }
}

