/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.event;

import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventType;

public class LttngEventType
extends TmfEventType {
    private static final String DEFAULT_CONTEXT = "Kernel Trace";
    private static final String DEFAULT_TYPE_ID = "Kernel Trace";
    public static final String TIMESTAMP_LABEL = "Timestamp";
    public static final String TRACE_LABEL = "Trace";
    public static final String MARKER_LABEL = "Marker";
    public static final String CONTENT_LABEL = "Content";
    private static final String[] DEFAULT_LABELS = new String[]{"Timestamp", "Trace", "Marker", "Content"};
    public static final LttngEventType DEFAULT_EVENT_TYPE = new LttngEventType("Kernel Trace", DEFAULT_LABELS);
    private String tracefileName = null;
    private Long cpuId = null;
    private String markerName = null;
    private int markerId = -1;

    public LttngEventType() {
    }

    public LttngEventType(String typeId, String[] labels) {
        super("Kernel Trace", typeId, TmfEventField.makeRoot((String[])labels));
    }

    public LttngEventType(String thisTracefileName, Long thisCpuId, String thisMarkerName, int thisMarkerId, String[] thisMarkerfieldsName) {
        super("Kernel Trace", String.valueOf(thisTracefileName) + "/" + thisCpuId + "/" + thisMarkerName, TmfEventField.makeRoot((String[])thisMarkerfieldsName));
        this.tracefileName = thisTracefileName;
        this.cpuId = thisCpuId;
        this.markerName = thisMarkerName;
        this.markerId = thisMarkerId;
    }

    public LttngEventType(LttngEventType oldType) {
        this(oldType.tracefileName, oldType.cpuId, oldType.markerName, oldType.markerId, oldType.getFieldNames());
    }

    public String getTracefileName() {
        return this.tracefileName;
    }

    public Long getCpuId() {
        return this.cpuId;
    }

    public String getMarkerName() {
        return this.markerName;
    }

    public int getMarkerId() {
        return this.markerId;
    }

    public String toString() {
        return String.valueOf(this.tracefileName) + "/" + this.cpuId.toString() + "/" + this.markerName;
    }

    public LttngEventType clone() {
        LttngEventType clone = (LttngEventType)super.clone();
        clone.tracefileName = this.tracefileName;
        clone.cpuId = (long)this.cpuId;
        clone.markerName = this.markerName;
        clone.markerId = this.markerId;
        return clone;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.cpuId == null ? 0 : this.cpuId.hashCode());
        result = 31 * result + this.markerId;
        result = 31 * result + (this.markerName == null ? 0 : this.markerName.hashCode());
        result = 31 * result + (this.tracefileName == null ? 0 : this.tracefileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LttngEventType)) {
            return false;
        }
        LttngEventType other = (LttngEventType)((Object)obj);
        if (this.cpuId == null ? other.cpuId != null : !this.cpuId.equals(other.cpuId)) {
            return false;
        }
        if (this.markerId != other.markerId) {
            return false;
        }
        if (this.markerName == null ? other.markerName != null : !this.markerName.equals(other.markerName)) {
            return false;
        }
        return !(this.tracefileName == null ? other.tracefileName != null : !this.tracefileName.equals(other.tracefileName));
    }
}

