/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_c722md.core.internal.instr;

import org.jacoco.agent.rt_c722md.asm.Label;
import org.jacoco.agent.rt_c722md.asm.MethodVisitor;
import org.jacoco.agent.rt_c722md.core.internal.flow.IMethodProbesVisitor;
import org.jacoco.agent.rt_c722md.core.internal.flow.LabelInfo;
import org.jacoco.agent.rt_c722md.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt_c722md.core.internal.instr.InstrSupport;
import org.jacoco.agent.rt_c722md.core.internal.instr.ProbeVariableInserter;

class MethodInstrumenter
extends ProbeVariableInserter
implements IMethodProbesVisitor {
    private final IProbeArrayStrategy probeArrayStrategy;
    private int accessorStackSize;

    public MethodInstrumenter(MethodVisitor mv, int access, String desc, IProbeArrayStrategy probeArrayStrategy) {
        super(access, desc, mv);
        this.probeArrayStrategy = probeArrayStrategy;
    }

    public void visitCode() {
        super.visitCode();
        this.accessorStackSize = this.probeArrayStrategy.pushInstance(this.mv);
        this.mv.visitVarInsn(58, this.variable);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        int increasedStack = Math.max(maxStack + 3, this.accessorStackSize);
        super.visitMaxs(increasedStack, maxLocals);
    }

    private void insertProbe(int id) {
        this.mv.visitVarInsn(25, this.variable);
        InstrSupport.push(this.mv, id);
        this.mv.visitInsn(4);
        this.visitInsn(84);
    }

    public void visitProbe(int probeId) {
        this.insertProbe(probeId);
    }

    public void visitInsnWithProbe(int opcode, int probeId) {
        this.insertProbe(probeId);
        this.mv.visitInsn(opcode);
    }

    public void visitJumpInsnWithProbe(int opcode, Label label, int probeId) {
        if (opcode == 167) {
            this.insertProbe(probeId);
            this.mv.visitJumpInsn(167, label);
        } else {
            Label l = new Label();
            this.mv.visitJumpInsn(this.getNegation(opcode), l);
            this.insertProbe(probeId);
            this.mv.visitJumpInsn(167, label);
            this.mv.visitLabel(l);
        }
    }

    private int getNegation(int opcode) {
        switch (opcode) {
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 155: {
                return 156;
            }
            case 156: {
                return 155;
            }
            case 157: {
                return 158;
            }
            case 158: {
                return 157;
            }
            case 159: {
                return 160;
            }
            case 160: {
                return 159;
            }
            case 161: {
                return 162;
            }
            case 162: {
                return 161;
            }
            case 163: {
                return 164;
            }
            case 164: {
                return 163;
            }
            case 165: {
                return 166;
            }
            case 166: {
                return 165;
            }
            case 198: {
                return 199;
            }
            case 199: {
                return 198;
            }
        }
        throw new AssertionError(opcode);
    }

    public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        Label newDflt = this.createIntermediate(dflt);
        Label[] newLabels = this.createIntermediates(labels);
        this.mv.visitTableSwitchInsn(min, max, newDflt, newLabels);
        this.insertIntermediateProbes(dflt, labels);
    }

    public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        Label newDflt = this.createIntermediate(dflt);
        Label[] newLabels = this.createIntermediates(labels);
        this.mv.visitLookupSwitchInsn(newDflt, keys, newLabels);
        this.insertIntermediateProbes(dflt, labels);
    }

    private Label createIntermediate(Label label) {
        Label intermediate;
        if (LabelInfo.getProbeId(label) == -1) {
            intermediate = label;
        } else if (LabelInfo.isDone(label)) {
            intermediate = LabelInfo.getIntermediateLabel(label);
        } else {
            intermediate = new Label();
            LabelInfo.setIntermediateLabel(label, intermediate);
            LabelInfo.setDone(label);
        }
        return intermediate;
    }

    private Label[] createIntermediates(Label[] labels) {
        Label[] intermediates = new Label[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            intermediates[i] = this.createIntermediate(labels[i]);
        }
        return intermediates;
    }

    private void insertIntermediateProbe(Label label) {
        int probeId = LabelInfo.getProbeId(label);
        if (probeId != -1 && !LabelInfo.isDone(label)) {
            this.mv.visitLabel(LabelInfo.getIntermediateLabel(label));
            this.insertProbe(probeId);
            this.mv.visitJumpInsn(167, label);
            LabelInfo.setDone(label);
        }
    }

    private void insertIntermediateProbes(Label dflt, Label[] labels) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        this.insertIntermediateProbe(dflt);
        for (Label l : labels) {
            this.insertIntermediateProbe(l);
        }
    }
}

