/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.analysis;

import java.util.Collection;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.internal.analysis.CounterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageNodeImpl
implements ICoverageNode {
    private final ICoverageNode.ElementType elementType;
    private final String name;
    protected CounterImpl branchCounter;
    protected CounterImpl instructionCounter;
    protected CounterImpl lineCounter;
    protected CounterImpl methodCounter;
    protected CounterImpl classCounter;

    public CoverageNodeImpl(ICoverageNode.ElementType elementType, String name) {
        this.elementType = elementType;
        this.name = name;
        this.branchCounter = CounterImpl.COUNTER_0_0;
        this.instructionCounter = CounterImpl.COUNTER_0_0;
        this.methodCounter = CounterImpl.COUNTER_0_0;
        this.classCounter = CounterImpl.COUNTER_0_0;
        this.lineCounter = CounterImpl.COUNTER_0_0;
    }

    public void increment(ICoverageNode child) {
        this.instructionCounter = this.instructionCounter.increment(child.getInstructionCounter());
        this.branchCounter = this.branchCounter.increment(child.getBranchCounter());
        this.methodCounter = this.methodCounter.increment(child.getMethodCounter());
        this.classCounter = this.classCounter.increment(child.getClassCounter());
        this.lineCounter = this.lineCounter.increment(child.getLineCounter());
    }

    public void increment(Collection<? extends ICoverageNode> children) {
        for (ICoverageNode iCoverageNode : children) {
            this.increment(iCoverageNode);
        }
    }

    @Override
    public ICoverageNode.ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ICounter getInstructionCounter() {
        return this.instructionCounter;
    }

    @Override
    public ICounter getBranchCounter() {
        return this.branchCounter;
    }

    @Override
    public ICounter getLineCounter() {
        return this.lineCounter;
    }

    @Override
    public ICounter getMethodCounter() {
        return this.methodCounter;
    }

    @Override
    public ICounter getClassCounter() {
        return this.classCounter;
    }

    @Override
    public ICounter getCounter(ICoverageNode.CounterEntity entity) {
        switch (entity) {
            case INSTRUCTION: {
                return this.getInstructionCounter();
            }
            case BRANCH: {
                return this.getBranchCounter();
            }
            case LINE: {
                return this.getLineCounter();
            }
            case METHOD: {
                return this.getMethodCounter();
            }
            case CLASS: {
                return this.getClassCounter();
            }
        }
        throw new AssertionError((Object)entity);
    }

    @Override
    public ICoverageNode getPlainCopy() {
        CoverageNodeImpl copy = new CoverageNodeImpl(this.elementType, this.name);
        copy.instructionCounter = CounterImpl.getInstance(this.instructionCounter);
        copy.branchCounter = CounterImpl.getInstance(this.branchCounter);
        copy.methodCounter = CounterImpl.getInstance(this.methodCounter);
        copy.classCounter = CounterImpl.getInstance(this.classCounter);
        copy.lineCounter = CounterImpl.getInstance(this.lineCounter);
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" [").append((Object)this.elementType).append("]");
        return sb.toString();
    }
}

