/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.help.ui.internal.search;
import java.text.*;

import org.eclipse.help.internal.search.*;
import org.eclipse.help.ui.internal.ide.*;
import org.eclipse.jface.resource.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.graphics.*;
public class ResultTableLabelProvider extends LabelProvider {
	private static final ImageDescriptor IMAGE_DSCR_TOPIC = ImageDescriptor
			.createFromURL(HelpIdeResources
					.getImagePath(IHelpIdeConstants.IMAGE_FILE_TOPIC));
	static ImageRegistry imgRegistry = null;
	ResultTableLabelProvider() {
		super();
		if (imgRegistry == null) {
			imgRegistry = HelpIdePlugin.getDefault().getImageRegistry();
			imgRegistry
					.put(IHelpIdeConstants.IMAGE_KEY_TOPIC, IMAGE_DSCR_TOPIC);
		}
	}
	public String getText(Object o) {
		if (o instanceof SearchHit) {
			SearchHit searchHit = (SearchHit) o;
			// Use Score percentage and label as topic label
			float score = searchHit.getScore();
			NumberFormat percentFormat = NumberFormat.getPercentInstance();
			String scoreString = percentFormat.format(score);
			return scoreString + " " + searchHit.getLabel(); //$NON-NLS-1$
		}
		return super.getText(o);
	}
	public Image getImage(Object o) {
		if (o instanceof SearchHit)
			return imgRegistry.get(IHelpIdeConstants.IMAGE_KEY_TOPIC);
		return super.getImage(o);
	}
}