/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.DownloadAndOpenTaskAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.ITaskAttachmentViewer;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class TaskAttachmentEditorViewer
implements ITaskAttachmentViewer {
    private static final String PREF_DO_NOT_WARN_BEFORE_OPENING_ATTACHMENTS = "do.not.warn.before.opening.attachments";
    private final IEditorDescriptor descriptor;
    private final boolean isWorkbenchDefault;
    private final boolean isSystem;

    TaskAttachmentEditorViewer(IEditorDescriptor descriptor) {
        this(descriptor, false);
    }

    TaskAttachmentEditorViewer(IEditorDescriptor descriptor, boolean isWorkbenchDefault) {
        this(descriptor, isWorkbenchDefault, false);
    }

    TaskAttachmentEditorViewer(IEditorDescriptor descriptor, boolean isWorkbenchDefault, boolean isSystem) {
        this.descriptor = descriptor;
        this.isWorkbenchDefault = isWorkbenchDefault;
        this.isSystem = isSystem;
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public String getLabel() {
        return this.descriptor.getLabel();
    }

    @Override
    public void openAttachment(IWorkbenchPage page, ITaskAttachment attachment) throws CoreException {
        if (this.promptToConfirmOpen(attachment)) {
            DownloadAndOpenTaskAttachmentJob job = new DownloadAndOpenTaskAttachmentJob(MessageFormat.format(Messages.TaskAttachmentEditorViewer_openingAttachment, AttachmentUtil.getAttachmentFilename(attachment)), attachment, page, this.descriptor.getId());
            WorkbenchUtil.busyCursorWhile((ICoreRunnable)job);
        }
    }

    private boolean promptToConfirmOpen(ITaskAttachment attachment) {
        IPreferenceStore store;
        if (this.isSystem() && !(store = TasksUiPlugin.getDefault().getPreferenceStore()).getBoolean(PREF_DO_NOT_WARN_BEFORE_OPENING_ATTACHMENTS)) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)WorkbenchUtil.getShell(), (String)Messages.TaskAttachmentEditorViewer_Open_Attachment, (String)NLS.bind((String)Messages.TaskAttachmentEditorViewer_Some_files_can_harm_your_computer, (Object)attachment.getFileName()), (String)Messages.TaskAttachmentEditorViewer_Do_not_warn_me_again, (boolean)false, null, null);
            if (dialog.getReturnCode() == 2) {
                if (dialog.getToggleState()) {
                    store.setValue(PREF_DO_NOT_WARN_BEFORE_OPENING_ATTACHMENTS, true);
                    TasksUiPlugin.getDefault().savePluginPreferences();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWorkbenchDefault() {
        return this.isWorkbenchDefault;
    }

    protected boolean isSystem() {
        return this.isSystem;
    }
}

