/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.CheatSheetViewerFactory;
import org.eclipse.ui.cheatsheets.ICheatSheetEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.state.MementoStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.provisional.cheatsheets.IEditableTask;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskEditor;

public class CheatsheetTaskEditor
extends TaskEditor {
    private CheatSheetViewer viewer;
    private IEditableTask task;

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        this.viewer = (CheatSheetViewer)CheatSheetViewerFactory.createCheatSheetView();
        this.viewer.createPartControl(parent);
    }

    @Override
    public Control getControl() {
        return this.viewer.getControl();
    }

    @Override
    public void setInput(IEditableTask task, IMemento memento) {
        boolean showIntro;
        block10: {
            this.task = task;
            Dictionary<String, String> params = task.getParameters();
            String id = params.get("id");
            String path = params.get("path");
            showIntro = true;
            String showIntroParam = params.get("showIntro");
            if (showIntroParam != null) {
                showIntro = showIntroParam.equalsIgnoreCase("true");
            }
            MementoStateManager stateManager = new MementoStateManager(memento, task.getCompositeCheatSheet().getCheatSheetManager());
            if (path != null) {
                try {
                    URL url = task.getInputUrl(path);
                    if (id == null) {
                        id = task.getId();
                    }
                    if (url != null) {
                        this.viewer.setInput(id, task.getName(), url, stateManager, false);
                        break block10;
                    }
                    this.errorBadUrl(path);
                }
                catch (MalformedURLException e) {
                    this.errorBadUrl(path);
                }
            } else if (id != null) {
                this.viewer.setInput(id, stateManager);
            } else {
                this.viewer.showError(Messages.CHEATSHEET_TASK_NO_ID);
            }
        }
        if (!showIntro) {
            this.viewer.advanceIntroItem();
        }
        this.viewer.addListener(new TaskListener());
    }

    private void errorBadUrl(String path) {
        String message = NLS.bind((String)Messages.ERROR_OPENING_FILE_IN_PARSER, (Object[])new Object[]{path});
        this.viewer.showError(message);
    }

    @Override
    public void saveState(IMemento memento) {
        this.viewer.saveState(memento);
    }

    private class TaskListener
    extends CheatSheetListener {
        private TaskListener() {
        }

        @Override
        public void cheatSheetEvent(ICheatSheetEvent event) {
            if (event.getEventType() == 4) {
                CheatsheetTaskEditor.this.task.complete();
            }
        }
    }
}

