/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.events.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFixedFacetsChangedEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.FacetedProjectEvent;

public final class FixedFacetsChangedEvent
extends FacetedProjectEvent
implements IFixedFacetsChangedEvent {
    private final Set<IProjectFacet> oldFixedFacets;
    private final Set<IProjectFacet> newFixedFacets;

    public FixedFacetsChangedEvent(IFacetedProject project, Set<IProjectFacet> oldFixedFacets, Set<IProjectFacet> newFixedFacets) {
        super(project, IFacetedProjectEvent.Type.FIXED_FACETS_CHANGED);
        this.oldFixedFacets = Collections.unmodifiableSet(oldFixedFacets);
        this.newFixedFacets = Collections.unmodifiableSet(newFixedFacets);
    }

    @Override
    public Set<IProjectFacet> getOldFixedFacets() {
        return this.oldFixedFacets;
    }

    @Override
    public Set<IProjectFacet> getNewFixedFacets() {
        return this.newFixedFacets;
    }

    @Override
    protected void toStringInternal(StringBuilder buf) {
        buf.append("  <old-fixed-facets>\n");
        for (IProjectFacet f : FixedFacetsChangedEvent.sort(this.oldFixedFacets)) {
            buf.append("    <facet id=\"");
            buf.append(f.getId());
            buf.append("\"/>\n");
        }
        buf.append("  </old-fixed-facets>\n");
        buf.append("  <new-fixed-facets>\n");
        for (IProjectFacet f : FixedFacetsChangedEvent.sort(this.newFixedFacets)) {
            buf.append("    <facet id=\"");
            buf.append(f.getId());
            buf.append("\"/>\n");
        }
        buf.append("  </new-fixed-facets>\n");
    }

    private static Collection<IProjectFacet> sort(Collection<IProjectFacet> input) {
        TreeSet<IProjectFacet> result = new TreeSet<IProjectFacet>(new FacetComparator());
        result.addAll(input);
        return result;
    }

    private static final class FacetComparator
    implements Comparator<IProjectFacet> {
        private FacetComparator() {
        }

        @Override
        public int compare(IProjectFacet f1, IProjectFacet f2) {
            return f1.getId().compareTo(f2.getId());
        }
    }
}

