/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class LineBackgroundPainter
implements IPainter,
LineBackgroundListener {
    private static final String DEFAULT_TYPE = "__default__";
    private static final String CURSOR_LINE_TYPE = "__cursor_line__";
    private IPaintPositionManager fPositionManager;
    private boolean fIsActive = false;
    private ITextViewer fTextViewer;
    private StyledText fTextWidget;
    private List<Position> fPositions = new ArrayList<Position>();
    private List<Position> fLastPositions = new ArrayList<Position>();
    private List<Position> fChangedPositions = new ArrayList<Position>();
    private Position fCursorLine = new TypedPosition(0, 0, "__cursor_line__");
    private Position fLastCursorLine = new Position(0, 0);
    private boolean fCursorLineEnabled;
    private boolean fCursorLineActive;
    private Map<String, Color> fColorMap = new HashMap<String, Color>();

    public LineBackgroundPainter(ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fTextWidget = textViewer.getTextWidget();
        this.fPositions.add(this.fCursorLine);
        this.fLastPositions.add(this.fLastCursorLine);
    }

    public void setBackgroundColor(String positionType, Color color) {
        this.fColorMap.put(positionType, color);
    }

    public void setCursorLineColor(Color cursorLineColor) {
        this.fColorMap.put(CURSOR_LINE_TYPE, cursorLineColor);
    }

    public void setDefaultColor(Color color) {
        this.fColorMap.put(DEFAULT_TYPE, color);
    }

    public void enableCursorLine(boolean enable) {
        this.fCursorLineEnabled = enable;
        this.fCursorLineActive = enable;
        if (this.fCursorLineActive) {
            this.updateCursorLine();
        }
    }

    public void setHighlightPositions(List<Position> positions) {
        boolean isActive = this.fIsActive;
        this.deactivate(isActive);
        this.fPositions.clear();
        this.fPositions.add(this.fCursorLine);
        this.fPositions.addAll(positions);
        if (isActive) {
            this.activate(true);
        }
    }

    public void addHighlightPositions(List<Position> positions) {
        boolean isActive = this.fIsActive;
        this.deactivate(isActive);
        this.fPositions.addAll(positions);
        if (isActive) {
            this.activate(true);
        }
    }

    public void removeHighlightPositions(List<Position> positions) {
        boolean isActive = this.fIsActive;
        this.deactivate(isActive);
        this.fPositions.removeAll(positions);
        if (isActive) {
            this.activate(true);
        }
    }

    public void replaceHighlightPositions(List<Position> removePositions, List<Position> addPositions) {
        boolean isActive = this.fIsActive;
        this.deactivate(isActive);
        this.fPositions.removeAll(removePositions);
        this.fPositions.addAll(addPositions);
        if (isActive) {
            this.activate(true);
        }
    }

    public void redraw() {
        if (this.fIsActive) {
            this.fTextWidget.redraw();
        }
    }

    private void managePositions(List<Position> positions) {
        if (this.fPositionManager == null) {
            return;
        }
        int sz = this.fPositions.size();
        int i = 0;
        while (i < sz) {
            Position position = positions.get(i);
            this.fPositionManager.managePosition(position);
            ++i;
        }
    }

    private void unmanagePositions(List<Position> positions) {
        if (this.fPositionManager == null) {
            return;
        }
        int sz = this.fPositions.size();
        int i = 0;
        while (i < sz) {
            Position position = positions.get(i);
            this.fPositionManager.unmanagePosition(position);
            ++i;
        }
    }

    public void dispose() {
        this.fIsActive = false;
        this.fTextViewer = null;
        this.fTextWidget = null;
        this.fCursorLine = null;
        this.fLastCursorLine = null;
        this.fPositions = null;
        this.fLastPositions = null;
        this.fChangedPositions = null;
        this.fColorMap = null;
    }

    public boolean isDisposed() {
        return this.fTextViewer == null;
    }

    public void paint(int reason) {
        List<Position> changedPositions;
        IDocument document = this.fTextViewer.getDocument();
        if (document == null) {
            this.deactivate(false);
            return;
        }
        this.activate(false);
        if (this.fCursorLineEnabled) {
            int endLine;
            StyledText textWidget = this.fTextViewer.getTextWidget();
            Point selection = textWidget.getSelection();
            int startLine = textWidget.getLineAtOffset(selection.x);
            if (startLine != (endLine = textWidget.getLineAtOffset(selection.y))) {
                this.redrawPositions(Collections.singletonList(this.fLastCursorLine));
                this.fCursorLineActive = false;
            } else {
                this.fCursorLineActive = true;
            }
            if (this.fCursorLineActive) {
                if (!this.fLastCursorLine.equals((Object)this.fCursorLine)) {
                    this.redrawPositions(Collections.singletonList(this.fLastCursorLine));
                    this.fLastCursorLine.offset = this.fCursorLine.offset;
                    this.fLastCursorLine.length = this.fCursorLine.length;
                }
                this.updateCursorLine();
            }
        }
        if ((changedPositions = this.getChangedPositions()) != null) {
            this.redrawPositions(changedPositions);
            this.updatePositions();
            this.redrawPositions(changedPositions);
        }
    }

    private void activate(boolean redraw) {
        if (!this.fIsActive) {
            this.fIsActive = true;
            this.fTextWidget.addLineBackgroundListener((LineBackgroundListener)this);
            if (redraw) {
                if (this.fCursorLineActive) {
                    this.updateCursorLine();
                }
                this.updatePositions();
                this.redrawPositions(this.fPositions);
            }
            this.managePositions(this.fPositions);
        }
    }

    private void updatePositions() {
        int sz = this.fPositions.size();
        int i = 0;
        while (i < sz) {
            Position position = this.fPositions.get(i);
            if (i == this.fLastPositions.size()) {
                copy = new Position(position.offset, position.length);
                copy.isDeleted = position.isDeleted;
                this.fLastPositions.add(copy);
            } else {
                copy = this.fLastPositions.get(i);
                copy.offset = position.offset;
                copy.length = position.length;
                copy.isDeleted = position.isDeleted;
            }
            position.isDeleted = false;
            ++i;
        }
        int diff = this.fLastPositions.size() - sz;
        while (diff > 0) {
            this.fLastPositions.remove(sz + --diff);
        }
    }

    private List<Position> getChangedPositions() {
        if (this.fLastPositions.size() != this.fPositions.size()) {
            return this.fLastPositions;
        }
        List<Position> changedPositions = null;
        int i = 0;
        int sz = this.fPositions.size();
        while (i < sz) {
            Position current;
            Position previous = this.fLastPositions.get(i);
            if (!previous.equals((Object)(current = this.fPositions.get(i)))) {
                if (changedPositions == null) {
                    changedPositions = this.fChangedPositions;
                    changedPositions.clear();
                }
                changedPositions.add(previous);
            }
            ++i;
        }
        return changedPositions;
    }

    private void redrawPositions(List<Position> positions) {
        int minOffset = this.getTopIndexStartOffset();
        int maxOffset = this.fTextViewer.getBottomIndexEndOffset() + 3;
        Rectangle clientArea = this.fTextWidget.getClientArea();
        int width = clientArea.width + this.fTextWidget.getHorizontalPixel();
        int lineHeight = this.fTextWidget.getLineHeight();
        int i = 0;
        int sz = positions.size();
        while (i < sz) {
            int widgetOffset;
            Position position = positions.get(i);
            if (!position.isDeleted() && position.overlapsWith(minOffset, maxOffset - minOffset + 1) && (widgetOffset = this.getWidgetOffset(position.offset)) >= 0 && widgetOffset <= this.fTextWidget.getCharCount()) {
                int height;
                Point upperLeft = this.fTextWidget.getLocationAtOffset(widgetOffset);
                int upperY = Math.max(Math.min(upperLeft.y, clientArea.height), 0);
                if (position.length == 0) {
                    height = lineHeight;
                } else {
                    int widgetEndOffset = Math.min(widgetOffset + position.length, this.fTextWidget.getCharCount());
                    Point lowerRight = this.fTextWidget.getLocationAtOffset(widgetEndOffset);
                    int lowerY = Math.min(lowerRight.y + lineHeight, clientArea.height);
                    height = lowerY - upperY;
                }
                if (height > 0) {
                    this.fTextWidget.redraw(0, upperY, width, height, false);
                }
            }
            ++i;
        }
    }

    private int getTopIndexStartOffset() {
        if (this.fTextWidget != null) {
            int top = this.fTextWidget.getTopIndex();
            top = this.fTextWidget.getOffsetAtLine(Math.min(this.fTextWidget.getLineCount() - 1, top));
            if (top >= 0) {
                return this.getDocumentOffset(top);
            }
        }
        return -1;
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removeLineBackgroundListener((LineBackgroundListener)this);
            if (redraw) {
                this.redrawPositions(this.fLastPositions);
            }
            this.unmanagePositions(this.fPositions);
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
        this.fPositionManager = manager;
    }

    private int getWidgetOffset(int documentOffset) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.modelOffset2WidgetOffset(documentOffset);
        }
        IRegion visible = this.fTextViewer.getVisibleRegion();
        int widgetOffset = documentOffset - visible.getOffset();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset;
    }

    private int getDocumentOffset(int widgetOffset) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        IRegion visible = this.fTextViewer.getVisibleRegion();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset + visible.getOffset();
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        Color color;
        Position match;
        if (this.fTextWidget != null && (match = this.findIncludingPosition(this.getDocumentOffset(event.lineOffset))) != null && (color = this.getColorForPosition(match)) != null) {
            event.lineBackground = color;
        }
    }

    private Color getColorForPosition(Position position) {
        if (position == this.fCursorLine) {
            if (this.fCursorLine.length == 0) {
                return this.fColorMap.get(CURSOR_LINE_TYPE);
            }
        } else {
            if (position instanceof TypedPosition) {
                String type = ((TypedPosition)position).getType();
                return this.fColorMap.get(type);
            }
            return this.fColorMap.get(DEFAULT_TYPE);
        }
        return null;
    }

    private Position findIncludingPosition(int offset) {
        int i = this.fCursorLineActive ? 0 : 1;
        int sz = this.fPositions.size();
        while (i < sz) {
            Position position = this.fPositions.get(i);
            if (position.offset == offset || position.includes(offset)) {
                return position;
            }
            ++i;
        }
        return null;
    }

    private void updateCursorLine() {
        try {
            IDocument document = this.fTextViewer.getDocument();
            if (document != null) {
                int lineNumber = document.getLineOfOffset(this.getDocumentOffset(this.fTextWidget.getCaretOffset()));
                this.fCursorLine.isDeleted = false;
                this.fCursorLine.offset = document.getLineOffset(lineNumber);
                this.fCursorLine.length = 0;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

