/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.folding;

import java.util.function.Supplier;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.model.FoldingRules;
import org.eclipse.tm4e.languageconfiguration.internal.model.LanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.model.RegExPattern;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;

public final class FoldingSupport {
    public static @Nullable FoldingRules getFoldingRules(IDocument doc) {
        ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)doc);
        return info == null ? null : FoldingSupport.getFoldingRules(info);
    }

    public static @Nullable FoldingRules getFoldingRules(ContentTypeInfo info) {
        return FoldingSupport.computeFoldingRules(info.getContentTypes(), () -> FoldingSupport.findGrammar(info));
    }

    public static @Nullable FoldingRules getFoldingRules(IContentType ... types) {
        return FoldingSupport.computeFoldingRules(types, () -> FoldingSupport.findGrammar(types));
    }

    private static @Nullable FoldingRules computeFoldingRules(IContentType[] contentTypes, Supplier<@Nullable IGrammar> grammarProvider) {
        String end;
        String start;
        block8: {
            IGrammar grammar;
            block7: {
                if (contentTypes.length == 0) {
                    return null;
                }
                LanguageConfiguration langCfg = LanguageConfigurationRegistryManager.getInstance().getLanguageConfigurationFor(contentTypes);
                if (langCfg != null && langCfg.getFolding() != null) {
                    return langCfg.getFolding();
                }
                grammar = grammarProvider.get();
                if (grammar == null) {
                    return null;
                }
                try {
                    start = grammar.getFoldingStartMarker();
                    if (start != null && !start.isBlank()) break block7;
                    return null;
                }
                catch (TMException ex) {
                    LanguageConfigurationPlugin.logError(ex);
                    return null;
                }
            }
            end = grammar.getFoldingEndMarker();
            if (end != null && !end.isBlank()) break block8;
            return null;
        }
        return new FoldingRules(false, RegExPattern.of(start), RegExPattern.of(end));
    }

    private static @Nullable IGrammar findGrammar(ContentTypeInfo info) {
        String ext;
        IGrammar grammar = FoldingSupport.findGrammar(info.getContentTypes());
        if (grammar == null && (ext = new Path(info.getFileName()).getFileExtension()) != null) {
            grammar = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarForFileExtension(ext);
        }
        return grammar;
    }

    private static @Nullable IGrammar findGrammar(IContentType[] types) {
        return TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarFor(types);
    }

    private FoldingSupport() {
    }
}

