/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.interfaces.EntityLayout;

public class HorizontalShiftAlgorithm
extends AbstractLayoutAlgorithm {
    private static final double DELTA = 10.0;
    private static final double VSPACING = 16.0;

    @Override
    public void applyLayout(boolean clean) {
        EntityLayout[] entities;
        if (!clean) {
            return;
        }
        ArrayList<List<EntityLayout>> rowsList = new ArrayList<List<EntityLayout>>();
        EntityLayout[] entityLayoutArray = entities = this.context.getEntities();
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            EntityLayout element = entityLayoutArray[n2];
            HorizontalShiftAlgorithm.addToRowList(element, rowsList);
            ++n2;
        }
        Collections.sort(rowsList, (a0, a1) -> {
            EntityLayout entity0 = (EntityLayout)a0.get(0);
            EntityLayout entity1 = (EntityLayout)a1.get(0);
            return (int)(entity0.getLocation().y - entity1.getLocation().y);
        });
        Comparator entityComparator = (o1, o2) -> (int)(o1.getLocation().y - o2.getLocation().y);
        DisplayIndependentRectangle bounds = this.context.getBounds();
        double heightSoFar = 0.0;
        for (List list : rowsList) {
            Collections.sort(list, entityComparator);
            int i = 0;
            double width = bounds.width / 2.0 - (double)(list.size() * 75);
            heightSoFar += ((EntityLayout)list.get((int)0)).getSize().height + 16.0;
            for (EntityLayout entity : list) {
                DisplayIndependentDimension size = entity.getSize();
                entity.setLocation(width + (double)(10 * ++i) + size.width / 2.0, heightSoFar + size.height / 2.0);
                width += size.width;
            }
        }
    }

    private static void addToRowList(EntityLayout entity, List<List<EntityLayout>> rowsList) {
        double layoutY = entity.getLocation().y;
        for (List<EntityLayout> currentRow : rowsList) {
            EntityLayout currentRowEntity = currentRow.get(0);
            double currentRowY = currentRowEntity.getLocation().y;
            if (!(layoutY >= currentRowY - 10.0) || !(layoutY <= currentRowY + 10.0)) continue;
            currentRow.add(entity);
            return;
        }
        ArrayList<EntityLayout> newRow = new ArrayList<EntityLayout>();
        newRow.add(entity);
        rowsList.add(newRow);
    }
}

