/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.findandreplace.overlay.AccessibleToolBar;
import org.eclipse.ui.internal.findandreplace.overlay.AccessibleToolItem;

class AccessibleToolItemBuilder {
    private final AccessibleToolBar accessibleToolBar;
    private int styleBits = 0;
    private Image image;
    private String toolTipText;
    private List<KeyStroke> shortcuts = Collections.emptyList();
    private Runnable operation;

    public AccessibleToolItemBuilder(AccessibleToolBar accessibleToolBar) {
        this.accessibleToolBar = Objects.requireNonNull(accessibleToolBar);
    }

    public AccessibleToolItemBuilder withStyleBits(int newStyleBits) {
        this.styleBits = newStyleBits;
        return this;
    }

    public AccessibleToolItemBuilder withImage(Image newImage) {
        this.image = newImage;
        return this;
    }

    public AccessibleToolItemBuilder withToolTipText(String newToolTipText) {
        this.toolTipText = newToolTipText;
        return this;
    }

    public AccessibleToolItemBuilder withShortcuts(List<KeyStroke> newShortcuts) {
        this.shortcuts = newShortcuts;
        return this;
    }

    public AccessibleToolItemBuilder withOperation(Runnable newOperation) {
        this.operation = newOperation;
        return this;
    }

    public ToolItem build() {
        AccessibleToolItem accessibleToolItem = this.accessibleToolBar.createToolItem(this.styleBits);
        if (this.image != null) {
            accessibleToolItem.setImage(this.image);
        }
        if (this.toolTipText != null) {
            accessibleToolItem.setToolTipText(this.toolTipText);
        }
        if (this.operation != null) {
            accessibleToolItem.setOperation(this.operation, this.shortcuts);
        }
        return accessibleToolItem.getToolItem();
    }
}

