/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal.local.showin.detectors;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Platform;
import org.eclipse.terminal.view.ui.internal.local.showin.ExternalExecutablesUtils;
import org.eclipse.terminal.view.ui.internal.local.showin.IDetectExternalExecutable;

public class DetectGitBash
implements IDetectExternalExecutable {
    private static final String GIT_BASH = "Git Bash";
    private static boolean gitBashSearchDone = false;

    @Override
    public boolean hasEntries() {
        if ("win32".equals(Platform.getOS())) {
            return this.getGitInstallDirectory().or(this::getGitInstallDirectoryFromPATH).isPresent();
        }
        return false;
    }

    @Override
    public List<Map<String, String>> getEntries(List<Map<String, String>> externalExecutables) {
        if (!gitBashSearchDone && "win32".equals(Platform.getOS())) {
            gitBashSearchDone = true;
            if (externalExecutables.stream().map(m -> (String)m.get("Name")).anyMatch(Predicate.isEqual(GIT_BASH))) {
                return Collections.emptyList();
            }
            Optional<File> result = this.getGitInstallDirectoryFromPATH().or(this::getGitInstallDirectory);
            Optional<String> gitPath = result.map(f -> new File((File)f, "bin/sh.exe").getAbsolutePath());
            Optional iconPath = result.flatMap(f -> DetectGitBash.getGitIconPath(f));
            return gitPath.map(path -> {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("Name", GIT_BASH);
                m.put("Path", (String)path);
                m.put("Args", "--login -i");
                iconPath.ifPresent(icon -> {
                    String string = m.put("Icon", (String)icon);
                });
                m.put("Translate", Boolean.TRUE.toString());
                return List.of(m);
            }).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private Optional<File> getGitInstallDirectoryFromPATH() {
        return ExternalExecutablesUtils.visitPATH(entry -> {
            File check;
            File f = new File((String)entry, "git.exe");
            if (f.canRead() && new File(check = f.getParentFile().getParentFile(), "bin/sh.exe").canExecute()) {
                return Optional.of(check);
            }
            return Optional.empty();
        });
    }

    private Optional<File> getGitInstallDirectory() {
        File f = new File("C:/Program Files/Git/bin/sh.exe");
        if (!f.exists()) {
            f = new File("C:/Program Files (x86)/Git/bin/sh.exe");
        }
        if (f.exists() && f.canExecute()) {
            return Optional.of(f.getParentFile().getParentFile());
        }
        return Optional.empty();
    }

    private static Optional<String> getGitIconPath(File parent) {
        File f = new File(parent, "etc/git.ico");
        if (f.canRead()) {
            return Optional.of(f.getAbsolutePath());
        }
        f = new File(parent, "mingw32/share/git/git-for-windows.ico");
        if (f.canRead()) {
            return Optional.of(f.getAbsolutePath());
        }
        f = new File(parent, "mingw64/share/git/git-for-windows.ico");
        if (f.canRead()) {
            return Optional.of(f.getAbsolutePath());
        }
        return Optional.empty();
    }
}

