/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.util.BlockWriter;
import org.jsoup.nodes.Element;

public class Image
extends AbstractNodeHandler {
    @Override
    public void handleNode(NodeHandler parent, Element node, DocumentConverter converter) {
        String url = converter.cleaner.cleanUrl(node.attr("src"));
        String alt = node.attr("alt");
        if ((alt == null || alt.trim().length() == 0) && (alt = node.attr("title")) == null) {
            alt = "";
        }
        alt = converter.cleaner.clean(alt.trim());
        if (converter.options.inlineLinks) {
            if (alt.length() == 0) {
                alt = "Image";
            }
            converter.output.printf("![%s](%s)", alt, url);
        } else {
            String linkId = converter.addLink(url, alt, true);
            if (alt.length() == 0) {
                alt = linkId;
            }
            BlockWriter out = converter.output;
            if (alt.equals(linkId)) {
                out.printf("![%s][]", linkId);
            } else {
                out.printf("![%s][%s]", alt, linkId);
            }
        }
    }
}

