/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.dynamic.DocumentWriter;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class TocServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Map<String, String> responseByLocale;
    private DocumentWriter writer;
    private static boolean clearCache;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        writer.write(this.processRequest(req, resp));
    }

    protected String processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String response;
        BaseHelpSystem.checkMode();
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        if (clearCache) {
            this.responseByLocale = new WeakHashMap<String, String>();
            clearCache = false;
        }
        if (this.responseByLocale == null) {
            this.responseByLocale = new WeakHashMap<String, String>();
        }
        if ((response = this.responseByLocale.get(locale)) == null) {
            TocContribution[] contributions = HelpPlugin.getTocManager().getTocContributions(locale);
            try {
                response = this.serialize(contributions, locale);
            }
            catch (TransformerException e) {
                throw new ServletException((Throwable)e);
            }
            this.responseByLocale.put(locale, response);
        }
        return response != null ? response : "";
    }

    protected String serialize(TocContribution[] contributions, String locale) throws TransformerException {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<tocContributions>\n");
        if (this.writer == null) {
            this.writer = new DocumentWriter();
        }
        TocContribution[] tocContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            TocContribution contribution = tocContributionArray[n2];
            TocContribution contrib = contribution;
            if (!contrib.isSubToc()) {
                String[] hrefs;
                buf.append("<tocContribution");
                if (contrib.getCategoryId() != null) {
                    buf.append("\n      categoryId=\"" + contrib.getCategoryId() + "\"");
                }
                if (contrib.getContributorId() != null) {
                    buf.append("\n      contributorId=\"" + contrib.getContributorId() + "\"");
                }
                buf.append("\n      id=\"" + contrib.getId() + "\"");
                buf.append("\n      locale=\"" + contrib.getLocale() + "\"");
                buf.append("\n      isPrimary=\"" + contrib.isPrimary() + "\">\n");
                buf.append(this.writer.writeString((UAElement)((Toc)contrib.getToc()), false));
                String[] stringArray = hrefs = contrib.getExtraDocuments();
                int n3 = hrefs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String href = stringArray[n4];
                    buf.append("   <extraDocument href=\"" + href + "\"/>\n");
                    ++n4;
                }
                buf.append("</tocContribution>\n");
            }
            ++n2;
        }
        buf.append("</tocContributions>\n");
        return buf.toString();
    }

    public static void clearCache() {
        clearCache = true;
    }
}

