/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Enumeration;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionContainer;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionManagementException;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionProxy;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLModelUpdater {
    private int diff = 0;
    private int gapLength = 0;
    private int gapOffset = 0;
    private IStructuredDocumentRegion gapStructuredDocumentRegion = null;
    private ISourceGenerator generator = null;
    private DOMModelImpl model = null;
    private NodeImpl nextNode = null;
    private NodeImpl parentNode = null;

    protected XMLModelUpdater(DOMModelImpl model) {
        if (model != null) {
            this.model = model;
            this.generator = model.getGenerator();
        }
    }

    private void changeAttrName(Attr attrNode) {
        ITextRegion nameRegion;
        int offset;
        if (attrNode == null) {
            return;
        }
        AttrImpl attr = (AttrImpl)attrNode;
        ElementImpl element = (ElementImpl)attr.getOwnerElement();
        if (element == null) {
            return;
        }
        if (element.isCommentTag()) {
            this.changeStartTag(element);
            return;
        }
        int start = offset = element.getStartOffset();
        int end = offset;
        String name = attr.getName();
        if (name == null) {
            name = "";
        }
        if ((nameRegion = attr.getNameRegion()) == null) {
            return;
        }
        this.replaceSource(name, start += nameRegion.getStart(), end += nameRegion.getTextEnd());
    }

    private void changeAttrValue(Attr attrNode) {
        int offset;
        if (attrNode == null) {
            return;
        }
        AttrImpl attr = (AttrImpl)attrNode;
        ElementImpl element = (ElementImpl)attr.getOwnerElement();
        if (element == null) {
            return;
        }
        if (element.isCommentTag()) {
            this.changeStartTag(element);
            return;
        }
        int start = offset = element.getStartOffset();
        int end = offset;
        Object value = null;
        ITextRegion valueRegion = attr.getValueRegion();
        if (valueRegion != null) {
            char firstChar;
            char quote = '\u0000';
            IStructuredDocumentRegion documentRegion = element.getFirstStructuredDocumentRegion();
            String oldValue = documentRegion.getText(valueRegion);
            if (oldValue != null && oldValue.length() > 0 && ((firstChar = oldValue.charAt(0)) == '\"' || firstChar == '\'')) {
                quote = firstChar;
            }
            ITextRegion startRegion = valueRegion;
            value = this.generator.generateAttrValue(attr, quote);
            if (value == null) {
                value = "";
                ITextRegion equalRegion = attr.getEqualRegion();
                if (equalRegion != null) {
                    startRegion = equalRegion;
                }
            }
            attr.setValueRegion(valueRegion);
            start += startRegion.getStart();
            end += valueRegion.getTextEnd();
        } else {
            ITextRegion equalRegion = attr.getEqualRegion();
            value = this.generator.generateAttrValue(attr);
            if (value == null) {
                if (equalRegion == null) {
                    return;
                }
                value = "";
                start += equalRegion.getStart();
                end += equalRegion.getTextEnd();
            } else {
                if (equalRegion != null) {
                    start += equalRegion.getTextEnd();
                } else {
                    ITextRegion nameRegion = attr.getNameRegion();
                    if (nameRegion == null) {
                        return;
                    }
                    start += nameRegion.getTextEnd();
                    value = "=" + (String)value;
                }
                end = start;
            }
        }
        this.replaceSource((String)value, start, end);
    }

    void changeEndTag(Element element) {
        int offset;
        String source = this.generator.generateEndTag(element);
        if (source == null) {
            return;
        }
        int length = source.length();
        if (length == 0) {
            return;
        }
        ElementImpl impl = (ElementImpl)element;
        int start = offset = impl.getEndStartOffset();
        int end = offset;
        if (impl.hasEndTag()) {
            end = impl.getEndOffset();
            this.gapStructuredDocumentRegion = impl.getEndStructuredDocumentRegion();
            impl.setEndStructuredDocumentRegion(new StructuredDocumentRegionProxy(offset, length));
        }
        this.replaceSource(source, start, end);
    }

    void changeName(Node node) {
        if (node == null) {
            return;
        }
        if (this.getStructuredDocument() == null) {
            return;
        }
        short nodeType = node.getNodeType();
        if (nodeType == 2) {
            this.changeAttrName((Attr)node);
            return;
        }
    }

    void changeRegion(RegionChangedEvent change, IStructuredDocumentRegion flatNode, ITextRegion region) {
        NodeImpl root;
        if (change.getOffset() >= flatNode.getStartOffset() + region.getTextEnd()) {
            return;
        }
        this.parentNode = root = (NodeImpl)((Object)this.model.getDocument());
        this.nextNode = (NodeImpl)root.getFirstChild();
        this.removeGapStructuredDocumentRegion(flatNode);
        this.insertGapStructuredDocumentRegionBefore(flatNode.getStart());
        this.changeStructuredDocumentRegion(flatNode);
        this.insertGapStructuredDocumentRegionAfter(flatNode.getEnd());
    }

    void changeStartTag(Element element) {
        int offset;
        Node parent;
        if (element == null) {
            return;
        }
        ElementImpl impl = (ElementImpl)element;
        if (!impl.hasStartTag() && !impl.hasEndTag() && (parent = element.getParentNode()) != null) {
            this.replaceChild(parent, element, element);
            return;
        }
        String source = this.generator.generateStartTag(element);
        if (source == null) {
            return;
        }
        int length = source.length();
        if (length == 0) {
            return;
        }
        int start = offset = impl.getStartOffset();
        int end = offset;
        if (impl.hasStartTag()) {
            end = impl.getStartEndOffset();
            this.gapStructuredDocumentRegion = impl.getStartStructuredDocumentRegion();
        }
        impl.setStartStructuredDocumentRegion(new StructuredDocumentRegionProxy(offset, length));
        this.replaceSource(source, start, end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void changeStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        if (oldStructuredDocumentRegion == null) {
            return;
        }
        if (this.parentNode == null) {
            return;
        }
        int oldOffset = oldStructuredDocumentRegion.getStart();
        int oldEnd = oldStructuredDocumentRegion.getEnd();
        boolean isEndTag = false;
        NodeImpl ownerNode = null;
        while (this.parentNode != null) {
            ElementImpl element;
            IStructuredDocumentRegion endStructuredDocumentRegion;
            if (this.nextNode != null) {
                Node child;
                IStructuredDocumentRegion nextStructuredDocumentRegion = this.nextNode.getStructuredDocumentRegion();
                if (nextStructuredDocumentRegion != null) {
                    if (nextStructuredDocumentRegion == oldStructuredDocumentRegion) {
                        ownerNode = this.nextNode;
                        break;
                    }
                    int nextOffset = nextStructuredDocumentRegion.getStart();
                    if (nextOffset == oldOffset) {
                        ownerNode = this.nextNode;
                        break;
                    }
                    if (this.nextNode.getNodeType() == 3) {
                        TextImpl text = (TextImpl)this.nextNode;
                        if (text.hasStructuredDocumentRegion(oldStructuredDocumentRegion)) {
                            ownerNode = this.nextNode;
                            break;
                        }
                        int nextEnd = nextStructuredDocumentRegion.getEnd();
                        if (nextOffset < oldEnd && nextEnd > oldOffset) {
                            ownerNode = this.nextNode;
                            break;
                        }
                    }
                }
                if ((child = this.nextNode.getFirstChild()) != null) {
                    this.parentNode = this.nextNode;
                    this.nextNode = (NodeImpl)child;
                    continue;
                }
                if (this.nextNode.getNodeType() == 1) {
                    this.parentNode = this.nextNode;
                    this.nextNode = null;
                    continue;
                }
                this.nextNode = (NodeImpl)this.nextNode.getNextSibling();
                if (this.nextNode != null) continue;
            }
            if (this.parentNode.getNodeType() == 1 && (endStructuredDocumentRegion = (element = (ElementImpl)this.parentNode).getEndStructuredDocumentRegion()) != null) {
                if (endStructuredDocumentRegion == oldStructuredDocumentRegion) {
                    ownerNode = this.parentNode;
                    isEndTag = true;
                    break;
                }
                int endOffset = endStructuredDocumentRegion.getStart();
                if (endOffset == oldOffset) {
                    ownerNode = this.parentNode;
                    isEndTag = true;
                    break;
                }
            }
            this.nextNode = (NodeImpl)this.parentNode.getNextSibling();
            this.parentNode = (NodeImpl)this.parentNode.getParentNode();
        }
        if (ownerNode == null) {
            throw new StructuredDocumentRegionManagementException();
        }
        short nodeType = ownerNode.getNodeType();
        if (nodeType == 1) {
            ElementImpl element = (ElementImpl)ownerNode;
            if (isEndTag) {
                element.setEndStructuredDocumentRegion(oldStructuredDocumentRegion);
                return;
            } else {
                element.setStartStructuredDocumentRegion(oldStructuredDocumentRegion);
                this.updateAttrRegions(element, oldStructuredDocumentRegion);
            }
            return;
        } else if (nodeType == 3) {
            TextImpl text = (TextImpl)ownerNode;
            IStructuredDocumentRegion flatNode = text.getStructuredDocumentRegion();
            if (flatNode == oldStructuredDocumentRegion) {
                int newOffset = oldOffset;
                int newEnd = oldEnd;
                if (oldOffset == this.gapOffset) {
                    newOffset += this.diff;
                } else {
                    newEnd = this.gapOffset;
                }
                int newLength = newEnd - newOffset;
                StructuredDocumentRegionProxy newStructuredDocumentRegion = new StructuredDocumentRegionProxy(newOffset, newLength, oldStructuredDocumentRegion);
                text.setStructuredDocumentRegion(newStructuredDocumentRegion);
                if (oldEnd <= newEnd) return;
                this.nextNode = (NodeImpl)text.getNextSibling();
                this.changeStructuredDocumentRegion(oldStructuredDocumentRegion);
                return;
            }
            if (flatNode instanceof StructuredDocumentRegionProxy) {
                StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)flatNode;
                int offset = proxy.getOffset();
                int end = offset + proxy.getLength();
                if (proxy.getStructuredDocumentRegion() == null) {
                    if (offset == oldOffset && end == oldEnd) {
                        text.setStructuredDocumentRegion(oldStructuredDocumentRegion);
                        return;
                    } else if (end > oldEnd) {
                        StructuredDocumentRegionContainer container = new StructuredDocumentRegionContainer();
                        container.appendStructuredDocumentRegion(oldStructuredDocumentRegion);
                        proxy.setOffset(oldEnd);
                        proxy.setLength(end - oldEnd);
                        container.appendStructuredDocumentRegion(proxy);
                        text.setStructuredDocumentRegion(container);
                        return;
                    } else {
                        proxy.setStructuredDocumentRegion(oldStructuredDocumentRegion);
                        if (end >= oldEnd) return;
                        this.nextNode = (NodeImpl)text.getNextSibling();
                        this.changeStructuredDocumentRegion(oldStructuredDocumentRegion);
                    }
                    return;
                }
                if (offset >= this.gapOffset) {
                    proxy.setOffset(offset + this.diff);
                    end += this.diff;
                }
                if (end >= oldEnd) return;
                this.nextNode = (NodeImpl)text.getNextSibling();
                this.changeStructuredDocumentRegion(oldStructuredDocumentRegion);
                return;
            }
            if (!(flatNode instanceof StructuredDocumentRegionContainer)) throw new StructuredDocumentRegionManagementException();
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    StructuredDocumentRegionProxy proxy;
                    int offset;
                    int end;
                    if (content == oldStructuredDocumentRegion) {
                        int newOffset = oldOffset;
                        int newEnd = oldEnd;
                        if (oldOffset == this.gapOffset) {
                            newOffset += this.diff;
                        } else {
                            newEnd = this.gapOffset;
                        }
                        int newLength = newEnd - newOffset;
                        StructuredDocumentRegionProxy newStructuredDocumentRegion = new StructuredDocumentRegionProxy(newOffset, newLength, oldStructuredDocumentRegion);
                        container.replaceStructuredDocumentRegion(newStructuredDocumentRegion, i);
                        if (oldEnd <= newEnd) return;
                        this.nextNode = (NodeImpl)text.getNextSibling();
                        this.changeStructuredDocumentRegion(oldStructuredDocumentRegion);
                        return;
                    }
                    if (content instanceof StructuredDocumentRegionProxy && (end = (offset = (proxy = (StructuredDocumentRegionProxy)content).getOffset()) + proxy.getLength()) > oldOffset) {
                        if (proxy.getStructuredDocumentRegion() == null) {
                            if (offset == oldOffset && end == oldEnd) {
                                container.replaceStructuredDocumentRegion(oldStructuredDocumentRegion, i);
                                return;
                            } else if (end > oldEnd) {
                                container.insertStructuredDocumentRegion(oldStructuredDocumentRegion, i);
                                proxy.setOffset(oldEnd);
                                proxy.setLength(end - oldEnd);
                                return;
                            } else {
                                proxy.setStructuredDocumentRegion(oldStructuredDocumentRegion);
                                if (end >= oldEnd) return;
                                this.nextNode = (NodeImpl)text.getNextSibling();
                                this.changeStructuredDocumentRegion(oldStructuredDocumentRegion);
                            }
                            return;
                        }
                        if (offset >= this.gapOffset) {
                            proxy.setOffset(offset + this.diff);
                            end += this.diff;
                        }
                        if (end < oldEnd) {
                            this.nextNode = (NodeImpl)text.getNextSibling();
                            this.changeStructuredDocumentRegion(oldStructuredDocumentRegion);
                            return;
                        }
                    }
                }
                ++i;
            }
            return;
        } else {
            ownerNode.setStructuredDocumentRegion(oldStructuredDocumentRegion);
        }
    }

    private void changeTextData(Text text) {
        if (text == null) {
            return;
        }
        Object source = this.generator.generateSource(text);
        if (source == null) {
            source = "";
        }
        int length = ((String)source).length();
        TextImpl impl = (TextImpl)text;
        int start = impl.getStartOffset();
        int end = impl.getEndOffset();
        int offset = start;
        Node prev = text.getPreviousSibling();
        if (prev != null) {
            String preTag = this.getCloseTag((IDOMNode)prev);
            if (preTag != null && preTag.length() > 0) {
                offset += preTag.length();
                source = preTag + (String)source;
            }
        } else {
            ElementImpl element;
            String preTag;
            Node parent = text.getParentNode();
            if (parent != null && parent.getNodeType() == 1 && (preTag = this.getStartCloseTag(element = (ElementImpl)parent)) != null && preTag.length() > 0) {
                int postLength;
                String postTag;
                offset += preTag.length();
                StringBuffer buffer = new StringBuffer();
                buffer.append(preTag);
                buffer.append((String)source);
                if (text.getNextSibling() == null && !element.hasEndTag() && (element.isJSPContainer() || element.isCDATAContainer()) && (postTag = this.generator.generateEndTag(element)) != null && (postLength = postTag.length()) > 0) {
                    buffer.append(postTag);
                    int postOffset = offset + length;
                    StructuredDocumentRegionProxy flatNode = new StructuredDocumentRegionProxy(postOffset, postLength);
                    element.setEndStructuredDocumentRegion(flatNode);
                }
                source = buffer.toString();
            }
        }
        this.gapStructuredDocumentRegion = impl.getStructuredDocumentRegion();
        StructuredDocumentRegionProxy newStructuredDocumentRegion = null;
        if (length > 0) {
            newStructuredDocumentRegion = new StructuredDocumentRegionProxy(offset, length);
        }
        impl.setStructuredDocumentRegion(newStructuredDocumentRegion);
        this.replaceSource((String)source, start, end);
    }

    void changeValue(Node node) {
        if (node == null) {
            return;
        }
        if (this.getStructuredDocument() == null) {
            return;
        }
        short nodeType = node.getNodeType();
        if (nodeType == 3) {
            this.changeTextData((Text)node);
            return;
        }
        if (nodeType == 2) {
            this.changeAttrValue((Attr)node);
            return;
        }
        if (nodeType == 1) {
            this.changeStartTag((Element)node);
            return;
        }
        String source = this.generator.generateSource(node);
        if (source == null) {
            source = "";
        }
        int length = source.length();
        NodeImpl impl = (NodeImpl)node;
        int start = impl.getStartOffset();
        int end = impl.getEndOffset();
        this.gapStructuredDocumentRegion = impl.getStructuredDocumentRegion();
        StructuredDocumentRegionProxy flatNode = null;
        if (length > 0) {
            flatNode = new StructuredDocumentRegionProxy(start, length);
        }
        impl.setStructuredDocumentRegion(flatNode);
        this.replaceSource(source, start, end);
    }

    private String getAttrValueClose(IDOMElement element) {
        if (element == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = element.getStartStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        ITextRegion region = StructuredDocumentRegionUtil.getLastRegion(flatNode);
        if (region == null || region.getType() != "XML_TAG_ATTRIBUTE_VALUE") {
            return null;
        }
        String value = flatNode.getText(region);
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (length == 0) {
            return null;
        }
        boolean closeJSPTag = false;
        int offset = value.indexOf("<%");
        while (offset >= 0) {
            if ((offset = value.indexOf("%>", offset + 2)) < 0) {
                closeJSPTag = true;
                break;
            }
            offset = value.indexOf("<%", offset + 2);
        }
        boolean closeQuote = false;
        char firstChar = value.charAt(0);
        if (!(firstChar != '\"' && firstChar != '\'' || !closeJSPTag && length != 1 && value.charAt(length - 1) == firstChar)) {
            closeQuote = true;
        }
        if (!closeJSPTag && !closeQuote) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        if (closeJSPTag) {
            buffer.append("%>");
        }
        if (closeQuote) {
            buffer.append(firstChar);
        }
        return buffer.toString();
    }

    private String getCloseTag(IDOMNode node) {
        String endTag;
        int length;
        String closeTag;
        if (node == null || node.isClosed()) {
            return null;
        }
        if (node.getNodeType() != 1) {
            return this.generator.generateCloseTag(node);
        }
        ElementImpl element = (ElementImpl)node;
        if (element.hasEndTag()) {
            return this.generator.generateCloseTag(element);
        }
        int offset = element.getEndOffset();
        StringBuffer buffer = new StringBuffer();
        IDOMNode lastChild = (IDOMNode)element.getLastChild();
        if (lastChild == null) {
            if (!element.isStartTagClosed()) {
                if (element.preferEmptyTag()) {
                    element.setEmptyTag(true);
                }
                if ((closeTag = this.getStartCloseTag(element)) != null && (length = closeTag.length()) > 0) {
                    buffer.append(closeTag);
                    offset += length;
                }
            }
        } else {
            closeTag = this.getCloseTag(lastChild);
            if (closeTag != null && (length = closeTag.length()) > 0) {
                buffer.append(closeTag);
                offset += length;
            }
        }
        if ((endTag = this.generator.generateEndTag(element)) != null && (length = endTag.length()) > 0) {
            buffer.append(endTag);
            StructuredDocumentRegionProxy flatNode = new StructuredDocumentRegionProxy(offset, length);
            element.setEndStructuredDocumentRegion(flatNode);
        }
        return buffer.toString();
    }

    private boolean isSelfClosedContainer(IDOMElement element) {
        CMElementDeclaration node;
        ModelQuery mq;
        if (element.getStartStructuredDocumentRegion() != null && (mq = ModelQueryUtil.getModelQuery(element.getOwnerDocument())) != null && (node = mq.getCMElementDeclaration(element)) != null) {
            return node.getContentType() != 1 && element.getStartStructuredDocumentRegion().getLastRegion().getType() == "XML_EMPTY_TAG_CLOSE";
        }
        return false;
    }

    private String getStartCloseTag(IDOMElement element) {
        String closeTag;
        if (element == null || element.isStartTagClosed()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String attrValueClose = this.getAttrValueClose(element);
        if (attrValueClose != null) {
            buffer.append(attrValueClose);
        }
        if ((closeTag = this.generator.generateCloseTag(element)) != null) {
            buffer.append(closeTag);
        }
        return buffer.toString();
    }

    private IStructuredDocument getStructuredDocument() {
        if (this.model == null) {
            return null;
        }
        return this.model.getStructuredDocument();
    }

    void initialize() {
        this.gapStructuredDocumentRegion = null;
        this.gapOffset = 0;
        this.gapLength = 0;
        this.diff = 0;
        this.parentNode = null;
        this.nextNode = null;
    }

    private void insertGapStructuredDocumentRegionAfter(int endOffset) {
        if (this.gapStructuredDocumentRegion == null) {
            return;
        }
        if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)this.gapStructuredDocumentRegion;
            IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
            if (flatNode != null) {
                this.insertStructuredDocumentRegion(flatNode);
            }
        } else if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)this.gapStructuredDocumentRegion;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null && content.getStart() >= endOffset) {
                    if (content instanceof StructuredDocumentRegionProxy) {
                        StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)content;
                        IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
                        if (flatNode != null) {
                            this.insertStructuredDocumentRegion(flatNode);
                        }
                    } else {
                        this.insertStructuredDocumentRegion(content);
                    }
                }
                ++i;
            }
        } else {
            this.insertStructuredDocumentRegion(this.gapStructuredDocumentRegion);
        }
    }

    private void insertGapStructuredDocumentRegionBefore(int startOffset) {
        if (this.gapStructuredDocumentRegion == null) {
            return;
        }
        if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)this.gapStructuredDocumentRegion;
            IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
            if (flatNode != null) {
                this.insertStructuredDocumentRegion(flatNode);
            }
        } else if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)this.gapStructuredDocumentRegion;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    if (content.getStart() >= startOffset) {
                        return;
                    }
                    if (content instanceof StructuredDocumentRegionProxy) {
                        StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)content;
                        IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
                        if (flatNode != null) {
                            this.insertStructuredDocumentRegion(flatNode);
                        }
                    } else {
                        this.insertStructuredDocumentRegion(content);
                    }
                }
                ++i;
            }
        } else {
            this.insertStructuredDocumentRegion(this.gapStructuredDocumentRegion);
        }
    }

    private void insertStructuredDocumentRegion(IStructuredDocumentRegion newStructuredDocumentRegion) {
        if (newStructuredDocumentRegion == null) {
            return;
        }
        if (this.parentNode == null) {
            return;
        }
        int newOffset = newStructuredDocumentRegion.getStart();
        int newEnd = newStructuredDocumentRegion.getEnd();
        boolean isEndTag = false;
        NodeImpl ownerNode = null;
        while (this.parentNode != null) {
            int endOffset;
            ElementImpl element;
            IStructuredDocumentRegion endStructuredDocumentRegion;
            if (this.nextNode != null) {
                Node child;
                IStructuredDocumentRegion nextStructuredDocumentRegion = this.nextNode.getStructuredDocumentRegion();
                if (nextStructuredDocumentRegion != null) {
                    int nextOffset = nextStructuredDocumentRegion.getStart();
                    if (nextOffset == newOffset) {
                        ownerNode = this.nextNode;
                        break;
                    }
                    if (this.nextNode.getNodeType() == 3) {
                        int nextEnd = nextStructuredDocumentRegion.getEnd();
                        if (nextOffset < newEnd && nextEnd > newOffset) {
                            ownerNode = this.nextNode;
                            break;
                        }
                    }
                }
                if ((child = this.nextNode.getFirstChild()) != null) {
                    this.parentNode = this.nextNode;
                    this.nextNode = (NodeImpl)child;
                    continue;
                }
                if (this.nextNode.getNodeType() == 1) {
                    this.parentNode = this.nextNode;
                    this.nextNode = null;
                    continue;
                }
                this.nextNode = (NodeImpl)this.nextNode.getNextSibling();
                if (this.nextNode != null) continue;
            }
            if (this.parentNode.getNodeType() == 1 && (endStructuredDocumentRegion = (element = (ElementImpl)this.parentNode).getEndStructuredDocumentRegion()) != null && (endOffset = endStructuredDocumentRegion.getStart()) == newOffset) {
                ownerNode = this.parentNode;
                isEndTag = true;
                break;
            }
            this.nextNode = (NodeImpl)this.parentNode.getNextSibling();
            this.parentNode = (NodeImpl)this.parentNode.getParentNode();
        }
        if (ownerNode == null) {
            throw new StructuredDocumentRegionManagementException();
        }
        short nodeType = ownerNode.getNodeType();
        if (nodeType == 1) {
            ElementImpl element = (ElementImpl)ownerNode;
            if (isEndTag) {
                element.setEndStructuredDocumentRegion(newStructuredDocumentRegion);
            } else {
                element.setStartStructuredDocumentRegion(newStructuredDocumentRegion);
                this.updateAttrRegions(element, newStructuredDocumentRegion);
            }
        } else {
            if (nodeType == 3) {
                TextImpl text = (TextImpl)ownerNode;
                IStructuredDocumentRegion oldStructuredDocumentRegion = text.getStructuredDocumentRegion();
                if (oldStructuredDocumentRegion == null) {
                    throw new StructuredDocumentRegionManagementException();
                }
                int oldOffset = oldStructuredDocumentRegion.getStart();
                int oldEnd = oldStructuredDocumentRegion.getEnd();
                if (oldOffset == newOffset && oldEnd == newEnd) {
                    text.setStructuredDocumentRegion(newStructuredDocumentRegion);
                    return;
                }
                if (oldStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
                    StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)oldStructuredDocumentRegion;
                    if (oldEnd > newEnd) {
                        StructuredDocumentRegionContainer container = new StructuredDocumentRegionContainer();
                        if (oldOffset == newOffset) {
                            container.appendStructuredDocumentRegion(newStructuredDocumentRegion);
                        } else {
                            StructuredDocumentRegionProxy newProxy = new StructuredDocumentRegionProxy();
                            newProxy.setOffset(oldOffset);
                            newProxy.setLength(newEnd - oldOffset);
                            newProxy.setStructuredDocumentRegion(newStructuredDocumentRegion);
                            container.appendStructuredDocumentRegion(newProxy);
                        }
                        proxy.setOffset(newEnd);
                        proxy.setLength(oldEnd - newEnd);
                        container.appendStructuredDocumentRegion(proxy);
                        text.setStructuredDocumentRegion(container);
                    } else {
                        proxy.setStructuredDocumentRegion(newStructuredDocumentRegion);
                        if (oldEnd < newEnd) {
                            this.nextNode = (NodeImpl)text.getNextSibling();
                            this.insertStructuredDocumentRegion(newStructuredDocumentRegion);
                        }
                    }
                    return;
                }
                if (oldStructuredDocumentRegion instanceof StructuredDocumentRegionContainer) {
                    StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)oldStructuredDocumentRegion;
                    int count = container.getStructuredDocumentRegionCount();
                    int i = 0;
                    while (i < count) {
                        IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                        if (content != null) {
                            int offset = content.getStart();
                            int end = content.getEnd();
                            if (end > newOffset) {
                                if (offset == newOffset && end == newEnd) {
                                    container.replaceStructuredDocumentRegion(newStructuredDocumentRegion, i);
                                    return;
                                }
                                if (content instanceof StructuredDocumentRegionProxy) {
                                    StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)content;
                                    if (end > newEnd) {
                                        if (offset == newOffset) {
                                            container.insertStructuredDocumentRegion(newStructuredDocumentRegion, i);
                                        } else {
                                            StructuredDocumentRegionProxy newProxy = new StructuredDocumentRegionProxy();
                                            newProxy.setOffset(offset);
                                            newProxy.setLength(newEnd - offset);
                                            newProxy.setStructuredDocumentRegion(newStructuredDocumentRegion);
                                            container.insertStructuredDocumentRegion(newProxy, i);
                                        }
                                        proxy.setOffset(newEnd);
                                        proxy.setLength(end - newEnd);
                                        return;
                                    }
                                    proxy.setStructuredDocumentRegion(newStructuredDocumentRegion);
                                    if (end == newEnd) {
                                        return;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    if (oldEnd < newEnd) {
                        this.nextNode = (NodeImpl)text.getNextSibling();
                        this.insertStructuredDocumentRegion(newStructuredDocumentRegion);
                    }
                    return;
                }
                throw new StructuredDocumentRegionManagementException();
            }
            ownerNode.setStructuredDocumentRegion(newStructuredDocumentRegion);
        }
    }

    private void removeGapStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        if (this.gapStructuredDocumentRegion == null) {
            return;
        }
        if (this.gapStructuredDocumentRegion == oldStructuredDocumentRegion) {
            this.gapStructuredDocumentRegion = null;
            return;
        }
        if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)this.gapStructuredDocumentRegion;
            IStructuredDocumentRegion flatNode = proxy.getStructuredDocumentRegion();
            if (flatNode == oldStructuredDocumentRegion) {
                this.gapStructuredDocumentRegion = null;
            }
        } else if (this.gapStructuredDocumentRegion instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)this.gapStructuredDocumentRegion;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    StructuredDocumentRegionProxy proxy;
                    if (content == oldStructuredDocumentRegion) {
                        if (count > 1) {
                            container.removeStructuredDocumentRegion(i);
                        } else {
                            this.gapStructuredDocumentRegion = null;
                        }
                        return;
                    }
                    if (content instanceof StructuredDocumentRegionProxy && (proxy = (StructuredDocumentRegionProxy)content).getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                        if (count > 1) {
                            container.removeStructuredDocumentRegion(i);
                        } else {
                            this.gapStructuredDocumentRegion = null;
                        }
                        return;
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        if (oldStructuredDocumentRegion == null) {
            return;
        }
        if (this.parentNode == null) {
            return;
        }
        int gapEnd = this.gapOffset + this.gapLength;
        int oldOffset = oldStructuredDocumentRegion.getStart();
        int oldEnd = oldStructuredDocumentRegion.getEnd();
        if (oldOffset >= this.gapOffset && oldEnd <= gapEnd) {
            return;
        }
        int oldLength = oldEnd - oldOffset;
        if (oldOffset >= gapEnd) {
            oldOffset += this.diff;
        }
        NodeImpl ownerNode = null;
        ElementImpl ownerEndTag = null;
        NodeImpl ownerText = null;
        while (this.parentNode != null) {
            ElementImpl element;
            if (this.nextNode != null) {
                TextImpl text;
                if (this.nextNode.getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                    ownerNode = this.nextNode;
                    break;
                }
                if (this.nextNode.getNodeType() == 3 && (text = (TextImpl)this.nextNode).hasStructuredDocumentRegion(oldStructuredDocumentRegion)) {
                    ownerNode = this.nextNode;
                    ownerText = text;
                    break;
                }
                Node child = this.nextNode.getFirstChild();
                if (child != null) {
                    this.parentNode = this.nextNode;
                    this.nextNode = (NodeImpl)child;
                    continue;
                }
                if (this.nextNode.getNodeType() == 1) {
                    this.parentNode = this.nextNode;
                    this.nextNode = null;
                    continue;
                }
                this.nextNode = (NodeImpl)this.nextNode.getNextSibling();
                if (this.nextNode != null) continue;
            }
            if (this.parentNode.getNodeType() == 1 && (element = (ElementImpl)this.parentNode).getEndStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                ownerNode = this.parentNode;
                ownerEndTag = element;
                break;
            }
            this.nextNode = (NodeImpl)this.parentNode.getNextSibling();
            this.parentNode = (NodeImpl)this.parentNode.getParentNode();
        }
        if (ownerNode == null) {
            throw new StructuredDocumentRegionManagementException();
        }
        if (ownerText != null) {
            IStructuredDocumentRegion flatNode = ownerText.getStructuredDocumentRegion();
            if (flatNode == oldStructuredDocumentRegion) {
                StructuredDocumentRegionProxy newStructuredDocumentRegion = new StructuredDocumentRegionProxy(oldOffset, oldLength);
                ((TextImpl)ownerText).setStructuredDocumentRegion(newStructuredDocumentRegion);
                return;
            }
            if (flatNode instanceof StructuredDocumentRegionProxy) {
                StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)flatNode;
                if (proxy.getStructuredDocumentRegion() != oldStructuredDocumentRegion) {
                    throw new StructuredDocumentRegionManagementException();
                }
                int offset = proxy.getOffset();
                int end = offset + proxy.getLength();
                if (offset >= this.gapOffset) {
                    proxy.setOffset(offset + this.diff);
                }
                proxy.setStructuredDocumentRegion(null);
                if (end >= oldEnd || end >= this.gapOffset && oldEnd <= gapEnd) return;
                this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
                return;
            }
            if (!(flatNode instanceof StructuredDocumentRegionContainer)) throw new StructuredDocumentRegionManagementException();
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    StructuredDocumentRegionProxy proxy;
                    if (content == oldStructuredDocumentRegion) {
                        StructuredDocumentRegionProxy newStructuredDocumentRegion = new StructuredDocumentRegionProxy(oldOffset, oldLength);
                        container.replaceStructuredDocumentRegion(newStructuredDocumentRegion, i);
                        return;
                    }
                    if (content instanceof StructuredDocumentRegionProxy && (proxy = (StructuredDocumentRegionProxy)content).getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                        int offset = proxy.getOffset();
                        int end = offset + proxy.getLength();
                        if (offset >= this.gapOffset) {
                            proxy.setOffset(offset + this.diff);
                        }
                        proxy.setStructuredDocumentRegion(null);
                        if (end < oldEnd && (end < this.gapOffset || oldEnd > gapEnd)) {
                            this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
                            return;
                        }
                    }
                }
                ++i;
            }
            return;
        } else {
            StructuredDocumentRegionProxy newStructuredDocumentRegion = new StructuredDocumentRegionProxy(oldOffset, oldLength);
            if (ownerEndTag != null) {
                ownerEndTag.setEndStructuredDocumentRegion(newStructuredDocumentRegion);
                return;
            } else {
                ownerNode.setStructuredDocumentRegion(newStructuredDocumentRegion);
            }
        }
    }

    void replaceAttr(Element ownerElement, Attr newAttr, Attr oldAttr) {
        int offset;
        if (ownerElement == null) {
            return;
        }
        if (this.getStructuredDocument() == null) {
            return;
        }
        ElementImpl element = (ElementImpl)ownerElement;
        if (!element.hasStartTag()) {
            this.changeStartTag(element);
            return;
        }
        if (element.isCommentTag()) {
            this.changeStartTag(element);
            return;
        }
        int start = offset = element.getStartOffset();
        int end = offset;
        boolean insertSpace = false;
        String attrValueClose = null;
        if (oldAttr != null) {
            String regionType;
            AttrImpl impl = (AttrImpl)oldAttr;
            ITextRegion nameRegion = impl.getNameRegion();
            if (nameRegion == null) {
                return;
            }
            ITextRegion lastRegion = impl.getValueRegion();
            if (lastRegion != null) {
                end += lastRegion.getEnd();
            } else {
                lastRegion = impl.getEqualRegion();
                if (lastRegion != null) {
                    end += lastRegion.getEnd();
                } else {
                    end += nameRegion.getEnd();
                    lastRegion = nameRegion;
                }
            }
            IStructuredDocumentRegion flatNode = element.getStartStructuredDocumentRegion();
            if (flatNode == null) {
                return;
            }
            ITextRegionList regions = flatNode.getRegions();
            if (regions == null) {
                return;
            }
            ITextRegion prevRegion = null;
            ITextRegion nextRegion = null;
            int i = 0;
            while (i < regions.size()) {
                ITextRegion region = regions.get(i);
                if (region == nameRegion && i > 0) {
                    prevRegion = regions.get(i - 1);
                }
                if (region == lastRegion) {
                    if (i + 1 >= regions.size()) break;
                    nextRegion = regions.get(i + 1);
                    break;
                }
                ++i;
            }
            boolean isLastAttr = false;
            if (nextRegion != null && ((regionType = nextRegion.getType()) == "XML_TAG_CLOSE" || regionType == "XML_EMPTY_TAG_CLOSE" || this.isNestedTagClose(regionType))) {
                isLastAttr = true;
            }
            start = isLastAttr && prevRegion != null ? (start += prevRegion.getTextEnd()) : (start += nameRegion.getStart());
            impl.resetRegions(element);
        } else {
            IStructuredDocumentRegion flatNode = element.getStartStructuredDocumentRegion();
            if (flatNode == null) {
                return;
            }
            attrValueClose = this.getAttrValueClose(element);
            if (attrValueClose != null && attrValueClose.length() > 0) {
                insertSpace = true;
                end = start = flatNode.getEndOffset();
            } else {
                ITextRegionList regions = flatNode.getRegions();
                if (regions == null) {
                    return;
                }
                int attrStart = 0;
                int i = regions.size() - 1;
                while (i >= 0) {
                    ITextRegion region = regions.get(i);
                    String regionType = region.getType();
                    if (regionType != "XML_TAG_CLOSE" && regionType != "XML_EMPTY_TAG_CLOSE" && !this.isNestedTagClose(regionType)) {
                        int regionEnd = region.getEnd();
                        if (regionEnd == region.getTextEnd()) {
                            insertSpace = true;
                        }
                        attrStart = regionEnd;
                        break;
                    }
                    --i;
                }
                if (attrStart == 0) {
                    return;
                }
                end = start += attrStart;
            }
        }
        String source = null;
        if (newAttr != null) {
            String value;
            String name;
            int size = 2;
            if (attrValueClose != null) {
                size += attrValueClose.length();
            }
            if ((name = this.generator.generateAttrName(newAttr)) != null) {
                size += name.length();
            }
            if ((value = this.generator.generateAttrValue(newAttr)) != null) {
                size += value.length();
            }
            StringBuffer buffer = new StringBuffer(size);
            if (attrValueClose != null) {
                buffer.append(attrValueClose);
            }
            if (insertSpace) {
                buffer.append(' ');
            }
            buffer.append(name);
            if (value != null) {
                buffer.append('=');
                buffer.append(value);
            }
            source = buffer.toString();
        }
        this.replaceSource(source, start, end);
    }

    protected boolean isNestedTagClose(String regionType) {
        boolean result = false;
        return result;
    }

    void replaceChild(Node parentNode, Node newChild, Node oldChild) {
        int length;
        if (parentNode == null) {
            return;
        }
        if (newChild == null && oldChild == null) {
            return;
        }
        if (this.getStructuredDocument() == null) {
            return;
        }
        int start = 0;
        int end = 0;
        String preTag = null;
        String postTag = null;
        ElementImpl postElement = null;
        if (oldChild != null) {
            NodeImpl node = (NodeImpl)oldChild;
            start = node.getStartOffset();
            end = node.getEndOffset();
            if (oldChild.getNodeType() == 3) {
                this.gapStructuredDocumentRegion = node.getStructuredDocumentRegion();
            }
            node.resetStructuredDocumentRegions();
        } else {
            NodeImpl prev = (NodeImpl)newChild.getPreviousSibling();
            if (prev != null) {
                end = start = prev.getEndOffset();
                preTag = this.getCloseTag(prev);
            } else {
                NodeImpl next = (NodeImpl)newChild.getNextSibling();
                if (next != null) {
                    end = start = next.getStartOffset();
                    if (parentNode.getNodeType() == 1) {
                        preTag = this.getStartCloseTag((IDOMElement)parentNode);
                    }
                } else if (parentNode.getNodeType() == 1) {
                    ElementImpl element = (ElementImpl)parentNode;
                    if (element.isEmptyTag() || this.isSelfClosedContainer(element)) {
                        end = element.getEndOffset();
                        start = end - 2;
                        element.setEmptyTag(false);
                        preTag = this.generator.generateCloseTag(element);
                        postTag = this.generator.generateEndTag(element);
                        postElement = element;
                    } else if (!element.hasStartTag()) {
                        end = start = element.getStartOffset();
                        preTag = this.generator.generateStartTag(element);
                        if (preTag != null && (length = preTag.length()) > 0) {
                            StructuredDocumentRegionProxy flatNode = new StructuredDocumentRegionProxy(start, length);
                            element.setStartStructuredDocumentRegion(flatNode);
                        }
                        if (!element.hasEndTag()) {
                            postTag = this.generator.generateEndTag(element);
                            postElement = element;
                        }
                    } else {
                        end = start = element.getStartEndOffset();
                        preTag = this.getStartCloseTag(element);
                        if (preTag != null && preTag.length() > 0 && !element.hasEndTag() && (element.isJSPContainer() || element.isCDATAContainer())) {
                            postTag = this.generator.generateEndTag(element);
                            postElement = element;
                        }
                    }
                }
            }
        }
        String source = null;
        if (newChild != null) {
            int length2;
            StringBuffer buffer = new StringBuffer();
            int offset = start;
            if (preTag != null && (length = preTag.length()) > 0) {
                offset += length;
                buffer.append(preTag);
            }
            NodeImpl node = (NodeImpl)newChild;
            block0: while (node != null) {
                StructuredDocumentRegionProxy flatNode;
                if (node.getNodeType() == 1) {
                    int length3;
                    ElementImpl element = (ElementImpl)node;
                    if (element.preferEmptyTag()) {
                        element.setEmptyTag(true);
                    }
                    StructuredDocumentRegionProxy flatNode2 = null;
                    String startTag = this.generator.generateStartTag(element);
                    if (startTag != null && (length3 = startTag.length()) > 0) {
                        buffer.append(startTag);
                        flatNode2 = new StructuredDocumentRegionProxy(offset, length3);
                        offset += length3;
                    }
                    element.setStartStructuredDocumentRegion(flatNode2);
                } else {
                    String content = this.generator.generateSource(node);
                    if (content == null) {
                        content = "";
                    }
                    int length4 = content.length();
                    flatNode = null;
                    if (length4 > 0) {
                        buffer.append(content);
                        flatNode = new StructuredDocumentRegionProxy(offset, length4);
                        offset += length4;
                    }
                    node.setStructuredDocumentRegion(flatNode);
                }
                NodeImpl child = (NodeImpl)node.getFirstChild();
                if (child != null) {
                    node = child;
                    continue;
                }
                if (node.getNodeType() == 1) {
                    int length5;
                    ElementImpl element = (ElementImpl)node;
                    flatNode = null;
                    String endTag = this.generator.generateEndTag(element);
                    if (endTag != null && (length5 = endTag.length()) > 0) {
                        buffer.append(endTag);
                        flatNode = new StructuredDocumentRegionProxy(offset, length5);
                        offset += length5;
                    }
                    element.setEndStructuredDocumentRegion(flatNode);
                }
                while (node != null) {
                    int length6;
                    if (node == newChild) {
                        node = null;
                        continue block0;
                    }
                    NodeImpl next = (NodeImpl)node.getNextSibling();
                    if (next != null) {
                        node = next;
                        continue block0;
                    }
                    if ((node = (NodeImpl)node.getParentNode()).getNodeType() != 1) continue;
                    ElementImpl element = (ElementImpl)node;
                    StructuredDocumentRegionProxy flatNode3 = null;
                    String endTag = this.generator.generateEndTag(element);
                    if (endTag != null && (length6 = endTag.length()) > 0) {
                        buffer.append(endTag);
                        flatNode3 = new StructuredDocumentRegionProxy(offset, length6);
                        offset += length6;
                    }
                    element.setEndStructuredDocumentRegion(flatNode3);
                }
            }
            if (postTag != null && (length2 = postTag.length()) > 0) {
                buffer.append(postTag);
                if (postElement != null) {
                    StructuredDocumentRegionProxy flatNode = new StructuredDocumentRegionProxy(offset, length2);
                    postElement.setEndStructuredDocumentRegion(flatNode);
                }
            }
            source = buffer.toString();
        }
        if (start == end && (source == null || source.length() == 0)) {
            return;
        }
        this.replaceSource(source, start, end);
    }

    void replaceRegions(IStructuredDocumentRegion flatNode, ITextRegionList newRegions, ITextRegionList oldRegions) {
        NodeImpl root;
        this.parentNode = root = (NodeImpl)((Object)this.model.getDocument());
        this.nextNode = (NodeImpl)root.getFirstChild();
        this.removeGapStructuredDocumentRegion(flatNode);
        this.insertGapStructuredDocumentRegionBefore(flatNode.getStart());
        this.changeStructuredDocumentRegion(flatNode);
        this.insertGapStructuredDocumentRegionAfter(flatNode.getEnd());
    }

    private void replaceSource(String source, int start, int end) {
        int inserted = 0;
        if (source == null) {
            source = "";
        } else {
            inserted = source.length();
        }
        int removed = end - start;
        if (inserted == 0 && removed == 0) {
            return;
        }
        this.gapOffset = start;
        this.gapLength = removed;
        this.diff = inserted - removed;
        this.getStructuredDocument().replaceText((Object)this.model, this.gapOffset, this.gapLength, source, true);
    }

    void replaceStructuredDocumentRegions(IStructuredDocumentRegionList newStructuredDocumentRegions, IStructuredDocumentRegionList oldStructuredDocumentRegions) {
        NodeImpl root = (NodeImpl)((Object)this.model.getDocument());
        if (oldStructuredDocumentRegions != null) {
            this.parentNode = root;
            this.nextNode = (NodeImpl)root.getFirstChild();
            Enumeration e = oldStructuredDocumentRegions.elements();
            while (e.hasMoreElements()) {
                IStructuredDocumentRegion flatNode = (IStructuredDocumentRegion)e.nextElement();
                if (flatNode == null) continue;
                this.removeStructuredDocumentRegion(flatNode);
                this.removeGapStructuredDocumentRegion(flatNode);
            }
        }
        if (newStructuredDocumentRegions != null) {
            this.parentNode = root;
            this.nextNode = (NodeImpl)root.getFirstChild();
            IStructuredDocumentRegion lastStructuredDocumentRegion = null;
            Enumeration e = newStructuredDocumentRegions.elements();
            while (e.hasMoreElements()) {
                IStructuredDocumentRegion flatNode = (IStructuredDocumentRegion)e.nextElement();
                if (flatNode == null) continue;
                if (lastStructuredDocumentRegion == null) {
                    this.insertGapStructuredDocumentRegionBefore(flatNode.getStart());
                }
                this.insertStructuredDocumentRegion(flatNode);
                lastStructuredDocumentRegion = flatNode;
            }
            if (lastStructuredDocumentRegion != null) {
                this.insertGapStructuredDocumentRegionAfter(lastStructuredDocumentRegion.getEnd());
            } else {
                this.insertGapStructuredDocumentRegionBefore(this.gapOffset);
                this.insertGapStructuredDocumentRegionAfter(this.gapOffset);
            }
        } else {
            this.parentNode = root;
            this.nextNode = (NodeImpl)root.getFirstChild();
            this.insertGapStructuredDocumentRegionBefore(this.gapOffset);
            this.insertGapStructuredDocumentRegionAfter(this.gapOffset);
        }
    }

    private void updateAttrRegions(Element element, IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return;
        }
        int index = -1;
        AttrImpl attr = null;
        for (ITextRegion region : regions) {
            String regionType = region.getType();
            if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                if ((attr = (AttrImpl)attributes.item(++index)) == null) continue;
                attr.setNameRegion(region);
                attr.setEqualRegion(null);
                attr.setValueRegion(null);
                continue;
            }
            if (regionType == "XML_TAG_ATTRIBUTE_EQUALS") {
                if (attr == null) continue;
                attr.setEqualRegion(region);
                continue;
            }
            if (regionType != "XML_TAG_ATTRIBUTE_VALUE" || attr == null) continue;
            attr.setValueRegion(region);
            attr = null;
        }
    }
}

