/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.SurroundWithTemplateMenuAction;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionGroup;

public class SurroundWithActionGroup
extends ActionGroup {
    private CEditor fEditor;
    private final String fGroup;

    public SurroundWithActionGroup(CEditor editor, String group) {
        this.fEditor = editor;
        this.fGroup = group;
    }

    public void fillContextMenu(IMenuManager menu) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getLength() == 0) {
            return;
        }
        String menuText = ActionMessages.SurroundWithTemplateMenuAction_SubMenuName;
        MenuManager subMenu = new MenuManager(menuText, "org.eclipse.cdt.ui.edit.text.c.surround.with.quickMenu");
        subMenu.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.surround.with.quickMenu");
        menu.appendToGroup(this.fGroup, (IContributionItem)subMenu);
        subMenu.add((IAction)new Action(){});
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                SurroundWithTemplateMenuAction.fillMenu(manager, SurroundWithActionGroup.this.fEditor);
            }
        });
    }
}

