/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class EngineActivator
implements BundleActivator {
    private static BundleContext context;
    public static String EXTENSIONS;
    public static boolean EXTENDED;
    private static final String LINK_KEY = "link";
    private static final String LINK_FILE_EXTENSION = ".link";
    private static final Set<File> reportedExtensions;
    public static final String ID = "org.eclipse.equinox.p2.engine";
    public static final String PROP_PROFILE_FORMAT = "eclipse.p2.profileFormat";
    public static final String PROFILE_FORMAT_UNCOMPRESSED = "uncompressed";
    public static final String PROP_UNSIGNED_POLICY = "eclipse.p2.unsignedPolicy";
    public static final String UNSIGNED_PROMPT = "prompt";
    public static final String UNSIGNED_FAIL = "fail";
    public static final String UNSIGNED_ALLOW = "allow";
    public static final String P2_FRAGMENT_PROPERTY = "p2.fragment";

    static {
        EXTENSIONS = System.getProperty("p2.fragments");
        EXTENDED = EXTENSIONS != null;
        reportedExtensions = Collections.synchronizedSet(new HashSet(0));
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext aContext) throws Exception {
        context = aContext;
    }

    public void stop(BundleContext aContext) throws Exception {
        context = null;
    }

    public static File[] getExtensionsDirectories() {
        ArrayList<File> files = new ArrayList<File>(0);
        if (EXTENSIONS != null) {
            String[] locationToCheck;
            String[] stringArray = locationToCheck = EXTENSIONS.split(",");
            int n = locationToCheck.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                try {
                    files.addAll(EngineActivator.getInfoFilesFromLocation(location));
                }
                catch (FileNotFoundException e) {
                    LogHelper.log((IStatus)new Status(4, ID, NLS.bind((String)Messages.EngineActivator_0, (Object)location), (Throwable)e));
                }
                catch (IOException e) {
                    LogHelper.log((IStatus)new Status(4, ID, NLS.bind((String)Messages.EngineActivator_0, (Object)location), (Throwable)e));
                }
                catch (URISyntaxException e) {
                    LogHelper.log((IStatus)new Status(4, ID, NLS.bind((String)Messages.EngineActivator_0, (Object)location), (Throwable)e));
                }
                ++n2;
            }
        }
        return files.toArray(new File[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<File> getInfoFilesFromLocation(String locationToCheck) throws IOException, FileNotFoundException, URISyntaxException {
        ArrayList<File> result = new ArrayList<File>(1);
        File extensionsLocation = new File(locationToCheck);
        if (extensionsLocation.exists() && extensionsLocation.isDirectory()) {
            File[] extensions;
            File[] fileArray = extensions = extensionsLocation.listFiles();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                Object link;
                File extension = fileArray[n2];
                if (extension.isFile() && extension.getName().endsWith(LINK_FILE_EXTENSION)) {
                    link = new Properties();
                    Throwable throwable = null;
                    Object var10_11 = null;
                    try (FileInputStream inStream = new FileInputStream(extension);){
                        ((Properties)link).load(inStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    String newInfoName = ((Properties)link).getProperty(LINK_KEY);
                    URI newInfoURI = new URI(newInfoName);
                    File newInfoFile = null;
                    newInfoFile = newInfoURI.isAbsolute() ? new File(newInfoName) : new File(extension.getParentFile(), newInfoName);
                    if (newInfoFile.exists()) {
                        extension = newInfoFile.getParentFile();
                    }
                }
                if (extension.isDirectory()) {
                    if (Files.isWritable(extension.toPath())) {
                        link = reportedExtensions;
                        synchronized (link) {
                            if (!reportedExtensions.contains(extension)) {
                                reportedExtensions.add(extension);
                                LogHelper.log((IStatus)new Status(4, ID, NLS.bind((String)Messages.EngineActivator_1, (Object)extension)));
                            }
                        }
                    } else {
                        File[] listFiles;
                        File[] fileArray2 = listFiles = extension.listFiles();
                        int n3 = listFiles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File file = fileArray2[n4];
                            if (file.getName().endsWith(".info")) {
                                result.add(extension);
                            }
                            ++n4;
                        }
                    }
                } else {
                    Set<File> set = reportedExtensions;
                    synchronized (set) {
                        if (!reportedExtensions.contains(extension)) {
                            reportedExtensions.add(extension);
                            LogHelper.log((IStatus)new Status(2, ID, NLS.bind((String)Messages.EngineActivator_3, (Object)extension)));
                        }
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static String getProperty(String key, IProvisioningAgent agent) {
        if (agent != null) {
            return agent.getProperty(key);
        }
        BundleContext bc = EngineActivator.getContext();
        if (bc != null) {
            return bc.getProperty(key);
        }
        return System.getProperty(key);
    }
}

